/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.dii.component.ui;

import com.sap.ide.eclipse.dii.component.ui.AbstractDCView;
import com.tssap.dii.component.DCToolbox;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.FilterManager;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IMutableFilterSet;
import com.tssap.util.ui.ILabelProviderContainer;
import com.tssap.util.ui.LabelProviderContainer;
import com.tssap.util.ui.viewer.sorter.IViewerSorterContainer;
import com.tssap.util.ui.viewer.sorter.ViewerSorterContainer;
import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;

public class DCGenericView
extends AbstractDCView {
    public static String FILTER_NAME_METADATA = "MetaData";
    public static String FILTER_NAME_RAW = "Raw";
    protected LabelProviderContainer labelProviderContainer;
    protected IViewerSorterContainer viewerSorterContainer;
    protected IMutableFilterSet activeFilterSet;
    protected FilterManager filterManager;

    public DCGenericView() {
        this.initFilter();
    }

    protected void addFilterMenu(final IMenuManager menuManager) {
        final IFilter[] filters = this.filterManager.getFilters();
        final HashMap<String, 1> actions = new HashMap<String, 1>();
        int j = 0;
        while (j < filters.length) {
            final IFilter iFilter = filters[j];
            String iFilterName = iFilter.getName();
            Action iFilterAction = new Action(iFilterName){

                public void run() {
                    int k = 0;
                    while (k < filters.length) {
                        IFilter filter = filters[k];
                        Action action = (Action)actions.get(filter.getName());
                        if (filter.equals(iFilter)) {
                            DCGenericView.this.getActiveFilterSet().addFilter(filter);
                            action.setChecked(true);
                        } else {
                            DCGenericView.this.getActiveFilterSet().removeFilter(filter);
                            action.setChecked(false);
                        }
                        ++k;
                    }
                    menuManager.markDirty();
                    menuManager.update();
                    DCGenericView.this.getTreeViewer().refresh();
                }
            };
            iFilterAction.setChecked(this.getActiveFilterSet().contains(iFilter));
            menuManager.add((IAction)iFilterAction);
            actions.put(iFilterName, iFilterAction);
            ++j;
        }
    }

    protected IMutableFilterSet getActiveFilterSet() {
        return this.activeFilterSet;
    }

    protected void initFilter() {
        this.activeFilterSet = FilterFactory.createAndFilterSet();
        this.filterManager = new FilterManager();
        IFilter projectFilter = DCToolbox.getDCProjectGenericFilter();
        IMutableFilterSet DCMetaDataFilterSet = FilterFactory.createOrFilterSet();
        DCMetaDataFilterSet.addFilter(projectFilter);
        DCMetaDataFilterSet.addFilter(DCToolbox.getDCMetaDataFilter());
        DCMetaDataFilterSet.addFilter(DCToolbox.getDCSpecialFolderFileFilter());
        DCMetaDataFilterSet.setName(FILTER_NAME_METADATA);
        this.filterManager.addFilter((IFilter)DCMetaDataFilterSet);
        IMutableFilterSet DCRawFilterSet = FilterFactory.createOrFilterSet();
        DCRawFilterSet.addFilter(projectFilter);
        DCRawFilterSet.addFilter(DCToolbox.getFolderFileFilter());
        DCRawFilterSet.setName(FILTER_NAME_RAW);
        this.filterManager.addFilter((IFilter)DCRawFilterSet);
        this.activeFilterSet.addFilter((IFilter)DCMetaDataFilterSet);
    }

    protected ILabelProviderContainer getLabelProviderContainer() {
        if (this.labelProviderContainer == null) {
            this.labelProviderContainer = new LabelProviderContainer();
            this.labelProviderContainer.addLabelProvider((ILabelProvider)new DecoratingLabelProvider(DCToolbox.getDCGenericLabelProvider(), DCToolbox.getDCGenericDecoratorProvider()));
            this.labelProviderContainer.addLabelProvider((ILabelProvider)new DecoratingLabelProvider(DCToolbox.getDCMetaDataLabelProvider(), DCToolbox.getDCMetaDataDecoratorProvider()));
            this.labelProviderContainer.addLabelProvider((ILabelProvider)new DecoratingLabelProvider(DCToolbox.getFolderFileLabelProvider(), DCToolbox.getFolderFileDecoratorProvider()));
            this.labelProviderContainer.setDefaultText("?");
        }
        return this.labelProviderContainer;
    }

    public IViewerSorterContainer getViewerSorterContainer() {
        if (this.viewerSorterContainer == null) {
            this.viewerSorterContainer = new ViewerSorterContainer();
            this.viewerSorterContainer.addViewerSorter(DCToolbox.getDCMetaDataSorter());
            this.viewerSorterContainer.addViewerSorter(DCToolbox.getFolderFileSorter());
        }
        return this.viewerSorterContainer;
    }

    public Action getRefreshAction() {
        Action refreshAction = new Action(){

            public void run() {
                DCToolbox.setRefreshMode();
                DCGenericView.this.getTreeViewer().refresh();
                DCToolbox.resetRefreshMode();
            }
        };
        return refreshAction;
    }
}

