/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.dii.component.ui;

import com.sap.ide.eclipse.dii.DiiImages;
import com.sap.ide.eclipse.dii.component.ui.properties.SimpleSelectionConverter;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IMutableFilterSet;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.util.action.path.ContextDependentPathProvider;
import com.tssap.util.action.path.IPathProvider;
import com.tssap.util.ui.ILabelProviderContainer;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.ContextMenu;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import com.tssap.util.ui.viewer.sorter.IViewerSorterContainer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractDCView
extends ViewPart {
    private GenericDataModelFilteredTreeViewer treeViewer;

    public void dispose() {
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.createViewer(parent, this.getActiveFilterSet());
        this.addContextMenu();
        this.addToolBar();
        this.addFilterMenu(this.getViewSite().getActionBars().getMenuManager());
    }

    public void createViewer(Composite parent, IMutableFilterSet treeFilter) {
        GenericDataModelFilteredTreeViewer viewer = GenericDataModelFilteredTreeViewer.createFilteredTreeViewer((Composite)parent, (IFilter)treeFilter);
        viewer.setOptimisticChildrenCheck(false);
        viewer.setDissolveReferences(true);
        viewer.setSkipReferenceCollections(true);
        viewer.setSkipReferences(true);
        viewer.setExpandSingleChildAutomatically(true);
        viewer.setUpdateOnWholeModel(false);
        this.setTreeViewer(viewer);
        TreeViewer treeViewer = viewer.getTreeViewer();
        treeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProviderContainer());
        treeViewer.setSorter((ViewerSorter)this.getViewerSorterContainer());
        SimpleSelectionConverter converter = new SimpleSelectionConverter((ISelectionProvider)treeViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)converter);
    }

    public void addContextMenu() {
        MenuFactory menuFactory = new MenuFactory();
        menuFactory.getPathProviderManager().addPathProvider((IPathProvider)new ContextDependentPathProvider(false));
        DynamicContextMenu dynamicContextMenu = new DynamicContextMenu((IMenuFactory)menuFactory);
        ContextMenu.setContextMenuToStructuredViewer((StructuredViewer)this.getTreeViewer().getTreeViewer(), (IContextMenu)dynamicContextMenu);
    }

    public void addToolBar() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action refreshAction = this.getRefreshAction();
        if (refreshAction != null) {
            refreshAction.setImageDescriptor(DiiImages.getImageDescriptor("Refresh"));
            refreshAction.setToolTipText("Refresh tree");
            toolBarManager.add((IAction)refreshAction);
        }
    }

    public GenericDataModelFilteredTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setFocus() {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().getTree().setFocus();
        }
    }

    protected Action getRefreshAction() {
        return null;
    }

    protected void addFilterMenu(IMenuManager menuManager) {
    }

    protected abstract IMutableFilterSet getActiveFilterSet();

    protected abstract ILabelProviderContainer getLabelProviderContainer();

    protected abstract IViewerSorterContainer getViewerSorterContainer();

    protected void setTreeViewer(GenericDataModelFilteredTreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }
}

