/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.dii.component;

import com.sap.ide.eclipse.dii.DiiPlugin;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.component.DCBuildSettings;
import com.sap.ide.eclipse.dii.component.IProjectUpdatedListener;
import com.sap.ide.eclipse.dii.component.JavaProjectUpdatedEvent;
import com.sap.ide.eclipse.dii.component.ProjectUpdatedEvent;
import com.sap.ide.eclipse.dii.messages.MessageUtil;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dii.component.DCProjectInfo;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.io.FilenameFilter;
import java.text.Collator;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ProjectConsistencyManager
implements IRunnableWithProgress {
    private static final Map CLASSPATH_KINDS = new HashMap();
    private static final Map CLASSPATH_CONTENTS = new HashMap();
    private static Map theConsistencyManagers = new HashMap();
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$dii$component$ProjectConsistencyManager == null ? (class$com$sap$ide$eclipse$dii$component$ProjectConsistencyManager = ProjectConsistencyManager.class$("com.sap.ide.eclipse.dii.component.ProjectConsistencyManager")) : class$com$sap$ide$eclipse$dii$component$ProjectConsistencyManager));
    private IDevelopmentConfiguration theDCConfig;
    private ArrayList theProjectUpdateListeners;
    static /* synthetic */ Class class$com$sap$ide$eclipse$dii$component$ProjectConsistencyManager;

    private ProjectConsistencyManager(IDevelopmentConfiguration aDCConfig) {
        CLASSPATH_KINDS.put(new Integer(5), "CPE_CONTAINER");
        CLASSPATH_KINDS.put(new Integer(1), "CPE_LIBRARY");
        CLASSPATH_KINDS.put(new Integer(2), "CPE_PROJECT");
        CLASSPATH_KINDS.put(new Integer(3), "CPE_SOURCE");
        CLASSPATH_KINDS.put(new Integer(4), "CPE_VARIABLE");
        CLASSPATH_CONTENTS.put(new Integer(1), "K_SOURCE");
        CLASSPATH_CONTENTS.put(new Integer(2), "K_BINARY");
        this.theProjectUpdateListeners = new ArrayList();
        this.theDCConfig = aDCConfig;
    }

    public static final synchronized ProjectConsistencyManager getInstance(IDevelopmentConfiguration aConfiguration) {
        ProjectConsistencyManager theManager = null;
        if (aConfiguration == null) {
            return theManager;
        }
        String theConfigurationName = aConfiguration.getConfigurationData().getName();
        theManager = (ProjectConsistencyManager)theConsistencyManagers.get(theConfigurationName);
        if (theManager == null) {
            theManager = new ProjectConsistencyManager(aConfiguration);
            theConsistencyManagers.put(theConfigurationName, theManager);
        }
        return theManager;
    }

    public void addProjectUpdateListener(IProjectUpdatedListener aListener) {
        ArrayList arrayList = this.theProjectUpdateListeners;
        synchronized (arrayList) {
            if (!this.theProjectUpdateListeners.contains(aListener)) {
                this.theProjectUpdateListeners.add(aListener);
                if (theTracer.debug()) {
                    StringBuffer aBuffer = new StringBuffer();
                    aBuffer.append("Added ProjectUpdatedListener of type:");
                    aBuffer.append(aListener.getClass().getName());
                    theTracer.debug(aBuffer.toString());
                }
            }
        }
    }

    public void removeProjectUpdateListener(IProjectUpdatedListener aListener) {
        ArrayList arrayList = this.theProjectUpdateListeners;
        synchronized (arrayList) {
            ((AbstractCollection)this.theProjectUpdateListeners).remove(aListener);
            if (theTracer.debug()) {
                StringBuffer aBuffer = new StringBuffer();
                aBuffer.append("Removed ProjectUpdatedListener of type:");
                aBuffer.append(aListener.getClass().getName());
                theTracer.debug(aBuffer.toString());
            }
        }
    }

    private void fireProjectUpdatedEvent(ProjectUpdatedEvent theEvent) {
        ArrayList arrayList = this.theProjectUpdateListeners;
        synchronized (arrayList) {
            ArrayList aClone = (ArrayList)this.theProjectUpdateListeners.clone();
            Iterator anIter = ((AbstractList)aClone).iterator();
            while (anIter.hasNext()) {
                IProjectUpdatedListener anListener = (IProjectUpdatedListener)anIter.next();
                anListener.projectUpdated(theEvent);
                if (!theTracer.debug()) continue;
                StringBuffer aBuffer = new StringBuffer();
                aBuffer.append("Informed listener of type : ");
                aBuffer.append(anListener.getClass().getName());
                aBuffer.append("of event:");
                aBuffer.append(theEvent.toString());
                theTracer.debug(aBuffer.toString());
            }
        }
    }

    public void run(IProgressMonitor aMonitor) {
        this.synchronizeProjects(aMonitor);
    }

    public synchronized void synchronizeProjects(IProgressMonitor aMonitor) {
        List theDCsOnDisc = this.theDCConfig.getDevelopmentComponentNodes();
        int theNumberOfDCsOnDisc = theDCsOnDisc.size();
        theTracer.userOut(MessageUtil.getString("User.Message.Start.Synchronizing.Projects"));
        aMonitor.beginTask(MessageUtil.getString("Monitor.Synchronize.Configuration"), theNumberOfDCsOnDisc * 10);
        Iterator anIter = theDCsOnDisc.iterator();
        while (anIter.hasNext()) {
            IDevelopmentComponentNode aLocalDC = (IDevelopmentComponentNode)anIter.next();
            String theDCName = aLocalDC.getName();
            aMonitor.subTask(MessageUtil.format("Monitor.Synchronize.DC", new Object[]{theDCName}));
            IDCProxy aDCProxy = null;
            try {
                aDCProxy = aLocalDC.getDCProxy();
            }
            catch (DevConfigException e) {
                theTracer.error("Failed to get DC Proxy", (Throwable)e);
            }
            DevelopmentComponent aDC = null;
            if (aDCProxy != null && (aDC = aDCProxy.getComponent()) != null) {
                SubProgressMonitor aSubMonitor = new SubProgressMonitor(aMonitor, 9);
                this.synchronizeProject(aDC, (IProgressMonitor)aSubMonitor);
            }
            aMonitor.worked(1);
        }
        aMonitor.done();
        theTracer.userOut(MessageUtil.getString("User.Message.End.Synchronizing.Projects"));
    }

    public synchronized void synchronizeProject(DevelopmentComponent theChangedDC, IProgressMonitor aMonitor) {
        SubProgressMonitor aSubProjectMonitor;
        if (theTracer.debug()) {
            theTracer.debug(MessageUtil.format("Debug.Start.Updating.DCProject", new Object[]{theChangedDC.getName()}));
        }
        aMonitor.beginTask(MessageUtil.format("Monitor.Synchronize.Project.For.DC", new Object[]{theChangedDC.getName()}), 25);
        IProject theProjectOftheChangedDC = this.getProject(theChangedDC);
        if (theProjectOftheChangedDC != null) {
            aMonitor.subTask(MessageUtil.getString("Monitor.Refresh.Project"));
            aSubProjectMonitor = new SubProgressMonitor(aMonitor, 5);
            try {
                theProjectOftheChangedDC.refreshLocal(0, (IProgressMonitor)aSubProjectMonitor);
            }
            catch (CoreException ce) {
                aSubProjectMonitor.done();
                theTracer.warning(MessageUtil.getString("Warning.Could.Not.Refresh.Project"), (Throwable)ce);
            }
        } else {
            aMonitor.worked(5);
        }
        if (theProjectOftheChangedDC != null && theProjectOftheChangedDC.exists()) {
            aMonitor.subTask(MessageUtil.getString("Monitor.Synchronize.Project.Dependendcies"));
            aSubProjectMonitor = new SubProgressMonitor(aMonitor, 9);
            this.synchronizeIProject(theProjectOftheChangedDC, theChangedDC, (IProgressMonitor)aSubProjectMonitor);
            aMonitor.worked(1);
            aMonitor.subTask(MessageUtil.getString("Monitor.Synchronize.Java.Nature"));
            SubProgressMonitor aSubJavaNaturMonitor = new SubProgressMonitor(aMonitor, 9);
            this.synchronizeJavaNature(theProjectOftheChangedDC, theChangedDC, (IProgressMonitor)aSubJavaNaturMonitor);
            aMonitor.worked(1);
        } else {
            aMonitor.worked(20);
            if (theTracer.info()) {
                theTracer.info(MessageUtil.format("Info.No.Project.Found.for.DC", new Object[]{theChangedDC.getName()}));
            }
        }
        aMonitor.done();
        if (theTracer.debug()) {
            theTracer.debug(MessageUtil.format("Debug.Finished.Updating.DCProject", new Object[]{theChangedDC.getName()}));
        }
    }

    private void synchronizeIProject(IProject theProjectOftheChangedDC, DevelopmentComponent theChangedDC, IProgressMonitor aMonitor) {
        IProjectDescription theProjectDescription;
        String theConfigurationName = this.theDCConfig.getConfigurationData().getName();
        Object[] theReferencedProjects = new IProject[]{};
        try {
            theReferencedProjects = theProjectOftheChangedDC.getReferencedProjects();
        }
        catch (CoreException e) {
            theTracer.error(MessageUtil.getString("Exception.Occured"), (Throwable)e);
            theTracer.warning(MessageUtil.getString("Warning.Project.Settings.Wrong"));
        }
        Comparator anProjectComparator = new Comparator(){

            public int compare(Object a, Object b) {
                IProject projectA = (IProject)a;
                IProject projectB = (IProject)b;
                String projectAAsString = projectA.getName();
                String projectBAsString = projectB.getName();
                Collator aCollator = Collator.getInstance();
                return aCollator.compare(projectAAsString, projectBAsString);
            }
        };
        ProjectConsistencyManager.sortArray(theReferencedProjects, anProjectComparator);
        if (theTracer.debug()) {
            this.debugProjectDependenciesSetting((IProject[])theReferencedProjects, true);
        }
        int size = theReferencedProjects.length;
        ArrayList<Object> theNotDCNatureORUsedDCNatureProjects = new ArrayList<Object>();
        int i = 0;
        while (i < size) {
            Object aReferencedProject = theReferencedProjects[i];
            try {
                if (!DCProjectInfo.isDCProject((IProject)aReferencedProject)) {
                    theNotDCNatureORUsedDCNatureProjects.add(aReferencedProject);
                }
            }
            catch (CoreException e) {
                theTracer.error(MessageUtil.getString("Exception.Occured"), (Throwable)e);
                theTracer.warning(MessageUtil.getString("Warning.Project.Settings.Wrong"));
            }
            ++i;
        }
        List theDependencies = theChangedDC.getDependencies();
        if (theDependencies != null) {
            Iterator anIter = theDependencies.iterator();
            while (anIter.hasNext()) {
                String aName;
                Dependency aDependency = (Dependency)anIter.next();
                DCReference aDCRef = aDependency.getComponent();
                String aVendor = aDCRef.getVendor();
                IProject aReferencedProject = this.getProject(theConfigurationName, aVendor, aName = aDCRef.getName());
                if (aReferencedProject == null || theNotDCNatureORUsedDCNatureProjects.contains(aReferencedProject)) continue;
                theNotDCNatureORUsedDCNatureProjects.add(aReferencedProject);
            }
        }
        Collections.sort(theNotDCNatureORUsedDCNatureProjects, anProjectComparator);
        Object[] theReferencedNotDCNatureProjectsORUsedDCNatureProjects = theNotDCNatureORUsedDCNatureProjects.toArray(new IProject[theNotDCNatureORUsedDCNatureProjects.size()]);
        if (!ProjectConsistencyManager.equalArrays(theReferencedProjects, theReferencedNotDCNatureProjectsORUsedDCNatureProjects, anProjectComparator)) {
            if (theTracer.debug()) {
                theTracer.debug("Touching project description!");
            }
            try {
                theProjectDescription = theProjectOftheChangedDC.getDescription();
                theProjectDescription.setReferencedProjects((IProject[])theReferencedNotDCNatureProjectsORUsedDCNatureProjects);
                theProjectOftheChangedDC.setDescription(theProjectDescription, aMonitor);
            }
            catch (CoreException e) {
                theTracer.error(MessageUtil.getString("Exception.Occured"), (Throwable)e);
                theTracer.warning(MessageUtil.getString("Warning.Project.Settings.Wrong"));
            }
        } else if (theTracer.debug()) {
            theTracer.debug("NOT touching project description!");
        }
        if (theTracer.debug()) {
            try {
                theProjectDescription = theProjectOftheChangedDC.getDescription();
                IProject[] theNewRefernecedProjects = theProjectDescription.getReferencedProjects();
                this.debugProjectDependenciesSetting(theNewRefernecedProjects, false);
            }
            catch (CoreException e) {
                theTracer.error(MessageUtil.getString("Exception.Occured"), (Throwable)e);
                theTracer.warning(MessageUtil.getString("Warning.Project.Settings.Wrong"));
            }
        }
    }

    private void synchronizeJavaNature(IProject theProjectOftheChangedDC, DevelopmentComponent theChangedDC, IProgressMonitor aMonitor) {
        aMonitor.beginTask(MessageUtil.getString("Monitor.Updating.Java.Nature"), 30);
        aMonitor.subTask(MessageUtil.getString("Monitor.Collecting.Information"));
        boolean isJava = false;
        try {
            aMonitor.subTask(MessageUtil.getString("Monitor.Collecting.Information.Project"));
            isJava = theProjectOftheChangedDC.hasNature("org.eclipse.jdt.core.javanature");
            aMonitor.worked(3);
        }
        catch (CoreException ce) {
            theTracer.error(MessageUtil.getString("Exception.Occured"), (Throwable)ce);
            theTracer.warning(MessageUtil.getString("Warning.Project.Settings.Wrong"));
            aMonitor.worked(3);
        }
        if (isJava) {
            IDevelopmentComponentNode theDCNodeOfTheChangedDC = null;
            aMonitor.subTask(MessageUtil.getString("Monitor.Collecting.Information.DC"));
            theDCNodeOfTheChangedDC = ComponentUtil.getDCNode(theProjectOftheChangedDC);
            aMonitor.worked(3);
            aMonitor.subTask(MessageUtil.getString("Monitor.Collecting.Information.BuildVariant"));
            String buildVariant = ComponentUtil.getBuildVariant(theProjectOftheChangedDC);
            aMonitor.worked(3);
            DiiPlugin theDiiPlugin = DiiPlugin.getPlugin();
            boolean useJavaProjectDependencies = DCBuildSettings.useJavaProjectreferences();
            if (theDCNodeOfTheChangedDC != null) {
                aMonitor.subTask(MessageUtil.getString("Monitor.Collecting.Information.DCProxy"));
                IDCProxy theProxyOfTheChangedDC = null;
                try {
                    theProxyOfTheChangedDC = theDCNodeOfTheChangedDC.getDCProxy();
                }
                catch (DevConfigException e) {
                    theTracer.error("Failed to get DC proxy", (Throwable)e);
                }
                aMonitor.worked(1);
                if (theProxyOfTheChangedDC != null) {
                    List thePPRoots = theProxyOfTheChangedDC.getUsedCompilationPathList(buildVariant);
                    this.debugListOfPPArchives(theChangedDC, thePPRoots);
                    aMonitor.subTask(MessageUtil.getString("Monitor.Updating.Class.Path"));
                    SubProgressMonitor aClassPathSubMonitor = new SubProgressMonitor(aMonitor, 9);
                    JavaProjectUpdatedEvent anUpdatedEvent = this.synchronizeClasspath(theProjectOftheChangedDC, theChangedDC, thePPRoots, (IProgressMonitor)aClassPathSubMonitor, useJavaProjectDependencies);
                    aMonitor.worked(1);
                    if (anUpdatedEvent != null) {
                        this.fireProjectUpdatedEvent(anUpdatedEvent);
                    } else {
                        aMonitor.worked(10);
                    }
                } else {
                    aMonitor.worked(11);
                }
            }
            aMonitor.subTask(MessageUtil.getString("Monitor.Updating.Source.Path"));
            this.synchronizeSourcePath(theProjectOftheChangedDC, theChangedDC, aMonitor);
            aMonitor.worked(1);
            aMonitor.done();
        } else {
            aMonitor.worked(27);
            aMonitor.done();
        }
    }

    private void synchronizeSourcePath(IProject theProjectOfTheChangedDC, DevelopmentComponent theChangedDC, IProgressMonitor aMonitor) {
        IPath theProjectPath = theProjectOfTheChangedDC.getFullPath();
        ArrayList thePackageFolders = theChangedDC.getPackageFolders();
        if (thePackageFolders == null) {
            thePackageFolders = new ArrayList();
        }
        IJavaProject theJavaProjectOfTheChangedDC = JavaCore.create((IProject)theProjectOfTheChangedDC);
        IClasspathEntry[] theOldClasspath = null;
        try {
            theOldClasspath = theJavaProjectOfTheChangedDC.getRawClasspath();
        }
        catch (JavaModelException jme) {
            theTracer.error("Exception.Occured", (Throwable)jme);
            theTracer.warning(MessageUtil.getString("Warning.Project.Settings.Wrong"));
        }
        if (theTracer.debug()) {
            this.debugSourcepathSetting(theOldClasspath, true);
        }
        ArrayList<IClasspathEntry> theNewClasspath = new ArrayList<IClasspathEntry>();
        int size = theOldClasspath != null ? theOldClasspath.length : 0;
        int i = 0;
        while (i < size) {
            switch (theOldClasspath[i].getEntryKind()) {
                case 3: {
                    if (!this.checkSourcePathConsistency(theOldClasspath[i].getPath().removeFirstSegments(1).toString(), thePackageFolders)) break;
                    theNewClasspath.add(theOldClasspath[i]);
                    break;
                }
                case 4: {
                    theNewClasspath.add(theOldClasspath[i]);
                    break;
                }
                case 2: {
                    theNewClasspath.add(theOldClasspath[i]);
                    break;
                }
                case 1: {
                    theNewClasspath.add(theOldClasspath[i]);
                    break;
                }
                case 5: {
                    theNewClasspath.add(theOldClasspath[i]);
                }
            }
            ++i;
        }
        Iterator anIter = thePackageFolders.iterator();
        while (anIter.hasNext()) {
            String aSourceRootPath = (String)anIter.next();
            IPath theRelativeSourcePath = theProjectPath.append(aSourceRootPath);
            IClasspathEntry anEntryForSourceRoot = JavaCore.newSourceEntry((IPath)theRelativeSourcePath);
            if (theNewClasspath.contains(anEntryForSourceRoot)) continue;
            theNewClasspath.add(anEntryForSourceRoot);
        }
        IClasspathEntry[] theNewClasspathArray = theNewClasspath.toArray(new IClasspathEntry[theNewClasspath.size()]);
        try {
            theJavaProjectOfTheChangedDC.setRawClasspath(theNewClasspathArray, aMonitor);
        }
        catch (JavaModelException jme) {
            theTracer.error(MessageUtil.getString("Exception.Occured"), (Throwable)jme);
            theTracer.warning(MessageUtil.getString("Warning.Project.Settings.Wrong"));
        }
        if (theTracer.debug()) {
            this.debugSourcepathSetting(theNewClasspathArray, false);
        }
    }

    private boolean checkSourcePathConsistency(String aPath, List aListOfNewPaths) {
        boolean result = true;
        Iterator anIter = aListOfNewPaths.iterator();
        while (anIter.hasNext()) {
            String aNewPath = (String)anIter.next();
            if (!aNewPath.startsWith(aPath)) continue;
            result = false;
            break;
        }
        return result;
    }

    private JavaProjectUpdatedEvent synchronizeClasspath(IProject theProjectOfTheChangedDC, DevelopmentComponent aChangedDC, List thePPPaths, IProgressMonitor aMonitor, boolean useProjects) {
        IJavaProject theJavaProjectOfTheChangedDC = JavaCore.create((IProject)theProjectOfTheChangedDC);
        IClasspathEntry[] theOldClasspath = null;
        try {
            theOldClasspath = theJavaProjectOfTheChangedDC.getRawClasspath();
        }
        catch (JavaModelException jme) {
            theTracer.error("Exception.Occured", (Throwable)jme);
            theTracer.warning(MessageUtil.getString("Warning.Project.Settings.Wrong"));
        }
        boolean isJavaType = aChangedDC.getComponentType().getType().equals("Java");
        ArrayList<IClasspathEntry> theNewClasspath = new ArrayList<IClasspathEntry>();
        int size = theOldClasspath != null ? theOldClasspath.length : 0;
        int i = 0;
        while (i < size) {
            switch (theOldClasspath[i].getEntryKind()) {
                case 3: {
                    theNewClasspath.add(theOldClasspath[i]);
                    break;
                }
                case 4: {
                    theNewClasspath.add(theOldClasspath[i]);
                    break;
                }
                case 2: {
                    if (isJavaType) break;
                    theNewClasspath.add(theOldClasspath[i]);
                    break;
                }
                case 1: {
                    break;
                }
                case 5: {
                    theNewClasspath.add(theOldClasspath[i]);
                }
            }
            ++i;
        }
        ArrayList theJavaProjectClasspathEntires = new ArrayList();
        if (useProjects) {
            theJavaProjectClasspathEntires = this.getJavaProjects(aChangedDC);
            theNewClasspath.addAll(theJavaProjectClasspathEntires);
        }
        Iterator anIter = thePPPaths.iterator();
        ArrayList<String> remainingRoots = new ArrayList<String>();
        if (useProjects) {
            theTracer.debug("Start filtering public part dependencies");
        }
        while (anIter.hasNext()) {
            String aAbsoultePathToAPP = (String)anIter.next();
            boolean remains = true;
            String anAbsolutePathToAProject = null;
            Iterator aProjectIter = ((AbstractList)theJavaProjectClasspathEntires).iterator();
            while (aProjectIter.hasNext()) {
                IClasspathEntry aProjectEntry = (IClasspathEntry)aProjectIter.next();
                IProject aProject = this.getProject(aProjectEntry.getPath());
                IPath aProjectLocation = aProject.getLocation();
                anAbsolutePathToAProject = aProjectLocation.toOSString();
                if (!aAbsoultePathToAPP.startsWith(anAbsolutePathToAProject)) continue;
                remains = false;
                break;
            }
            if (remains) {
                remainingRoots.add(aAbsoultePathToAPP);
                continue;
            }
            theTracer.debug("--->Filtered out pp dependency:" + aAbsoultePathToAPP);
        }
        if (useProjects) {
            theTracer.debug("End filtering public part dependencies");
        }
        anIter = remainingRoots.iterator();
        while (anIter.hasNext()) {
            String aPPRootPath = (String)anIter.next();
            ArrayList aListOfReferencedJars = ProjectConsistencyManager.getJars(aPPRootPath);
            theNewClasspath.addAll(aListOfReferencedJars);
        }
        IClasspathEntry[] theNewClasspathArray = theNewClasspath.toArray(new IClasspathEntry[theNewClasspath.size()]);
        JavaProjectUpdatedEvent anEvent = ProjectConsistencyManager.buildJavaNatureUpdatedEvent(theJavaProjectOfTheChangedDC, theOldClasspath, theNewClasspathArray);
        if (anEvent != null) {
            if (theTracer.debug()) {
                this.debugClasspathSetting(theOldClasspath, 0);
            }
            try {
                theJavaProjectOfTheChangedDC.setRawClasspath(theNewClasspathArray, aMonitor);
            }
            catch (JavaModelException jme) {
                theTracer.error(MessageUtil.getString("Exception.Occured"), (Throwable)jme);
                this.debugClasspathSetting(theNewClasspathArray, 2);
                theTracer.warning(MessageUtil.getString("Warning.Project.Settings.Wrong"));
            }
            if (theTracer.debug()) {
                this.debugClasspathSetting(theNewClasspathArray, 1);
            }
        } else if (theTracer.debug()) {
            theTracer.debug("Did not touch classpath!");
        }
        return anEvent;
    }

    private IProject getProject(IPath aPathToAProject) {
        IWorkspace aWorkspace = ResourcesPlugin.getWorkspace();
        IProject aProject = aWorkspace.getRoot().getProject(aPathToAProject.lastSegment());
        return aProject;
    }

    private ArrayList getJavaProjects(DevelopmentComponent aChangedDC) {
        theTracer.debug("Start looking up projects for dependencies of the DC:" + aChangedDC.getName() + "(" + aChangedDC.getVendor() + ")");
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        String theConfigurationName = this.theDCConfig.getConfigurationData().getName();
        List theDependencies = aChangedDC.getDependencies();
        if (theDependencies != null) {
            Iterator anIter = theDependencies.iterator();
            while (anIter.hasNext()) {
                IClasspathEntry anEntry;
                String aName;
                Dependency aDependency = (Dependency)anIter.next();
                DCReference aDCRef = aDependency.getComponent();
                String aVendor = aDCRef.getVendor();
                IProject aReferencedProject = this.getProject(theConfigurationName, aVendor, aName = aDCRef.getName());
                if (aReferencedProject == null || result.contains(anEntry = JavaCore.newProjectEntry((IPath)aReferencedProject.getFullPath()))) continue;
                result.add(anEntry);
                theTracer.debug("--->Found project: " + aReferencedProject.getFullPath().toString());
            }
        }
        theTracer.debug("End looking up projects for dependencies of the DC:" + aChangedDC.getName() + "(" + aChangedDC.getVendor() + ")");
        return result;
    }

    private static JavaProjectUpdatedEvent buildJavaNatureUpdatedEvent(IJavaProject aJavaProject, IClasspathEntry[] anOld, IClasspathEntry[] aNew) {
        ArrayList<IClasspathEntry> theOldPath = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < anOld.length) {
            theOldPath.add(anOld[i]);
            ++i;
        }
        ArrayList<IClasspathEntry> theNewPath = new ArrayList<IClasspathEntry>();
        int k = 0;
        while (k < aNew.length) {
            theNewPath.add(aNew[k]);
            ++k;
        }
        Comparator anComparator = new Comparator(){

            public int compare(Object a, Object b) {
                IClasspathEntry entryA = (IClasspathEntry)a;
                IClasspathEntry entryB = (IClasspathEntry)b;
                String entryAAsString = entryA.getPath().toString();
                String entryBAsString = entryB.getPath().toString();
                Collator aCollator = Collator.getInstance();
                return aCollator.compare(entryAAsString, entryBAsString);
            }
        };
        ArrayList removed = new ArrayList();
        ArrayList added = new ArrayList();
        ProjectConsistencyManager.deltaSet(theOldPath, theNewPath, added, removed, anComparator);
        JavaProjectUpdatedEvent result = null;
        if (removed.size() > 0 || added.size() > 0) {
            JavaProjectUpdatedEvent.ClassPathDelta aDelta = new JavaProjectUpdatedEvent.ClassPathDelta();
            aDelta.added = added.toArray(new IClasspathEntry[added.size()]);
            aDelta.removed = removed.toArray(new IClasspathEntry[removed.size()]);
            result = new JavaProjectUpdatedEvent(aJavaProject, aDelta);
        }
        return result;
    }

    public static void sortArray(Object[] anArray, Comparator anComparator) {
        ArrayList<Object> aList = new ArrayList<Object>();
        int i = 0;
        while (i < anArray.length) {
            aList.add(anArray[i]);
            ++i;
        }
        Collections.sort(aList, anComparator);
        anArray = aList.toArray();
    }

    public static boolean equalArrays(Object[] oldArray, Object[] newArray, Comparator anComparator) {
        if (oldArray.length != newArray.length) {
            return false;
        }
        int size = oldArray.length;
        boolean result = true;
        int i = 0;
        while (i < size && result) {
            result = anComparator.compare(oldArray[i], newArray[i]) == 0;
            ++i;
        }
        return result;
    }

    public static void deltaSet(ArrayList oldSet, ArrayList newSet, ArrayList added, ArrayList removed, Comparator anComparator) {
        int i;
        Collections.sort(oldSet, anComparator);
        Collections.sort(newSet, anComparator);
        int sizeOld = oldSet.size();
        int sizeNew = newSet.size();
        int minSize = sizeNew < sizeOld ? sizeNew : sizeOld;
        int i2 = 0;
        while (i2 < minSize) {
            int l;
            int m;
            int exit;
            if (0 == anComparator.compare(oldSet.get(i2), newSet.get(i2))) {
                // empty if block
            }
            if (anComparator.compare(oldSet.get(i2), newSet.get(i2)) < 0) {
                removed.add(oldSet.get(i2));
                exit = -1;
                m = i2 + 1;
                while (m < sizeOld) {
                    if (anComparator.compare(oldSet.get(m), newSet.get(i2)) < 0) {
                        removed.add(oldSet.get(m));
                    }
                    if (anComparator.compare(oldSet.get(m), newSet.get(i2)) == 0) {
                        exit = m + 1;
                        break;
                    }
                    if (anComparator.compare(oldSet.get(m), newSet.get(i2)) > 0) {
                        added.add(newSet.get(i2));
                        exit = m;
                        break;
                    }
                    ++m;
                }
                l = exit - 1;
                while (l >= i2 + 1) {
                    oldSet.remove(l);
                    --l;
                }
                minSize = newSet.size() < oldSet.size() ? newSet.size() : oldSet.size();
                sizeOld = oldSet.size();
            }
            if (anComparator.compare(oldSet.get(i2), newSet.get(i2)) > 0) {
                added.add(newSet.get(i2));
                exit = -1;
                m = i2 + 1;
                while (m < sizeNew) {
                    if (anComparator.compare(oldSet.get(i2), newSet.get(m)) > 0) {
                        added.add(newSet.get(m));
                    }
                    if (anComparator.compare(oldSet.get(i2), newSet.get(m)) == 0) {
                        exit = m + 1;
                        break;
                    }
                    if (anComparator.compare(oldSet.get(i2), newSet.get(m)) < 0) {
                        removed.add(oldSet.get(i2));
                        exit = m;
                        break;
                    }
                    ++m;
                }
                l = exit - 1;
                while (l >= i2 + 1) {
                    newSet.remove(l);
                    --l;
                }
                minSize = newSet.size() < oldSet.size() ? newSet.size() : oldSet.size();
                sizeNew = newSet.size();
            }
            ++i2;
        }
        if (minSize == newSet.size()) {
            i = minSize;
            while (i < oldSet.size()) {
                removed.add(oldSet.get(i));
                ++i;
            }
        } else {
            i = minSize;
            while (i < newSet.size()) {
                added.add(newSet.get(i));
                ++i;
            }
        }
    }

    private void debugListOfPPArchives(DevelopmentComponent aDependingDC, List aListOfPPs) {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append("The DC : ").append(aDependingDC.getName()).append(" currently uses ").append(aListOfPPs.size()).append(" pp archives: \n");
        Iterator anIter = aListOfPPs.iterator();
        int counter = 0;
        while (anIter.hasNext()) {
            aBuffer.append(++counter).append(": ").append(anIter.next()).append("\n");
        }
        theTracer.debug(aBuffer.toString());
    }

    private void debugClasspathSetting(IClasspathEntry[] theRawClasspath, int mode) {
        int size = theRawClasspath != null ? theRawClasspath.length : 0;
        StringBuffer aBuffer = new StringBuffer("The classpath ");
        switch (mode) {
            case 0: {
                aBuffer.append("before ");
                break;
            }
            case 1: {
                aBuffer.append("after ");
                break;
            }
            case 2: {
                aBuffer.append("that was tried to be set in ");
            }
        }
        aBuffer.append("the synchronization.");
        theTracer.debug(aBuffer.toString());
        int i = 0;
        while (i < size) {
            aBuffer.setLength(0);
            aBuffer.append("-->Class path entry: no. ").append(i).append(" ").append("kind: ").append(CLASSPATH_KINDS.get(new Integer(theRawClasspath[i].getEntryKind()))).append(" ").append("content: ").append(CLASSPATH_CONTENTS.get(new Integer(theRawClasspath[i].getContentKind()))).append(" ").append("path: ").append(theRawClasspath[i].getPath());
            theTracer.debug(aBuffer.toString());
            ++i;
        }
    }

    private void debugProjectDependenciesSetting(IProject[] theReferencedProjects, boolean before) {
        int size = theReferencedProjects != null ? theReferencedProjects.length : 0;
        StringBuffer aBuffer = new StringBuffer("The list of dependencies ");
        aBuffer.append(before ? "before " : "after ");
        aBuffer.append("the synchronization");
        if (size <= 0) {
            aBuffer.append(" is empty!");
        } else {
            aBuffer.append(".");
        }
        theTracer.debug(aBuffer.toString());
        int i = 0;
        while (i < size) {
            aBuffer.setLength(0);
            aBuffer.append("-->Referenced project entry: no. ").append(i).append(" ").append(theReferencedProjects[i].getName());
            theTracer.debug(aBuffer.toString());
            ++i;
        }
    }

    private void debugSourcepathSetting(IClasspathEntry[] theRawClasspath, boolean before) {
        int size = theRawClasspath != null ? theRawClasspath.length : 0;
        StringBuffer aBuffer = new StringBuffer("The sourcepath ");
        aBuffer.append(before ? "before " : "after ");
        aBuffer.append("the synchronization.");
        theTracer.debug(aBuffer.toString());
        int counter = 0;
        int i = 0;
        while (i < size) {
            if (theRawClasspath[i].getEntryKind() == 3) {
                aBuffer.setLength(0);
                aBuffer.append("-->Source entry: no. ").append(counter++).append(" ").append("kind: ").append(CLASSPATH_KINDS.get(new Integer(theRawClasspath[i].getEntryKind()))).append(" ").append("content: ").append(CLASSPATH_CONTENTS.get(new Integer(theRawClasspath[i].getContentKind()))).append(" ").append("path: ").append(theRawClasspath[i].getPath());
                theTracer.debug(aBuffer.toString());
            }
            ++i;
        }
    }

    public static ArrayList getJars(String aPPRootPath) {
        ArrayList<IClasspathEntry> theClasspathEntries = new ArrayList<IClasspathEntry>();
        StringBuffer aBufferJ2SEjars = new StringBuffer(aPPRootPath);
        aBufferJ2SEjars.append("lib").append(System.getProperty("file.separator")).append("java").append(System.getProperty("file.separator"));
        StringBuffer aBufferJ2SEsources = new StringBuffer(aPPRootPath);
        aBufferJ2SEsources.append("src").append(System.getProperty("file.separator")).append("java").append(System.getProperty("file.separator"));
        File theJarFolder = new File(aBufferJ2SEjars.toString());
        File theSourceZipFolder = new File(aBufferJ2SEsources.toString());
        if (theJarFolder.exists() && theJarFolder.isDirectory()) {
            FilenameFilter aJarOrZipFilter = new FilenameFilter(){

                public boolean accept(File aDir, String aFileName) {
                    return aFileName.endsWith(".jar") || aFileName.endsWith(".zip");
                }
            };
            FilenameFilter aZipFilter = new FilenameFilter(){

                public boolean accept(File aDir, String aFileName) {
                    return aFileName.endsWith(".zip");
                }
            };
            File[] thePPJarsOrZips = theJarFolder.listFiles(aJarOrZipFilter);
            File[] thePPSourceZips = theSourceZipFolder.listFiles(aZipFilter);
            int numberOfSourceZips = thePPSourceZips == null ? 0 : thePPSourceZips.length;
            int numberOfJars = thePPJarsOrZips.length;
            int j = 0;
            while (j < numberOfJars) {
                if (thePPJarsOrZips[j].exists()) {
                    IClasspathEntry anEntryForAJar;
                    String aPPJarName = thePPJarsOrZips[j].getName();
                    String aPPJarNameWithoutExtension = aPPJarName.substring(0, aPPJarName.length() - 4);
                    boolean hasSourceAttachment = false;
                    if (j < numberOfSourceZips && thePPSourceZips[j].exists()) {
                        hasSourceAttachment = true;
                    }
                    if ((anEntryForAJar = JavaCore.newLibraryEntry((IPath)new Path(thePPJarsOrZips[j].toString()), (IPath)(hasSourceAttachment ? new Path(thePPSourceZips[j].toString()) : null), null)) != null) {
                        theClasspathEntries.add(anEntryForAJar);
                    }
                }
                ++j;
            }
        } else {
            theTracer.warning(MessageUtil.format("Warning.PublicPart.Root.Folder.Does.Not.Exist", new Object[]{theJarFolder.toString()}));
        }
        return theClasspathEntries;
    }

    private IProject getProject(DevelopmentComponent aChangedDC) {
        String aName = aChangedDC.getName();
        String aVendor = aChangedDC.getVendor();
        return this.getProject(this.theDCConfig.getConfigurationData().getName(), aVendor, aName);
    }

    private IProject getProject(String theConfigurationName, String aDCVendor, String aDCName) {
        IProject theResult = null;
        IWorkspace theWorkSpace = ResourcesPlugin.getWorkspace();
        IProject[] theProjects = theWorkSpace.getRoot().getProjects();
        int size = theProjects.length;
        int i = 0;
        while (i < size) {
            boolean isComponentProject = false;
            try {
                isComponentProject = DCProjectInfo.isDCProject((IProject)theProjects[i]);
            }
            catch (CoreException ce) {
                theTracer.warning(MessageUtil.getString("Warning.Project.Nature.Unknown"), (Throwable)ce);
            }
            if (isComponentProject) {
                String theProjectNameOfTheDC = ComponentUtil.createProjectName(theConfigurationName, aDCName, aDCVendor);
                String theProjectName = theProjects[i].getName();
                if (theProjectName.equals(theProjectNameOfTheDC)) {
                    theResult = theProjects[i];
                    break;
                }
            }
            ++i;
        }
        return theResult;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

