/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.dii.component;

import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.ide.login.UserValidator;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.NameCharacteristic;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.NameNotFoundException;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.net.MalformedURLException;
import javax.naming.CompoundName;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;

public class PackageUtil {
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$dii$component$PackageUtil == null ? (class$com$sap$ide$eclipse$dii$component$PackageUtil = PackageUtil.class$("com.sap.ide.eclipse.dii.component.PackageUtil")) : class$com$sap$ide$eclipse$dii$component$PackageUtil));
    static /* synthetic */ Class class$com$sap$ide$eclipse$dii$component$PackageUtil;

    public static boolean hasPackageFile(IPackageFragment resource) {
        IFile file = PackageUtil.getPackageFile(resource);
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public static IFile getPackageFile(IPackageFragment pack) {
        IProject project = pack.getResource().getProject();
        String packName = pack.getElementName();
        return PackageUtil.getPackageFile(packName, project);
    }

    public static IFile getPackageFile(String packName, IProject project) {
        Workspace workspace = (Workspace)project.getWorkspace();
        String fileName = packName + ".package";
        IPath path = project.getFullPath().append("def/packages/").append(fileName);
        return (IFile)workspace.newResource(path, 1);
    }

    public static IVfsFile getVFSPackageFile(String packName, IProject project) throws VfsException {
        IVfsFolderItem item = null;
        IVfsFolder vfsRootFolder = ComponentUtil.getVfsComponentRootFolder(project);
        if (vfsRootFolder != null && (item = vfsRootFolder.getVersionedFileSystemManager().getFolderItem(PackageUtil.getPackageFile(packName, project).getLocation().toOSString())) != null) {
            return item.asFile();
        }
        return null;
    }

    public static IVfsFile getVFSPackageFile(IPackageFragment resource) throws VfsException {
        IVfsFolderItem item = null;
        IProject project = resource.getJavaProject().getProject();
        IDevelopmentComponentNode dcNode = null;
        try {
            if (project == null || !project.hasNature("com.sap.ide.eclipse.component.provider.dcnature")) {
                return null;
            }
            dcNode = ((IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature")).getDCNode();
        }
        catch (CoreException e) {
            theTracer.warning("get DCNode from package failed", (Throwable)e);
        }
        if (dcNode != null) {
            IVfsFolder folder = null;
            try {
                if (dcNode.hasSourceState()) {
                    folder = dcNode.getVfsComponentRootFolder();
                }
            }
            catch (RepositoryAccessException e) {
                theTracer.warning("get Root Folder failed", (Throwable)e);
            }
            if (folder != null && (item = folder.getVersionedFileSystemManager().getFolderItem(PackageUtil.getPackageFile(resource).getLocation().toOSString())) != null) {
                return item.asFile();
            }
        }
        return null;
    }

    public static boolean createPackageFile(IPackageFragment resource) throws VfsException {
        IVfsFile vfsFile = PackageUtil.getVFSPackageFile(resource);
        final boolean[] result = new boolean[]{true};
        if (vfsFile == null || vfsFile.getLocalFile() == null || !vfsFile.getLocalFile().exists()) {
            try {
                final IFile file = PackageUtil.getPackageFile(resource);
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        File osFile = new File(file.getLocation().toOSString());
                        osFile.getParentFile().mkdirs();
                        try {
                            osFile.createNewFile();
                            file.refreshLocal(0, monitor);
                            file.setDerived(true);
                        }
                        catch (Throwable e) {
                            theTracer.error("Create package representing file failed", e);
                            result[0] = false;
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable e) {
                theTracer.error("Create package representing file failed", e);
                return false;
            }
        } else {
            vfsFile.syncForce();
        }
        return result[0];
    }

    public static CompoundName getPackageName(String flatName, NameAllocator allocator) {
        NameCharacteristic namcha = allocator.getNameCharacteristic("SAP_DesignTimePackage");
        try {
            return allocator.getMyNameServerUtil().createCompoundNameFromString(flatName, namcha);
        }
        catch (NameSyntaxViolation e) {
            theTracer.warning("Creating of Compund Name failed", (Throwable)e);
            return null;
        }
    }

    public static boolean canReservePackageName(String packageName, IProject project) throws CommunicationFailureException {
        NameAllocator allocator = null;
        try {
            allocator = NameServerUtil.getNameAllocator(project);
        }
        catch (MalformedURLException e) {
            theTracer.warning("get Name Allocator failed", (Throwable)e);
        }
        if (allocator != null) {
            try {
                allocator.getAllocationState("SAP_DesignTimePackage", packageName);
            }
            catch (NameNotFoundException e) {
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isPackageNameValid(IPackageFragment resource) throws CommunicationFailureException {
        NameAllocator allocator = null;
        try {
            allocator = NameServerUtil.getNameAllocator(resource.getJavaProject().getProject());
        }
        catch (MalformedURLException e) {
            theTracer.warning("Get Name Allocator failed", (Throwable)e);
        }
        if (allocator != null) {
            try {
                allocator.checkName("SAP_DesignTimePackage", resource.getElementName());
            }
            catch (NameSyntaxViolation e1) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPackageNameReserved(String packageName, IProject project) throws VfsException {
        if (!UserValidator.isDefaultServerOnline()) {
            return true;
        }
        IVfsFile file = PackageUtil.getVFSPackageFile(packageName, project);
        if (file == null) {
            return false;
        }
        return NameServerUtil.isNamereservationSetted(file);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

