/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.dii.component;

import com.sap.ide.eclipse.dii.component.ComponentUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class InfrastructureManager {
    private static boolean initialised = false;
    private static List listeners;

    public static boolean addInitialisationListener(InitialisationListener listener) {
        if (listener.getProject() == null ? InfrastructureManager.isInitialised() : InfrastructureManager.isProjectInitialised(listener.getProject())) {
            return false;
        }
        List list = InfrastructureManager.getListener();
        synchronized (list) {
            InfrastructureManager.getListener().add(listener);
        }
        return true;
    }

    public static void finishInitialisation() {
        initialised = true;
        InfrastructureManager.finishInitLocalModel();
    }

    public static void finishInitLocalModel() {
        if (!InfrastructureManager.isInitialised()) {
            return;
        }
        ArrayList<InitialisationListener> toRemove = new ArrayList<InitialisationListener>();
        List list = InfrastructureManager.getListener();
        synchronized (list) {
            Iterator it = InfrastructureManager.getListener().iterator();
            while (it.hasNext()) {
                InitialisationListener listener = (InitialisationListener)it.next();
                IProject project = listener.getProject();
                if (project != null && !InfrastructureManager.isProjectInitialised(project)) continue;
                listener.initialisationFinished();
                toRemove.add(listener);
            }
            InfrastructureManager.getListener().removeAll(toRemove);
        }
    }

    private static List getListener() {
        if (listeners == null) {
            listeners = new ArrayList();
        }
        return listeners;
    }

    public static boolean isInitialised() {
        return initialised;
    }

    public static boolean isProjectInitialised(IProject project) {
        return InfrastructureManager.isInitialised() && ComponentUtil.getDCNode(project) != null;
    }

    public static interface InitialisationListener {
        public void initialisationFinished();

        public IProject getProject();
    }
}

