/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.dii.component;

import com.sap.ide.eclipse.dii.DiiPlugin;
import com.sap.ide.eclipse.dii.messages.MessageUtil;
import com.sap.ide.login.UserValidator;
import com.tssap.dtr.client.lib.protocol.ssl.util.PKCS12CertificateImport;
import com.tssap.dtr.client.lib.protocol.ssl.util.PKCS7CertificateImport;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DCBuildSettings
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String AUTOMATIC_DC_BUILD_FOR_JAVA_DC = "AutomaticDCBuildForJavaDC";
    public static final String USE_JAVA_CD_PROJECTS = "UseJavaDCProjects";
    public static final String AUTOMATIC_LOGIN = "automaticLogin";
    public static final String SERVER_KEY_STORE = "serverKeyStore";
    private BooleanFieldEditor noDCBuildForJavaDC = null;
    private BooleanFieldEditor useJavaDCprojects = null;
    private BooleanFieldEditor automaticLogin = null;
    private FileFieldEditor serverKeyStoreFile = null;
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$dii$component$DCBuildSettings == null ? (class$com$sap$ide$eclipse$dii$component$DCBuildSettings = DCBuildSettings.class$("com.sap.ide.eclipse.dii.component.DCBuildSettings")) : class$com$sap$ide$eclipse$dii$component$DCBuildSettings));
    static /* synthetic */ Class class$com$sap$ide$eclipse$dii$component$DCBuildSettings;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(DiiPlugin.getPlugin().getPreferenceStore());
        DiiPlugin.getPlugin().getPreferenceStore().setDefault(AUTOMATIC_DC_BUILD_FOR_JAVA_DC, true);
        DiiPlugin.getPlugin().getPreferenceStore().setDefault(USE_JAVA_CD_PROJECTS, false);
        DiiPlugin.getPlugin().getPreferenceStore().setDefault(AUTOMATIC_LOGIN, false);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.noDCBuildForJavaDC = new BooleanFieldEditor(AUTOMATIC_DC_BUILD_FOR_JAVA_DC, MessageUtil.getString("noDCBuildForJavaDC.label"), composite);
        this.noDCBuildForJavaDC.dispose();
        this.noDCBuildForJavaDC.setPreferenceStore(this.getPreferenceStore());
        this.noDCBuildForJavaDC.load();
        Label label = new Label(composite, 0);
        label.setText(MessageUtil.getString("noDCBuildForJavaDC.warning"));
        this.useJavaDCprojects = new BooleanFieldEditor(USE_JAVA_CD_PROJECTS, MessageUtil.getString("useJavaDCProjects.label"), composite);
        this.useJavaDCprojects.setPreferenceStore(this.getPreferenceStore());
        this.useJavaDCprojects.load();
        this.automaticLogin = new BooleanFieldEditor(AUTOMATIC_LOGIN, MessageUtil.getString("automaticLogin.label"), composite);
        this.automaticLogin.setPreferenceStore(this.getPreferenceStore());
        this.automaticLogin.load();
        DCBuildSettings.createSpace(composite);
        this.createCertificatesGroup(composite);
        return composite;
    }

    private void createCertificatesGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = new Group(composite, 16384);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setText("Certificates");
        buttonComposite.setFont(font);
        this.serverKeyStoreFile = new FileFieldEditor(SERVER_KEY_STORE, "Test", (Composite)buttonComposite);
        Label keyLabel = this.serverKeyStoreFile.getLabelControl((Composite)buttonComposite);
        keyLabel.setText("Key Store File:");
        GridData gd = new GridData();
        gd.horizontalIndent = 10;
        keyLabel.setLayoutData((Object)gd);
        this.serverKeyStoreFile.setPreferenceStore(this.getPreferenceStore());
        this.serverKeyStoreFile.load();
    }

    protected static void createSpace(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData((Object)gridData);
    }

    protected static String getKeyStoreFile() {
        if (!DiiPlugin.getPlugin().getPreferenceStore().contains(SERVER_KEY_STORE)) {
            return null;
        }
        return DiiPlugin.getPlugin().getPreferenceStore().getString(SERVER_KEY_STORE);
    }

    public static boolean isUseDCReferencesForJavaDCActiv() {
        if (!DiiPlugin.getPlugin().getPreferenceStore().contains(AUTOMATIC_DC_BUILD_FOR_JAVA_DC)) {
            return true;
        }
        return DiiPlugin.getPlugin().getPreferenceStore().getBoolean(AUTOMATIC_DC_BUILD_FOR_JAVA_DC);
    }

    public static boolean useJavaProjectreferences() {
        if (!DiiPlugin.getPlugin().getPreferenceStore().contains(USE_JAVA_CD_PROJECTS)) {
            return false;
        }
        return DiiPlugin.getPlugin().getPreferenceStore().getBoolean(USE_JAVA_CD_PROJECTS);
    }

    public static boolean promptLogonOnStart() {
        if (!DiiPlugin.getPlugin().getPreferenceStore().contains(AUTOMATIC_LOGIN)) {
            return false;
        }
        return DiiPlugin.getPlugin().getPreferenceStore().getBoolean(AUTOMATIC_LOGIN);
    }

    protected void performApply() {
        this.store();
        super.performApply();
    }

    public boolean performOk() {
        this.store();
        return super.performOk();
    }

    public void store() {
        if (this.noDCBuildForJavaDC != null) {
            this.noDCBuildForJavaDC.store();
        }
        if (this.useJavaDCprojects != null) {
            this.useJavaDCprojects.store();
        }
        if (this.automaticLogin != null) {
            this.automaticLogin.store();
        }
        if (this.serverKeyStoreFile != null) {
            KeyStore keyStore = null;
            boolean success = true;
            try {
                keyStore = DCBuildSettings.loadCertificates(this.serverKeyStoreFile.getStringValue(), null);
            }
            catch (Throwable e) {
                theTracer.error("Load Certificates failed", e);
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Load Certificates failed." + (e.getMessage() != null ? "\n" + e.getMessage() : "") + "\nFor more details see error log."));
                success = false;
            }
            if (success) {
                this.serverKeyStoreFile.store();
                UserValidator.setKeyStore((KeyStore)keyStore);
            }
        }
    }

    protected static KeyStore loadCertificates(String certFile, String password) throws KeyStoreException {
        if (certFile == null || certFile.length() <= 0) {
            return null;
        }
        String fileName = certFile.toLowerCase();
        KeyStore keystore = null;
        try {
            char[] cArray;
            if (fileName.endsWith(".p7b")) {
                FileInputStream certStream = new FileInputStream(certFile);
                return new PKCS7CertificateImport().importCertificates((InputStream)certStream, password);
            }
            if (fileName.endsWith(".p12") || fileName.endsWith(".pfx")) {
                FileInputStream certStream = new FileInputStream(certFile);
                return new PKCS12CertificateImport().importCertificates((InputStream)certStream, password);
            }
            if (fileName.endsWith(".iaik")) {
                keystore = KeyStore.getInstance("IAIKKeyStore", "IAIK");
            } else if (fileName.endsWith(".jceks")) {
                keystore = KeyStore.getInstance("JCEKS", "SunJCE");
            } else if (fileName.equalsIgnoreCase("cacerts")) {
                keystore = KeyStore.getInstance("JKS");
            } else {
                throw new KeyStoreException("Unknown keystore format");
            }
            FileInputStream fileInputStream = new FileInputStream(certFile);
            if (password != null) {
                cArray = password.toCharArray();
            } else {
                char[] cArray2 = new char[4];
                cArray2[0] = 116;
                cArray2[1] = 101;
                cArray2[2] = 115;
                cArray = cArray2;
                cArray2[3] = 116;
            }
            keystore.load(fileInputStream, cArray);
        }
        catch (Exception e) {
            theTracer.warning("loading of keystore failed", (Throwable)e);
            throw new KeyStoreException("Unable to load keystore: " + e.getMessage());
        }
        return keystore;
    }

    public static KeyStore loadCertificates(String password) throws KeyStoreException {
        return DCBuildSettings.loadCertificates(DCBuildSettings.getKeyStoreFile(), null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

