/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.dii.component;

import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dii.component.DCProjectInfo;
import com.tssap.dii.component.DCUtil;
import com.tssap.dii.component.IDCProject;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ComponentUtil {
    public static final char[] NOT_VALID_PROJECT_CHARS = OS.INVALID_RESOURCE_CHARACTERS;
    public static final char[] VALID_PROJECT_CHARS = new char[]{'-', '-', ':', '#', '&', '\'', '(', ')', '!', '#', '#'};
    public static final char VALID_PROJECT_CHAR = '~';
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$dii$component$ComponentUtil == null ? (class$com$sap$ide$eclipse$dii$component$ComponentUtil = ComponentUtil.class$("com.sap.ide.eclipse.dii.component.ComponentUtil")) : class$com$sap$ide$eclipse$dii$component$ComponentUtil));
    static /* synthetic */ Class class$com$sap$ide$eclipse$dii$component$ComponentUtil;

    public static String createProjectName(String ConfigurationName, String DCname, String DCvendor) {
        String name = ConfigurationName + "~" + DCname;
        if (DCvendor != null) {
            name = name + "~" + DCvendor;
        }
        return ComponentUtil.validateProjectName(name);
    }

    public static String createProjectName(IDevelopmentConfiguration config, IDevelopmentComponentNode dcNode) {
        if (config != null && dcNode != null) {
            return ComponentUtil.createProjectName(config.getConfigurationData().getName(), dcNode.getName(), dcNode.getVendor());
        }
        return "?";
    }

    public static String validateProjectName(String projectName) {
        if (projectName == null) {
            return null;
        }
        if (projectName.length() <= 0) {
            projectName = "~";
        }
        int i = 0;
        while (i < NOT_VALID_PROJECT_CHARS.length) {
            projectName = projectName.replace(NOT_VALID_PROJECT_CHARS[i], '~');
            ++i;
        }
        if (Character.isWhitespace(projectName.charAt(0))) {
            char[] temp = projectName.toCharArray();
            temp[0] = 95;
            projectName = new String(temp);
        }
        return projectName;
    }

    public static IDevelopmentConfiguration getParentConfiguration(Element element) {
        return (IDevelopmentConfiguration)element.getObjectPropertyValue("com.sap.ide.eclipse.component.provider.object_parent.configuration.object");
    }

    public static IDevelopmentConfiguration getParentConfiguration(IProject project) {
        try {
            IDCExtendedProject dcPrj;
            if (DCProjectInfo.isDCProject((IProject)project) && (dcPrj = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature")) != null) {
                return dcPrj.getConfiguration();
            }
        }
        catch (CoreException e) {
            theTracer.error("get Configuration failed", (Throwable)e);
        }
        return null;
    }

    public static IDevelopmentConfiguration getParentDevConf(Element element) {
        return (IDevelopmentConfiguration)element.getObjectPropertyValue("com.sap.ide.eclipse.component.provider.object_parent.configuration.object");
    }

    public static IDevelopmentConfiguration getParentDevConf(IProject project) {
        IDevelopmentConfiguration devConfig = null;
        Model model = DCUtil.getProjectModel((IProject)project);
        if (model != null) {
            devConfig = ComponentUtil.getParentDevConf((Element)model);
        }
        return devConfig;
    }

    public static ICompartmentNode getParentCompartmentNode(Element element) {
        return (ICompartmentNode)element.getObjectPropertyValue("com.sap.ide.eclipse.component.provider.object_parent.compartmentnode.object");
    }

    public static ICompartmentNode getParentCompartmentNode(IProject project) {
        ICompartmentNode compNode = null;
        Model model = DCUtil.getProjectModel((IProject)project);
        if (model != null) {
            compNode = ComponentUtil.getParentCompartmentNode((Element)model);
        }
        return compNode;
    }

    public static IDevelopmentComponentNode getParentDCNode(Element element) {
        if (element == null) {
            return null;
        }
        return (IDevelopmentComponentNode)element.getObjectPropertyValue("com.sap.ide.eclipse.component.provider.object_parent.dc.object");
    }

    public static IDevelopmentComponentNode getDCNode(Element element) {
        return ComponentUtil.getParentDCNode(element);
    }

    public static IDevelopmentComponentNode getDCNode(IProject project) {
        try {
            IDCExtendedProject dcPrj;
            if (DCProjectInfo.isDCProject((IProject)project) && (dcPrj = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature")) != null) {
                return dcPrj.getDCNode();
            }
        }
        catch (CoreException e) {
            theTracer.error("get Build Variant failed", (Throwable)e);
        }
        return null;
    }

    public static String getBuildVariant(Element element) {
        return (String)element.getObjectPropertyValue("com.sap.ide.eclipse.component.provider.object_build.variant.object");
    }

    public static String getBuildVariant(IProject project) {
        try {
            IDCProject dcPrj;
            if (DCProjectInfo.isDCProject((IProject)project) && (dcPrj = (IDCProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature")) != null) {
                return dcPrj.getBuildVariant();
            }
        }
        catch (CoreException e) {
            theTracer.error("get Build Variant failed", (Throwable)e);
        }
        return null;
    }

    public static IVfsFolder getVfsComponentRootFolder(IProject project) {
        IVfsFolder vfsComponentRootFolder = null;
        UniqueName projectUin = ModelAccess.createModelUniqueName((String)project.getName());
        if (ModelAccess.hasModel((UniqueName)projectUin)) {
            Model model = ModelAccess.getModel((UniqueName)projectUin);
            vfsComponentRootFolder = (IVfsFolder)model.getObjectPropertyValue("com.sap.ide.eclipse.component.provider.object_vfs.component.root.folder");
        }
        return vfsComponentRootFolder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

