/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsnavigator;

import com.sap.engine.services.webservices.jaxrpc.encoding.AttributeInfo;
import com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo;
import com.sap.engine.services.webservices.jaxrpc.encoding.GeneratedComplexType;
import java.io.Serializable;
import javax.xml.namespace.QName;

public class ClassField
implements Serializable {
    private String typeJavaName;
    private String fieldLocalName;
    private String getterMethod;
    private String setterMethod;
    private boolean nillable;
    private boolean showSendInsteadOfNull = false;
    private String defaultValue;
    private QName xmlType;

    public ClassField(FieldInfo fieldInfo) {
        this.typeJavaName = fieldInfo.getTypeJavaName();
        if (fieldInfo.getMaxOccurs() > 1) {
            this.typeJavaName = this.typeJavaName + "[]";
        }
        this.fieldLocalName = fieldInfo.getFieldLocalName();
        this.getterMethod = fieldInfo.getGetterMethod();
        this.setterMethod = fieldInfo.getSetterMethod();
        this.nillable = fieldInfo.isNillable();
        if (fieldInfo.getMinOccurs() == 0) {
            this.showSendInsteadOfNull = true;
            this.nillable = true;
        }
        this.defaultValue = fieldInfo.getDefaultValue();
        this.xmlType = new QName(fieldInfo.getTypeUri(), fieldInfo.getTypeLocalName());
    }

    public ClassField(AttributeInfo attrInfo) {
        this.typeJavaName = attrInfo.getTypeJavaName();
        this.fieldLocalName = attrInfo.getFieldLocalName();
        this.getterMethod = attrInfo.getGetterMethod();
        this.setterMethod = attrInfo.getSetterMethod();
        this.nillable = false;
        this.defaultValue = attrInfo.getDefaultValue();
        this.xmlType = new QName(attrInfo.getTypeUri(), attrInfo.getTypeName());
    }

    public static ClassField[] getClassFields(GeneratedComplexType complexType) {
        AttributeInfo[] attribs = complexType._getAttributes();
        FieldInfo[] fields = complexType._getFields();
        ClassField[] classFields = new ClassField[attribs.length + fields.length];
        int i = 0;
        while (i < attribs.length) {
            classFields[i] = new ClassField(attribs[i]);
            ++i;
        }
        int offset = attribs.length;
        int i2 = 0;
        while (i2 < fields.length) {
            classFields[i2 + offset] = new ClassField(fields[i2]);
            ++i2;
        }
        return classFields;
    }

    public String getFieldLocalName() {
        return this.fieldLocalName;
    }

    public String getGetterMethod() {
        return this.getterMethod;
    }

    public String getSetterMethod() {
        return this.setterMethod;
    }

    public String getTypeJavaName() {
        return this.typeJavaName;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public QName getXMLType() {
        return this.xmlType;
    }

    public boolean isShowSendInsteadOfNull() {
        return this.showSendInsteadOfNull;
    }
}

