/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.tools;

import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends OutputStream {
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = new byte[]{13, 10};
    public static final byte[] LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
    private OutputStream out;
    private byte[] buffer;
    private int bufferLength;
    private int pos;

    public ChunkedOutputStream(OutputStream out, int chunkSize) {
        if (out == null) {
            throw new NullPointerException("Specified OutputStream cannot be null");
        }
        if (chunkSize <= 0) {
            throw new IndexOutOfBoundsException("The size of the chunk should be positive, passed: " + chunkSize);
        }
        this.out = out;
        this.buffer = new byte[chunkSize];
        this.bufferLength = chunkSize;
        this.pos = 0;
    }

    private void sendChunk() throws IOException {
        byte[] chunkSize = (Integer.toHexString(this.pos) + CRLF).getBytes();
        this.out.write(chunkSize, 0, chunkSize.length);
        this.out.write(this.buffer, 0, this.pos);
        this.out.write(CRLF_BYTES, 0, CRLF_BYTES.length);
        this.pos = 0;
        this.flush();
    }

    private void checkSending() throws IOException {
        if (this.pos == this.buffer.length) {
            this.sendChunk();
            this.pos = 0;
        }
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        while (length > this.bufferLength - this.pos) {
            System.arraycopy(b, offset, this.buffer, this.pos, this.bufferLength - this.pos);
            offset += this.bufferLength - this.pos;
            length -= this.bufferLength - this.pos;
            this.pos += this.bufferLength - this.pos;
            this.sendChunk();
        }
        System.arraycopy(b, offset, this.buffer, this.pos, length);
        this.pos += length;
        this.checkSending();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.buffer[this.pos++] = (byte)b;
        this.checkSending();
    }

    public void close() throws IOException {
        if (this.pos > 0) {
            this.sendChunk();
        }
        this.out.write(LAST_CHUNK, 0, LAST_CHUNK.length);
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public static void main(String[] args) throws Exception {
        ChunkedOutputStream out = new ChunkedOutputStream(System.out, 5);
        int i = 0;
        while (i < 6) {
            out.write(65);
            ++i;
        }
        out.write("AAAAAABBBBBBCCCCCC".getBytes());
        out.close();
    }
}

