/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class Cookie {
    private String name;
    private String value;
    private String comment;
    private String domain;
    private String maxAge;
    private String path;
    private String secure;
    private String version;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(String maxAge) {
        this.maxAge = maxAge;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSecure() {
        return this.secure;
    }

    public void setSecure(String secure) {
        this.secure = secure;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static ArrayList readCookies(String cookieLine) {
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        StringTokenizer tokenizer = new StringTokenizer(cookieLine, ";", false);
        Cookie currentCookie = new Cookie();
        while (tokenizer.hasMoreElements()) {
            int index;
            String token = tokenizer.nextToken().trim();
            if ("Secure".equals(token) || token.startsWith("Max-Age=") || token.startsWith("Comment=")) continue;
            if (token.toUpperCase().startsWith("DOMAIN=")) {
                currentCookie.setDomain(token.substring("Domain=".length()).trim());
                continue;
            }
            if (token.toUpperCase().startsWith("PATH=")) {
                currentCookie.setPath(token.substring("Path=".length()).trim());
                continue;
            }
            if (token.toUpperCase().startsWith("VERSION=")) {
                currentCookie.setVersion(token.substring("Version=".length()).trim());
                continue;
            }
            if ("Discard".equals(token) || token.length() == 0) continue;
            if (currentCookie.getName() != null) {
                result.add(currentCookie);
                currentCookie = new Cookie();
            }
            if ((index = token.indexOf(61)) == -1) continue;
            currentCookie.setName(token.substring(0, index));
            currentCookie.setValue(token.substring(index + 1));
        }
        if (currentCookie.getName() != null) {
            result.add(currentCookie);
        }
        return result;
    }

    public static boolean updateCookies(Cookie newCookie, ArrayList cookies) {
        int i = 0;
        while (i < cookies.size()) {
            Cookie cookieLine = (Cookie)cookies.get(i);
            if (cookieLine.getName().equals(newCookie.getName())) {
                cookieLine.setValue(newCookie.getValue());
                cookieLine.setPath(newCookie.getPath());
                cookieLine.setDomain(newCookie.getDomain());
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void updateCookies(ArrayList newCookies, ArrayList cookies) {
        ArrayList perm = new ArrayList();
        int i = 0;
        while (i < newCookies.size()) {
            if (!Cookie.updateCookies((Cookie)newCookies.get(i), cookies)) {
                perm.add(newCookies.get(i));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < perm.size()) {
            cookies.add(perm.get(i2));
            ++i2;
        }
    }

    public static String getAsRequestString(Cookie[] cookies) {
        String version = null;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < cookies.length) {
            result.append(cookies[i].getName());
            result.append('=');
            result.append(cookies[i].getValue());
            if (cookies[i].getPath() != null) {
                result.append(";$Path=");
                result.append(cookies[i].getPath());
            }
            if (cookies[i].getDomain() != null) {
                result.append(";$Domain=");
                result.append(cookies[i].getDomain());
            }
            if (cookies.length - 1 != i) {
                result.append(';');
            }
            if (cookies[i].getVersion() != null) {
                version = "$Version=" + cookies[i].getVersion();
            }
            ++i;
        }
        return version + result.toString();
    }

    public static String getAsRequestString(Cookie cookie) {
        StringBuffer result = new StringBuffer();
        if (cookie.getVersion() != null) {
            result.append("$Version=");
            result.append(cookie.getVersion());
            result.append(';');
        }
        result.append(cookie.getName());
        result.append('=');
        result.append(cookie.getValue());
        if (cookie.getPath() != null) {
            result.append(";$Path=");
            result.append(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            result.append(";$Domain=");
            result.append(cookie.getDomain());
        }
        return result.toString();
    }
}

