/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.services.webservices.jaxrpc.exceptions.ProxyGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import com.sap.engine.services.webservices.jaxrpc.util.PackageBuilder;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClassGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientTransportBinding;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGeneratorConfig;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.httpgetpost.HttpGetPostBinding;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.MimeHttpBinding;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class ProxyGenerator {
    private PackageBuilder builder = new PackageBuilder();
    private boolean showWarnings = false;

    public void showWarnings() {
        this.showWarnings = true;
    }

    public void hideWarnings() {
        this.showWarnings = false;
    }

    private ClientTransportBinding[] getTransportBindings() {
        ClientTransportBinding[] transportBindings = new ClientTransportBinding[]{new MimeHttpBinding(), new HttpGetPostBinding()};
        return transportBindings;
    }

    private void printWarining(String warningMessage) {
        if (this.showWarnings) {
            System.out.println("Waring : " + warningMessage);
        }
    }

    public void getDefaultSchemaMapping(ProxyGeneratorConfig config) throws ProxyGeneratorException {
        WSDLDefinitions definitions;
        if (config.getWsdlLocation() == null) {
            throw new ProxyGeneratorException("webservices_3202");
        }
        WSDLDOMLoader loader = new WSDLDOMLoader();
        if (config.isUseProxy()) {
            loader.setHttpProxy(config.getProxyHost(), config.getProxyPort());
        }
        if ((definitions = config.getDefinitions()) == null) {
            try {
                definitions = config.getLocationMap() != null ? loader.loadMirrorWSDLDocument(config.getWsdlLocation(), config.getLocationMap()) : loader.loadWSDLDocument(config.getWsdlLocation());
            }
            catch (WSDLException e) {
                throw new ProxyGeneratorException("webservices_3203", (Throwable)((Object)e));
            }
        }
        if (config.getOutputPackage() == null) {
            NameConvertor convertor = new NameConvertor();
            try {
                config.setOutputPackage(convertor.uriToPackage(definitions.getTargetNamespace()));
            }
            catch (Exception e) {
                config.setOutputPackage(null);
            }
        }
        try {
            definitions.loadSchemaInfo();
            if (definitions.getSchemaInfo() != null && config.isUseProxy()) {
                definitions.getSchemaInfo().setHttpProxy(config.getProxyHost(), config.getProxyPort());
            }
            SchemaToJavaGenerator schema = definitions.getSchemaInfo();
            String typesPackage = "types";
            String packageName = config.getOutputPackage();
            if (packageName != null && packageName.length() != 0) {
                typesPackage = packageName + "." + typesPackage;
            }
            if (schema != null) {
                schema.setMirrorLocations(definitions.getMirrorLocations());
                schema.setMirrorMapping(definitions.getMirrorMapping());
                schema.prepareAll(typesPackage);
                config.setUriToPackageMapping(schema.getUriToPackageMapping());
            } else {
                config.setUriToPackageMapping(new Properties());
            }
        }
        catch (Exception e) {
            throw new ProxyGeneratorException("webservices_3204", e);
        }
    }

    public void generateProxy(ProxyGeneratorConfig config) throws ProxyGeneratorException {
        WSDLDefinitions definitions;
        File outputDirFile = new File(config.getTargetDir());
        if (!outputDirFile.exists() && !outputDirFile.mkdirs()) {
            throw new ProxyGeneratorException("webservices_3200", config.getTargetDir());
        }
        if (!outputDirFile.isDirectory()) {
            throw new ProxyGeneratorException("webservices_3201", config.getTargetDir());
        }
        if (config.getWsdlLocation() == null && config.getDefinitions() == null) {
            throw new ProxyGeneratorException("webservices_3202");
        }
        WSDLDOMLoader loader = new WSDLDOMLoader();
        if (config.getResolver() != null) {
            loader.setWSDLResolver(config.getResolver());
        }
        if (config.isUseProxy()) {
            loader.setHttpProxy(config.getProxyHost(), config.getProxyPort());
        }
        if ((definitions = config.getDefinitions()) == null) {
            try {
                definitions = config.getLocationMap() != null ? loader.loadMirrorWSDLDocument(config.getWsdlLocation(), config.getLocationMap()) : loader.loadWSDLDocument(config.getWsdlLocation());
            }
            catch (WSDLException e) {
                throw new ProxyGeneratorException("webservices_3203", (Throwable)((Object)e));
            }
        }
        ClassGenerator generator = new ClassGenerator();
        if (config.getOutputPackage() == null) {
            this.printWarining("No output package specified. targetNamespace URI will be used.");
            NameConvertor convertor = new NameConvertor();
            try {
                config.setOutputPackage(convertor.uriToPackage(definitions.getTargetNamespace()));
                this.printWarining("Output root package set to : " + config.getOutputPackage());
            }
            catch (Exception e) {
                this.printWarining("Target namespace can not be used to build package name so none will be used.");
            }
        }
        ClientTransportBinding[] tbindings = new ClientTransportBinding[]{};
        tbindings = config.getBindings() != null ? config.getBindings() : this.getTransportBindings();
        try {
            generator.init(definitions, outputDirFile, config.getOutputPackage(), tbindings);
            if (definitions.getSchemaInfo() != null && config.isUseProxy()) {
                definitions.getSchemaInfo().setHttpProxy(config.getProxyHost(), config.getProxyPort());
            }
            generator.setDefaultSchemaMapping(config.getUriToPackageMapping());
            if (config.getLogicalPortName() != null) {
                generator.setLogicalPortName(config.getLogicalPortName());
            }
            if (config.getLogicalPortPath() != null) {
                generator.setLogicalPortPath(config.getLogicalPortPath());
            }
        }
        catch (Exception e) {
            throw new ProxyGeneratorException("webservices_3204", e);
        }
        generator.setAlternativeMethods(config.isAdditionalMethods());
        generator.setUseGetPortMethods(config.isJaxRpcMethods());
        generator.setCustomServiceName(config.getCustomServiceName());
        generator.setIsolatedPortType(config.getIsolatePortType());
        generator.setContainerMode(config.isContainerMode());
        generator.setSchemaFrameworkPath(config.getSchemaFrameworkPath());
        try {
            if (config.isStubsOnly()) {
                LogicalPorts ports = config.getLogicalPorts();
                if (ports == null) {
                    if (config.getLogicalPortPath() == null || config.getLogicalPortName() == null) {
                        throw new Exception("Path to logical ports ot logical ports not set ! Can not generate Implementation.");
                    }
                    LogicalPortFactory plfactory = new LogicalPortFactory();
                    ports = plfactory.loadLogicalPorts(config.getLogicalPortPath() + File.separator + config.getLogicalPortName());
                }
                ports = generator.generateImplementation(ports, config.isServerHosted());
                config.setLogicalPorts(ports);
            } else if (config.isLPonly()) {
                generator.generateLogicalPorts();
            } else if (config.isInterfacesOnly()) {
                generator.generateInterfaces();
            } else {
                generator.generateAll();
            }
        }
        catch (Exception e) {
            throw new ProxyGeneratorException("webservices_3205", e);
        }
        this.builder.clear();
        if (config.getAdditionalClassPath() != null) {
            this.builder.setAditionalClassPath(config.getAdditionalClassPath());
        } else {
            this.builder.setAditionalClassPath("");
        }
        this.builder.setPackageRoot(outputDirFile);
        this.builder.setPackageName(config.getOutputPackage());
        if (config.getUriToPackageMapping() != null) {
            Iterator it = ((Hashtable)config.getUriToPackageMapping()).values().iterator();
            while (it.hasNext()) {
                String packageName = (String)it.next();
                if (packageName.startsWith(config.getOutputPackage())) continue;
                this.builder.addExternalPackage(packageName);
            }
        }
        try {
            if (config.isCompile()) {
                this.builder.compilePackage();
            }
            if (config.getJarName() != null) {
                if (config.getJarExtensions() == null || config.getJarExtensions().length == 0) {
                    this.builder.loadPackageClasses(true);
                } else {
                    this.builder.loadPackageFiles(true, config.getJarExtensions());
                }
                this.builder.buildJar(config.getJarName());
            }
        }
        catch (Exception e) {
            throw new ProxyGeneratorException("webservices_3205", e);
        }
        config.setGeneratedSEIFiles(generator.getGeneratedSeiList());
        config.setGeneratedServices(generator.getGeneratedServiceInterfaces());
        config.setAllGeneratedFiles(generator.getFileList());
    }

    public void generateProxy(String wsdlName, String outputDir, String outputPackage, boolean compile, String jarName, boolean interfaces, String[] extensions, boolean additionalMethods) throws Exception {
        ProxyGeneratorConfig config = new ProxyGeneratorConfig(wsdlName, outputDir, outputPackage);
        config.setCompile(compile);
        config.setJarName(jarName);
        config.setAdditionalMethods(additionalMethods);
        config.setJarExtensions(extensions);
        this.generateProxy(config);
    }

    public void generateProxy(String wsdlName, String outputDir, String outputPackage, boolean compile, String jarName, boolean interfaces, boolean additionalMethods) throws Exception {
        if (jarName != null) {
            compile = true;
        }
        this.generateProxy(wsdlName, outputDir, outputPackage, compile, jarName, interfaces, null, additionalMethods);
    }

    private static boolean getInterfaces(String[] args) {
        int i = 2;
        while (i < args.length) {
            if (args[i].equals("-i")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getPackage(String[] args) {
        int i = 2;
        while (i < args.length) {
            if (args[i].equals("-p") && i + 1 < args.length) {
                return args[i + 1];
            }
            ++i;
        }
        return null;
    }

    private static boolean getAdditionalMethods(String[] args) {
        int i = 2;
        while (i < args.length) {
            if (args[i].equals("-d")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean getCompile(String[] args) {
        int i = 2;
        while (i < args.length) {
            if (args[i].equals("-c")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean getPortGet(String[] args) {
        int i = 2;
        while (i < args.length) {
            if (args[i].equals("-x")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getJar(String[] args) throws ProxyGeneratorException {
        int i = 2;
        while (i < args.length) {
            if (args[i].equals("-j") && i + 1 < args.length) {
                try {
                    new File(args[i + 1]);
                }
                catch (Exception e) {
                    throw new ProxyGeneratorException("webservices_3206", args[i + 1]);
                }
                return args[i + 1];
            }
            ++i;
        }
        return null;
    }

    public static void getHttpProxy(ProxyGeneratorConfig config, String[] args) {
        int i = 2;
        while (i < args.length) {
            if (args[i].equals("-h") && i + 2 < args.length) {
                config.setProxy(args[i + 1], args[i + 2]);
            }
            ++i;
        }
    }

    public static void printHelp() {
        System.out.println(" Usage: com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGenerator wsdl_file target_dir [options]");
        System.out.println(" option list:");
        System.out.println("  [-p package] - package name");
        System.out.println("  [-c] - compile");
        System.out.println("  [-j jarname] - create jar");
        System.out.println("  [-i] - generates interfaces only");
        System.out.println("  [-d] - generates rpc style method where possible");
        System.out.println("  [-x] - generate JAX-RPC style getXXX methods in service interface");
        System.out.println("  [-h proxyHost proxyPort] - use http proxy");
    }

    public static void main(String[] args) throws ProxyGeneratorException {
        System.out.println("SAP WSDL Proxy Generator 6.30");
        if (args.length < 2) {
            ProxyGenerator.printHelp();
            return;
        }
        ProxyGenerator generator = new ProxyGenerator();
        System.out.println(" * Generating Proxy from:" + args[0]);
        System.out.println(" * To directory:" + args[1]);
        ProxyGeneratorConfig config = new ProxyGeneratorConfig(args[0], args[1], ProxyGenerator.getPackage(args));
        config.setCompile(ProxyGenerator.getCompile(args));
        config.setJarName(ProxyGenerator.getJar(args));
        config.setInterfacesOnly(ProxyGenerator.getInterfaces(args));
        config.setAdditionalMethods(ProxyGenerator.getAdditionalMethods(args));
        config.setJaxRpcMethods(ProxyGenerator.getPortGet(args));
        ProxyGenerator.getHttpProxy(config, args);
        generator.generateProxy(config);
        System.out.println(" * Done");
    }
}

