/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.util;

public class StaticQueue {
    private int maxSize;
    private int frontIndex;
    private int rearIndex;
    private Object[] buffer;

    public StaticQueue(int size) {
        this.maxSize = size;
        this.buffer = new Object[this.maxSize];
        this.frontIndex = 0;
        this.rearIndex = 0;
    }

    public boolean isEmpty() {
        return this.frontIndex == this.rearIndex;
    }

    public boolean isFull() {
        int perm = this.rearIndex;
        if (perm < this.frontIndex) {
            perm = this.maxSize + perm;
        }
        return perm - this.frontIndex == this.maxSize - 1;
    }

    public void add(Object obj) throws IndexOutOfBoundsException {
        if (this.isFull()) {
            throw new IndexOutOfBoundsException("Queue is full !");
        }
        this.buffer[this.rearIndex] = obj;
        this.rearIndex = (this.rearIndex + 1) % this.maxSize;
    }

    public Object get() throws IndexOutOfBoundsException {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Queue is empty !");
        }
        Object result = this.buffer[this.frontIndex];
        this.buffer[this.frontIndex] = null;
        this.frontIndex = (this.frontIndex + 1) % this.maxSize;
        return result;
    }

    public void clear() {
        int i = 0;
        while (i < this.maxSize) {
            this.buffer[i] = null;
            ++i;
        }
        this.frontIndex = 0;
        this.rearIndex = 0;
    }
}

