/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.services.webservices.jaxrpc.encoding.ExtendedTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.encoding.GeneratedSimpleType;
import com.sap.engine.services.webservices.jaxrpc.encoding.Initializer;
import com.sap.engine.services.webservices.jaxrpc.encoding.SDFactoryRegistry;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationFactory;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationFactoryImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.XMLTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.exceptions.TypeMappingException;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGenerator;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.Serializer;
import javax.xml.rpc.encoding.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeMappingImpl
implements ExtendedTypeMapping,
Serializable {
    private SDFactoryRegistry registry;
    private String[] supportedEncodings;
    private Hashtable elementMapping;
    private Hashtable javaToSchemaMapping;
    private Hashtable schemaToJavaMapping;

    public String getDefaultJavaType(QName typeName) {
        return (String)this.schemaToJavaMapping.get(typeName);
    }

    public void registerDefaultJavaType(QName typeName, String javaClass) {
        this.schemaToJavaMapping.put(typeName, javaClass);
    }

    public void removeDefaultJavaType(QName typeName) {
        this.schemaToJavaMapping.remove(typeName);
    }

    public QName getDefaultSchemaType(String javaType) {
        return (QName)this.javaToSchemaMapping.get(javaType);
    }

    public void removeDefaultSchemaType(String javaType) {
        this.javaToSchemaMapping.remove(this.javaToSchemaMapping);
    }

    public void registerDefaultSchemaType(String javaType, QName schemaType) {
        this.javaToSchemaMapping.put(javaType, schemaType);
    }

    private void fillDefaultMappings() {
        Enumeration enumeration = SchemaToJavaGenerator.JAVA_TO_SCHEMA_SIMPLE.keys();
        while (enumeration.hasMoreElements()) {
            String javaName = (String)enumeration.nextElement();
            String localName = (String)SchemaToJavaGenerator.JAVA_TO_SCHEMA_SIMPLE.get(javaName);
            QName qname = new QName("http://www.w3.org/2001/XMLSchema", localName);
            this.registerDefaultSchemaType(javaName, qname);
        }
        enumeration = SchemaToJavaGenerator.JAXRPC_BUILT_IN_TO_JAVA.keys();
        while (enumeration.hasMoreElements()) {
            String localName = (String)enumeration.nextElement();
            String javaName = (String)SchemaToJavaGenerator.JAXRPC_BUILT_IN_TO_JAVA.get(localName);
            QName qname1 = new QName("http://www.w3.org/2001/XMLSchema", localName);
            QName qname2 = new QName("http://schemas.xmlsoap.org/soap/encoding/", localName);
            this.registerDefaultJavaType(qname1, javaName);
            this.registerDefaultJavaType(qname2, javaName);
        }
    }

    public TypeMappingImpl(SDFactoryRegistry registry) {
        this.registry = registry;
        this.supportedEncodings = null;
        this.elementMapping = new Hashtable();
        this.schemaToJavaMapping = new Hashtable();
        this.javaToSchemaMapping = new Hashtable();
        this.fillDefaultMappings();
    }

    public TypeMappingImpl() throws TypeMappingException {
        this.registry = new SDFactoryRegistry();
        this.elementMapping = new Hashtable();
        this.supportedEncodings = null;
        this.schemaToJavaMapping = new Hashtable();
        this.javaToSchemaMapping = new Hashtable();
        this.fillDefaultMappings();
    }

    public SDFactoryRegistry getSDRegistry() {
        return this.registry;
    }

    public boolean isRegistered(Class aClass, QName name) {
        String className = aClass.getName();
        return this.registry.get(className, name) != null;
    }

    public void register(Class aClass, QName name, SerializerFactory factory1, DeserializerFactory factory2) {
        if (factory1 == null || factory2 == null) {
            throw new IllegalArgumentException(" Both serialization and deserialization factories must not be null !");
        }
        if (factory1 != factory2 && !(factory1 instanceof SerializationFactory)) {
            throw new IllegalArgumentException(" Serializer and Deserializer factory must inherit SerializationFactory interface !");
        }
        String className = aClass.getName();
        this.registry.add(name, (SerializationFactory)factory1, className);
    }

    public void register(String aClass, QName name, SerializerFactory factory1, DeserializerFactory factory2) {
        if (factory1 == null || factory2 == null) {
            throw new IllegalArgumentException(" Both serialization and deserialization factories must not be null !");
        }
        if (factory1 != factory2 && !(factory1 instanceof SerializationFactory)) {
            throw new IllegalArgumentException(" Serializer and Deserializer factory must inherit SerializationFactory interface !");
        }
        this.registry.add(name, (SerializationFactory)factory1, aClass);
    }

    public SerializerFactory getSerializer(Class aClass, QName name) {
        SerializationFactory result = this.registry.get(aClass.getName(), name);
        if (result != null && !result.isInitialized()) {
            try {
                result.init(aClass.getClassLoader());
            }
            catch (TypeMappingException e) {
                throw new RuntimeException(" Trying to use uninitialized framework. Serializer/Deserializer [" + result.getSerializerName() + "/" + result.getDeserializerName() + "] can not be inirialized !");
            }
        }
        return result;
    }

    public DeserializerFactory getDeserializer(Class aClass, QName name) {
        SerializationFactory result = this.registry.get(aClass.getName(), name);
        if (result != null && !result.isInitialized()) {
            try {
                result.init(aClass.getClassLoader());
            }
            catch (TypeMappingException e) {
                throw new RuntimeException(" Trying to use uninitialized framework. Serializer/Deserializer [" + result.getSerializerName() + "/" + result.getDeserializerName() + "] can not be inirialized !");
            }
        }
        return result;
    }

    public void removeSerializer(Class aClass, QName name) {
        XMLTypeMapping mapping = this.registry.getAll(name);
        if (mapping != null) {
            mapping.releaseFactory(aClass.getName());
        }
    }

    public void removeDeserializer(Class aClass, QName name) {
        XMLTypeMapping mapping = this.registry.getAll(name);
        if (mapping != null) {
            mapping.releaseFactory(aClass.getName());
        }
    }

    public String[] getSupportedEncodings() {
        return this.supportedEncodings;
    }

    public void setSupportedEncodings(String[] encodingStyleURIs) {
        this.supportedEncodings = encodingStyleURIs;
    }

    public String[] getSupportedNamespaces() {
        return this.supportedEncodings;
    }

    public void setSupportedNamespaces(String[] strings) {
        this.supportedEncodings = strings;
    }

    public void fromXml(Element root, ClassLoader loader) throws TypeMappingException {
        Node child = root.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                String javaType;
                String typeNamespace;
                String typeName;
                Element e = (Element)child;
                if (e.getNodeName().equals("xmlMapping")) {
                    XMLTypeMapping mapping = this.loadXMLTypeMapping(e, loader);
                    QName xmlType = mapping.getXMLName();
                    this.registry.addAll(xmlType, mapping);
                }
                if (e.getNodeName().equals("elementMapping")) {
                    NodeList elementName = e.getElementsByTagName("elementDeclaration");
                    NodeList elementType = e.getElementsByTagName("elementType");
                    if (elementName.getLength() != 1 && elementType.getLength() != 1) {
                        throw new TypeMappingException("webservices_3307");
                    }
                    Element element1 = (Element)elementName.item(0);
                    Element element2 = (Element)elementType.item(0);
                    String eName = element1.getAttribute("Name");
                    String eUri = element1.getAttribute("Uri");
                    String tName = element2.getAttribute("Name");
                    String tUri = element2.getAttribute("Uri");
                    if (eName == null || tName == null) {
                        throw new TypeMappingException("webservices_3303");
                    }
                    QName qname1 = new QName(eUri, eName);
                    QName qname2 = new QName(tUri, tName);
                    this.elementMapping.put(qname1, qname2);
                }
                if (e.getNodeName().equals("schemaToJavaMapping")) {
                    typeName = e.getAttribute("typeName");
                    typeNamespace = e.getAttribute("typeNamespace");
                    javaType = e.getAttribute("javaType");
                    if (typeName.length() != 0 && typeNamespace.length() != 0 && javaType.length() != 0) {
                        this.registerDefaultJavaType(new QName(typeNamespace, typeName), javaType);
                    }
                }
                if (e.getNodeName().equals("javaToSchemaMapping")) {
                    typeName = e.getAttribute("typeName");
                    typeNamespace = e.getAttribute("typeNamespace");
                    javaType = e.getAttribute("javaType");
                    if (typeName.length() != 0 && typeNamespace.length() != 0 && javaType.length() != 0) {
                        this.registerDefaultSchemaType(javaType, new QName(typeNamespace, typeName));
                    }
                }
            }
            child = child.getNextSibling();
        }
        this.initializeRelations();
    }

    private XMLTypeMapping loadXMLTypeMapping(Element e, ClassLoader loader) throws TypeMappingException {
        XMLTypeMapping result = null;
        String typeName = e.getAttribute("typeName");
        String namespace = e.getAttribute("typeNamespace");
        if (typeName.length() == 0) {
            throw new TypeMappingException("webservices_3303");
        }
        String parentName = e.getAttribute("parentType");
        String parentUri = e.getAttribute("parentNamespace");
        String serializer = null;
        String deserializer = null;
        Node child = e.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                SerializationFactoryImpl factory;
                String initParams;
                Element elem = (Element)child;
                if (elem.getNodeName().equals("default")) {
                    serializer = elem.getAttribute("serializer");
                    deserializer = elem.getAttribute("deserializer");
                    initParams = elem.getAttribute("initParams");
                    if (result != null || serializer.length() == 0 || deserializer.length() == 0) {
                        throw new TypeMappingException("webservices_3304");
                    }
                    QName xmlType = new QName(namespace, typeName);
                    factory = new SerializationFactoryImpl(xmlType, serializer, deserializer, initParams);
                    serializer = null;
                    deserializer = null;
                    factory.init(loader);
                    if (factory.getSerializer() instanceof GeneratedSimpleType) {
                        GeneratedSimpleType s = (GeneratedSimpleType)factory.getSerializer();
                        if ("http://schemas.xmlsoap.org/soap/encoding/".equals(namespace)) {
                            s._setDefaultNamespace("http://schemas.xmlsoap.org/soap/encoding/");
                        }
                    }
                    result = new XMLTypeMapping(xmlType, factory);
                }
                if (elem.getNodeName().equals("custom")) {
                    serializer = elem.getAttribute("serializer");
                    deserializer = elem.getAttribute("deserializer");
                    initParams = elem.getAttribute("initParams");
                    String javaType = elem.getAttribute("javaType");
                    if (result == null || serializer.length() == 0 || deserializer.length() == 0 || javaType.length() == 0) {
                        throw new TypeMappingException("webservices_3304");
                    }
                    factory = new SerializationFactoryImpl(new QName(namespace, typeName), serializer, deserializer, initParams);
                    factory.init(loader);
                    result.addFactory(javaType, (SerializationFactory)factory);
                }
            }
            child = child.getNextSibling();
        }
        if (result == null) {
            throw new TypeMappingException("webservices_3304");
        }
        if (parentName.length() != 0) {
            result.setParentType(new QName(parentUri, parentName));
        }
        return result;
    }

    public void toXml(Document document, Element root) {
        Element element;
        Enumeration keys = this.registry.getRegisteredXMLTypes();
        while (keys.hasMoreElements()) {
            QName xmlType = (QName)keys.nextElement();
            Element defaultSerializer = document.createElement("default");
            XMLTypeMapping xmlTypeMapping = this.registry.getAll(xmlType);
            QName parent = xmlTypeMapping.getParentType();
            defaultSerializer.setAttribute("serializer", xmlTypeMapping.getDefaultFactory().getSerializerName());
            defaultSerializer.setAttribute("deserializer", xmlTypeMapping.getDefaultFactory().getDeserializerName());
            if (xmlTypeMapping.getDefaultFactory().isInitialized()) {
                String[] initParams;
                Serializer serializer = xmlTypeMapping.getDefaultFactory().getSerializerAs(null);
                String params = "";
                if (serializer instanceof Initializer && (initParams = ((Initializer)serializer).getInitParams()) != null && initParams.length != 0) {
                    params = initParams[0];
                    int i = 1;
                    while (i < initParams.length) {
                        params = params + "," + initParams[i];
                        ++i;
                    }
                    defaultSerializer.setAttribute("initParams", params);
                }
            }
            Element xmlmapping = document.createElement("xmlMapping");
            xmlmapping.setAttribute("typeName", xmlType.getLocalPart());
            if (xmlType.getNamespaceURI() != null && xmlType.getNamespaceURI().length() != 0) {
                xmlmapping.setAttribute("typeNamespace", xmlType.getNamespaceURI());
            }
            if (parent != null) {
                xmlmapping.setAttribute("parentType", parent.getLocalPart());
                if (parent.getNamespaceURI() != null && parent.getNamespaceURI().length() != 0) {
                    xmlmapping.setAttribute("parentNamespace", parent.getNamespaceURI());
                }
            }
            xmlmapping.appendChild(defaultSerializer);
            Enumeration classes = xmlTypeMapping.getCustom();
            while (classes.hasMoreElements()) {
                String[] initParams;
                Serializer serializer;
                String className = (String)classes.nextElement();
                Element elem = document.createElement("custom");
                elem.setAttribute("javaType", className);
                elem.setAttribute("serializer", xmlTypeMapping.getFactory(className).getSerializerName());
                elem.setAttribute("deserializer", xmlTypeMapping.getFactory(className).getDeserializerName());
                String params = "";
                if (xmlTypeMapping.getFactory(className).isInitialized() && (serializer = xmlTypeMapping.getFactory(className).getSerializerAs(null)) instanceof Initializer && (initParams = ((Initializer)serializer).getInitParams()) != null && initParams.length != 0) {
                    int i = 0;
                    while (i < initParams.length) {
                        params = params + "," + initParams[i];
                        ++i;
                    }
                    elem.setAttribute("initParams", params);
                }
                xmlmapping.appendChild(elem);
            }
            root.appendChild(xmlmapping);
        }
        keys = this.elementMapping.keys();
        while (keys.hasMoreElements()) {
            Element element1 = document.createElement("elementMapping");
            QName elementName = (QName)keys.nextElement();
            Element element2 = document.createElement("elementDeclaration");
            element2.setAttribute("Name", elementName.getLocalPart());
            element2.setAttribute("Uri", elementName.getNamespaceURI());
            QName elementType = (QName)this.elementMapping.get(elementName);
            Element element3 = document.createElement("elementType");
            element3.setAttribute("Name", elementType.getLocalPart());
            element3.setAttribute("Uri", elementType.getNamespaceURI());
            element1.appendChild(element2);
            element1.appendChild(element3);
            root.appendChild(element1);
        }
        keys = this.schemaToJavaMapping.keys();
        while (keys.hasMoreElements()) {
            QName key = (QName)keys.nextElement();
            String value = (String)this.schemaToJavaMapping.get(key);
            element = document.createElement("schemaToJavaMapping");
            element.setAttribute("typeName", key.getLocalPart());
            element.setAttribute("typeNamespace", key.getNamespaceURI());
            element.setAttribute("javaType", value);
            root.appendChild(element);
        }
        keys = this.javaToSchemaMapping.keys();
        while (keys.hasMoreElements()) {
            String javaName = (String)keys.nextElement();
            QName qname = (QName)this.javaToSchemaMapping.get(javaName);
            element = document.createElement("javaToSchemaMapping");
            element.setAttribute("javaType", javaName);
            element.setAttribute("typeName", qname.getLocalPart());
            element.setAttribute("typeNamespace", qname.getNamespaceURI());
            root.appendChild(element);
        }
    }

    public String toString() {
        String result = "TypeMapping supported encodings: {";
        if (this.supportedEncodings != null) {
            int i = 0;
            while (i < this.supportedEncodings.length) {
                result = result + " " + this.supportedEncodings[i];
                ++i;
            }
        }
        result = result + "} " + this.registry.toString();
        return result;
    }

    public void initializeRelations() {
        Enumeration keys = this.schemaToJavaMapping.keys();
        while (keys.hasMoreElements()) {
            QName key = (QName)keys.nextElement();
            String value = (String)this.schemaToJavaMapping.get(key);
            XMLTypeMapping typeMapping = this.getXmlTypeMapping(key);
            if (typeMapping == null) continue;
            QName parentType = typeMapping.getParentType();
            while (parentType != null) {
                XMLTypeMapping parentTypeMapping = this.getXmlTypeMapping(parentType);
                if (parentTypeMapping != null) {
                    parentTypeMapping.addFactory(value, typeMapping.getDefaultFactory());
                    parentType = parentTypeMapping.getParentType();
                    continue;
                }
                parentType = null;
            }
        }
    }

    public void addXmlTypeMapping(QName xmlType, XMLTypeMapping mapping) {
        this.registry.addAll(xmlType, mapping);
    }

    public XMLTypeMapping getXmlTypeMapping(QName xmlType) {
        return this.registry.getAll(xmlType);
    }

    public QName getTypeForElement(QName element) {
        return (QName)this.elementMapping.get(element);
    }

    public void setTypeForElement(QName elementName, QName typeName) {
        this.elementMapping.put(elementName, typeName);
    }

    public void removeElement(QName elementName) {
        this.elementMapping.remove(elementName);
    }

    public SDFactoryRegistry getSDFactoryRegistry() {
        return this.registry;
    }

    public Enumeration getRegisteredElements() {
        return this.elementMapping.keys();
    }

    public Enumeration getRegisteredSchemaTypes() {
        return this.schemaToJavaMapping.keys();
    }

    public Enumeration getRegisteredJavaTypes() {
        return this.javaToSchemaMapping.keys();
    }

    public void clear() {
        this.registry.clear();
        this.supportedEncodings = new String[0];
        this.elementMapping.clear();
        this.javaToSchemaMapping.clear();
        this.schemaToJavaMapping.clear();
    }
}

