/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.lib.xml.names.XMLNameMapper;
import com.sap.engine.services.webservices.jaxrpc.encoding.FieldDescriptor;
import com.sap.engine.services.webservices.jaxrpc.util.StaticQueue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ClassInfo {
    private Class javaClass;
    private Hashtable fields;
    private XMLNameMapper xmlNameMapper = new XMLNameMapper();
    private static int CACHE_SIZE = 100;
    private static Hashtable hash = new Hashtable();
    private static StaticQueue buffer = new StaticQueue(CACHE_SIZE);
    static /* synthetic */ Class class$java$lang$Boolean;

    public ClassInfo(Class javaClass) {
        this.javaClass = javaClass;
        this.fields = new Hashtable();
        this.loadFieldsInfo();
    }

    public FieldDescriptor[] getFieldDescriptors() {
        Object[] arr = this.fields.values().toArray();
        FieldDescriptor[] fDArr = new FieldDescriptor[arr.length];
        int i = 0;
        while (i < arr.length) {
            fDArr[i] = (FieldDescriptor)arr[i];
            ++i;
        }
        return fDArr;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public void reuse(Class javaClass) {
        this.fields.clear();
        this.javaClass = javaClass;
        this.loadFieldsInfo();
    }

    private void loadFieldsInfo() {
        FieldDescriptor descriptor;
        Class<?>[] params;
        String name;
        Method currentMethod;
        Method[] methods = this.javaClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            currentMethod = methods[i];
            name = currentMethod.getName();
            params = currentMethod.getParameterTypes();
            if (params.length == 0 && name.startsWith("get")) {
                name = name.substring(3);
                Class<?> returnType = currentMethod.getReturnType();
                descriptor = new FieldDescriptor(returnType, name);
                descriptor.setReadMethod(currentMethod);
                this.fields.put(name, descriptor);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < methods.length) {
            currentMethod = methods[i2];
            name = currentMethod.getName();
            params = currentMethod.getParameterTypes();
            Class<?> returnType = currentMethod.getReturnType();
            if (returnType == Void.TYPE && params.length == 1 && name.startsWith("set")) {
                descriptor = (FieldDescriptor)this.fields.get(name = name.substring(3));
                if (descriptor == null) {
                    descriptor = new FieldDescriptor(params[0], name);
                    descriptor.setWriteMethod(currentMethod);
                    descriptor.seal();
                    this.fields.put(name, descriptor);
                } else if (descriptor.getFieldType() != params[0]) {
                    descriptor.setWriteMethod(currentMethod);
                } else {
                    descriptor.setWriteMethod(currentMethod);
                    descriptor.seal();
                }
            }
            if (params.length == 0 && name.startsWith("has") && (returnType == (class$java$lang$Boolean == null ? ClassInfo.class$("java.lang.Boolean") : class$java$lang$Boolean) || returnType == Boolean.TYPE) && (descriptor = (FieldDescriptor)this.fields.get(name = name.substring(3))) != null) {
                descriptor.setCheckMethod(currentMethod);
            }
            ++i2;
        }
        Field[] fields = this.javaClass.getFields();
        int i3 = 0;
        while (i3 < fields.length) {
            Field tempField = fields[i3];
            int mods = tempField.getModifiers();
            if (Modifier.isPublic(mods) && !Modifier.isFinal(mods) && !Modifier.isTransient(mods)) {
                descriptor = new FieldDescriptor(tempField.getType(), tempField.getName());
                String mappedfieldName = tempField.getName();
                mappedfieldName = mappedfieldName.length() == 1 ? mappedfieldName.toUpperCase() : Character.toUpperCase(mappedfieldName.charAt(0)) + mappedfieldName.substring(1);
                this.fields.put(mappedfieldName, descriptor);
            }
            ++i3;
        }
    }

    public boolean hasField(String fieldName) {
        return this.fields.get(fieldName) != null;
    }

    public FieldDescriptor getField(String fieldName) {
        return (FieldDescriptor)this.fields.get(fieldName);
    }

    public Class getFieldClass(String fieldName) {
        FieldDescriptor result = (FieldDescriptor)this.fields.get(fieldName);
        if (result != null) {
            return result.getFieldType();
        }
        return null;
    }

    public static final synchronized ClassInfo getClassInfo(Class javaClass) {
        ClassInfo result = (ClassInfo)hash.get(javaClass);
        if (result != null) {
            return result;
        }
        result = new ClassInfo(javaClass);
        hash.put(javaClass, result);
        if (buffer.isFull()) {
            ClassInfo perm = (ClassInfo)buffer.get();
            hash.remove(perm.getClass());
            Object var2_2 = null;
        }
        buffer.add(result);
        return result;
    }

    public String toString() {
        String s = "ClassInfo: javaClas = " + this.javaClass.getName() + ", fields=";
        Enumeration keys = this.fields.keys();
        while (keys.hasMoreElements()) {
            s = s + (String)keys.nextElement() + ", ";
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

