/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.xml.parser.DOMParser;
import com.sap.engine.services.webservices.jaxm.soap.AttachmentPartImpl;
import com.sap.engine.services.webservices.jaxm.soap.SAPSoapException;
import com.sap.engine.services.webservices.jaxm.soap.SOAPDocumentImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPEnvelopeImpl;
import com.sap.engine.services.webservices.jaxm.soap.accessor.NestedSOAPException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class SOAPPartImpl
extends SOAPPart {
    private static TransformerFactory factory;
    private static Transformer transformer;
    private static DOMParser parser;
    private MimeHeaders headers = new MimeHeaders();
    private SOAPDocumentImpl document = null;

    public SOAPPartImpl() {
        this.headers.setHeader("Content-Type", "text/xml");
        this.document = new SOAPDocumentImpl();
        this.createEnvelope();
    }

    private SOAPEnvelope createEnvelope() {
        SOAPEnvelopeImpl envelope = new SOAPEnvelopeImpl((Document)((Object)this.document));
        envelope.init("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Envelope", null);
        this.document.init((Element)((Object)envelope));
        try {
            envelope.addHeader();
            envelope.addBody();
        }
        catch (SOAPException x) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            x.printStackTrace(pw);
            String msg = sw.toString();
            pw.close();
            throw new RuntimeException(msg);
        }
        return envelope;
    }

    public void addMimeHeader(String s, String s1) {
        this.headers.addHeader(s, s1);
    }

    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    public Source getContent() throws SOAPException {
        try {
            DOMSource dom_source = new DOMSource(this.document.getDocumentElement());
            ByteArrayOutputStream byteoutputstream = new ByteArrayOutputStream();
            String[] contentEncoding = this.headers.getHeader("Content-Encoding");
            if (contentEncoding != null && contentEncoding.length >= 1 && "gzip".equals(contentEncoding[0])) {
                try {
                    GZIPOutputStream compressedOutput = new GZIPOutputStream(byteoutputstream);
                    StreamResult stream_result = new StreamResult(compressedOutput);
                    SOAPPartImpl.makeTransform(dom_source, stream_result);
                    compressedOutput.finish();
                }
                catch (IOException e) {
                    throw new SAPSoapException("Unable to open output stream.", e);
                }
            } else {
                StreamResult stream_result = new StreamResult(byteoutputstream);
                SOAPPartImpl.makeTransform(dom_source, stream_result);
            }
            return new StreamSource(new ByteArrayInputStream(byteoutputstream.toByteArray()));
        }
        catch (TransformerException exception) {
            throw new NestedSOAPException("webservices_3704", exception);
        }
    }

    public SOAPEnvelope getEnvelope() {
        if (this.document.getDocumentElement() instanceof SOAPEnvelope) {
            return (SOAPEnvelope)this.document.getDocumentElement();
        }
        return null;
    }

    public Iterator getMatchingMimeHeaders(String[] as) {
        return this.headers.getMatchingHeaders(as);
    }

    public String[] getMimeHeader(String s) {
        return this.headers.getHeader(s);
    }

    public Iterator getNonMatchingMimeHeaders(String[] as) {
        return this.headers.getNonMatchingHeaders(as);
    }

    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    public void removeMimeHeader(String s) {
        this.headers.removeHeader(s);
    }

    public void setContent(Source source) throws SOAPException {
        Element root = null;
        try {
            InputStream in = ((StreamSource)source).getInputStream();
            String[] contentEncoding = this.headers.getHeader("Content-Encoding");
            if (contentEncoding != null && contentEncoding.length >= 1 && "gzip".equals(contentEncoding[0])) {
                in = new GZIPInputStream(in);
            }
            this.document = SOAPPartImpl.parseDocument(this.document, in);
            root = this.document.getDocumentElement();
        }
        catch (Exception e) {
            throw new NestedSOAPException("webservices_3706", e);
        }
        if (root == null) {
            throw new NestedSOAPException("webservices_3705");
        }
    }

    public void setMimeHeader(String name, String value) {
        this.headers.setHeader(name, value);
    }

    private static synchronized SOAPDocumentImpl parseDocument(SOAPDocumentImpl document, InputStream inputstream) throws Exception {
        if (parser == null) {
            parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://inqmy.org/sax/features/read-dtd", false);
        }
        parser.setDocument((Document)((Object)document));
        SOAPDocumentImpl result = (SOAPDocumentImpl)((Object)parser.parse(inputstream));
        return result;
    }

    private static synchronized void makeTransform(DOMSource dom_source, StreamResult stream_result) throws TransformerException {
        if (transformer == null) {
            factory = new TransformerFactoryImpl();
            transformer = factory.newTransformer();
        }
        transformer.transform(dom_source, stream_result);
    }

    public void reuse() {
        this.headers.removeAllHeaders();
        this.headers.setHeader("Content-Type", "text/xml");
        if (this.getEnvelope() != null) {
            this.getEnvelope().recycleNode();
        }
        this.document.init(null);
    }

    public void writeTo(OutputStream stream) throws SOAPException {
        try {
            DOMSource dom_source = new DOMSource((Node)((Object)((SOAPEnvelopeImpl)this.getEnvelope())));
            StreamResult stream_result = new StreamResult(stream);
            SOAPPartImpl.makeTransform(dom_source, stream_result);
        }
        catch (TransformerException exception) {
            throw new NestedSOAPException("webservices_3704", exception);
        }
    }

    MimeBodyPart getMimePart() throws SOAPException {
        MimeBodyPart mimebodypart = new MimeBodyPart();
        try {
            mimebodypart.setDataHandler(this.getDataHandler());
        }
        catch (MessagingException e) {
            throw new NestedSOAPException("webservices_3707", e);
        }
        AttachmentPartImpl.copyMimeHeaders(this.headers, mimebodypart);
        return mimebodypart;
    }

    DataHandler getDataHandler() {
        return new DataHandler(new DataSource(){

            public String getContentType() {
                return "text/xml";
            }

            public InputStream getInputStream() throws IOException {
                try {
                    return ((StreamSource)SOAPPartImpl.this.getContent()).getInputStream();
                }
                catch (SOAPException soapexception) {
                    throw new IOException(soapexception.getMessage());
                }
            }

            public String getName() {
                return SOAPPartImpl.this.getContentId();
            }

            public OutputStream getOutputStream() throws IOException {
                throw new IOException("Illegal Operation");
            }
        });
    }

    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    public Element createElement(String tagName) throws DOMException {
        return this.document.createElement(tagName);
    }

    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.document.createCDATASection(data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.document.createProcessingInstruction(target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.document.createAttribute(name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.document.createEntityReference(name);
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.document.getElementsByTagName(tagname);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.document.importNode(importedNode, deep);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.document.getElementsByTagNameNS(namespaceURI, localName);
    }

    public Element getElementById(String elementId) {
        return this.document.getElementById(elementId);
    }

    public String getNodeName() {
        return this.document.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.document.setNodeValue(nodeValue);
    }

    public short getNodeType() {
        return this.document.getNodeType();
    }

    public Node getParentNode() {
        return this.document.getParentNode();
    }

    public NodeList getChildNodes() {
        return this.document.getChildNodes();
    }

    public Node getFirstChild() {
        return this.document.getFirstChild();
    }

    public Node getLastChild() {
        return this.document.getLastChild();
    }

    public Node getPreviousSibling() {
        return this.document.getPreviousSibling();
    }

    public Node getNextSibling() {
        return this.document.getNextSibling();
    }

    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.document.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.document.replaceChild(newChild, oldChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.document.removeChild(oldChild);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.document.appendChild(newChild);
    }

    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        return this.document.cloneNode(deep);
    }

    public void normalize() {
        this.document.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.document.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    public String getPrefix() {
        return this.document.getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        this.document.setPrefix(prefix);
    }

    public String getLocalName() {
        return this.document.getLocalName();
    }

    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    static {
        transformer = null;
        parser = null;
    }
}

