/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.services.webservices.jaxm.soap.DetailImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPElementImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPNameImpl;
import com.sap.engine.services.webservices.jaxm.soap.accessor.NestedSOAPException;
import java.util.Locale;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SOAPFaultImpl
extends SOAPElementImpl
implements SOAPFault {
    public static final String faultCodeName = "faultcode";
    public static final String faultStringName = "faultstring";
    public static final String faultActorName = "faultactor";
    public static final String faultDetailName = "detail";

    protected SOAPFaultImpl() {
    }

    protected SOAPFaultImpl(Document owner) {
        this.setOwnerDocument(owner);
    }

    public Detail addDetail() throws SOAPException {
        DetailImpl detail = (DetailImpl)this.getDetail();
        if (detail == null) {
            detail = new DetailImpl(this.getOwnerDocument());
            detail.init(null, faultDetailName, null);
            super.appendChild((org.w3c.dom.Node)((Object)detail));
            return detail;
        }
        throw new NestedSOAPException("webservices_3701");
    }

    public Detail getDetail() {
        return (DetailImpl)this.getFirstElement(faultDetailName);
    }

    public String getFaultActor() {
        SOAPElementImpl element = this.getFirstElement(faultActorName);
        if (element == null) {
            return null;
        }
        return element.getValue();
    }

    public String getFaultCode() {
        SOAPElementImpl element = this.getFirstElement(faultCodeName);
        if (element == null) {
            return null;
        }
        return element.getValue();
    }

    public String getFaultString() {
        SOAPElementImpl element = this.getFirstElement(faultStringName);
        if (element == null) {
            return null;
        }
        return element.getValue();
    }

    public void setFaultString(String faultString) throws SOAPException {
        SOAPElementImpl element = this.getFirstElement(faultStringName);
        if (element == null) {
            element = (SOAPElementImpl)this.addChildElement(faultStringName);
        }
        element.setValue(faultString);
    }

    public void setFaultActor(String faultActor) throws SOAPException {
        SOAPElementImpl element = this.getFirstElement(faultActorName);
        if (element == null) {
            element = (SOAPElementImpl)this.addChildElement(faultActorName);
        }
        element.setValue(faultActor);
    }

    public void setFaultCode(String faultCode) throws SOAPException {
        SOAPElementImpl element = this.getFirstElement(faultCodeName);
        if (element == null) {
            element = (SOAPElementImpl)this.addChildElement(faultCodeName);
        }
        element.setValue(faultCode);
    }

    public void setFaultCode(Name faultCode) throws SOAPException {
        SOAPElementImpl element = this.getFirstElement(faultCodeName);
        if (element == null) {
            element = (SOAPElementImpl)this.addChildElement(faultCodeName);
        }
        if (faultCode.getURI() != null && faultCode.getURI().length() != 0) {
            String prefix = faultCode.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                prefix = "NS";
            }
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, faultCode.getURI());
            element.setValue(prefix + ":" + faultCode.getLocalName());
        } else {
            element.setValue(faultCode.getQualifiedName());
        }
    }

    public Name getFaultCodeAsName() {
        SOAPElementImpl element = this.getFirstElement(faultCodeName);
        if (element == null) {
            return null;
        }
        String value = element.getValue();
        if (value == null) {
            return null;
        }
        String localName = DOM.qnameToLocalName((String)value);
        String prefix = DOM.qnameToPrefix((String)value);
        String namespace = DOM.qnameToURI((String)value, (org.w3c.dom.Node)((Object)element));
        SOAPNameImpl result = new SOAPNameImpl(prefix, localName, namespace);
        return result;
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node node) throws DOMException {
        if (node.getNodeType() == 1 && node.getLocalName().equals(faultDetailName)) {
            DetailImpl detail = new DetailImpl(this.getOwnerDocument());
            detail.init(null, faultDetailName, null);
            super.appendChild((org.w3c.dom.Node)((Object)detail));
            NamedNodeMap nm = node.getAttributes();
            int i = 0;
            while (i < nm.getLength()) {
                detail.setAttributeNode((Attr)this.getOwnerDocument().importNode(nm.item(i), false));
                ++i;
            }
            NodeList nodes = node.getChildNodes();
            int i2 = 0;
            while (i2 < nodes.getLength()) {
                detail.appendChild(this.getOwnerDocument().importNode(nodes.item(i2), true));
                ++i2;
            }
            return detail;
        }
        return super.appendChild(node);
    }

    private SOAPElementImpl getFirstElement(String elementName) {
        org.w3c.dom.Node node = this.getFirstChild();
        SOAPElementImpl result = null;
        while (node != null) {
            if (node instanceof SOAPElementImpl && (result = (SOAPElementImpl)((Object)node)).getLocalName().equals(elementName)) {
                return result;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public Locale getFaultStringLocale() {
        SOAPElementImpl element = this.getFirstElement(faultStringName);
        if (element == null) {
            return null;
        }
        String lang = element.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (lang.length() != 0) {
            int pos = lang.indexOf(45);
            if (pos != -1) {
                String country = lang.substring(pos + 1);
                lang = lang.substring(0, pos);
                return new Locale(lang, country);
            }
            return new Locale(lang, "");
        }
        return null;
    }

    public void setFaultString(String faultString, Locale locale) throws SOAPException {
        SOAPElementImpl element = this.getFirstElement(faultStringName);
        if (element == null) {
            element = (SOAPElementImpl)this.addChildElement(faultStringName);
        }
        element.setValue(faultString);
        if (locale != null) {
            String lang = locale.getLanguage();
            if (locale.getCountry() != null && locale.getCountry().length() != 0) {
                lang = lang + "-" + locale.getCountry();
            }
            element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "lang", lang);
        }
    }

    public final void recycleNode() {
        NodeList childs = super.getChildNodes();
        int size = childs.getLength();
        int i = 0;
        while (i < size) {
            Node node = (Node)childs.item(i);
            node.recycleNode();
            ++i;
        }
    }
}

