/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.dom.ElementImpl;
import com.sap.engine.lib.xml.dom.NodeImpl;
import com.sap.engine.services.webservices.jaxm.soap.IteratorImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPDocumentImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPNameImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPTextImpl;
import com.sap.engine.services.webservices.jaxm.soap.accessor.NestedSOAPException;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFaultElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SOAPElementImpl
extends ElementImpl
implements Node,
SOAPElement,
SOAPBodyElement,
SOAPFaultElement,
DetailEntry,
SOAPHeaderElement {
    private int elementType = 0;
    public static final int SOAPHEADERELEMENT = 1;
    public static final int SOAPBODYELEMENT = 2;

    protected void setElementType(int x) {
        this.elementType = x;
    }

    public SOAPElementImpl() {
    }

    public SOAPElementImpl(Document owner) {
        super(owner);
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        super.setAttributeNS(name.getURI(), name.getQualifiedName(), value);
        return this;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        Element result = super.getOwnerDocument().createElementNS(name.getURI(), name.getQualifiedName());
        super.appendChild((org.w3c.dom.Node)result);
        return (SOAPElement)result;
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        SOAPElementImpl castedElement = (SOAPElementImpl)element;
        castedElement.detachNode();
        castedElement.setOwnerDocument(super.getOwnerDocument());
        this.appendChild((org.w3c.dom.Node)((Object)castedElement));
        return castedElement;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        SOAPElementImpl result = (SOAPElementImpl)((Object)super.getOwnerDocument().createElement(localName));
        super.appendChild((org.w3c.dom.Node)((Object)result));
        return result;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String uri = DOM.prefixToURI((String)prefix, (org.w3c.dom.Node)((Object)this));
        if (uri == null) {
            throw new NestedSOAPException("webservices_3700", prefix, (Object)localName, (Object)this.getNamespaceURI(), (Object)this.getLocalName());
        }
        String qName = localName;
        if (prefix != null && prefix.length() != 0) {
            qName = prefix + ":" + qName;
        }
        Element result = super.getOwnerDocument().createElementNS(uri, qName);
        super.appendChild((org.w3c.dom.Node)result);
        return (SOAPElement)result;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        String qName = localName;
        if (prefix != null && prefix.length() != 0) {
            qName = prefix + ":" + localName;
        }
        Element result = super.getOwnerDocument().createElementNS(uri, qName);
        super.appendChild((org.w3c.dom.Node)result);
        return (SOAPElement)result;
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        String qname = "xmlns";
        if (prefix != null && prefix.length() != 0) {
            qname = qname + ":" + prefix;
        }
        super.setAttributeNS("http://www.w3.org/2000/xmlns/", qname, uri);
        return this;
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        if (text == null) {
            throw new IllegalArgumentException(" NULL Text node can not be created.");
        }
        SOAPTextImpl textNode = text.startsWith("<!--") && text.endsWith("-->") ? (SOAPTextImpl)super.getOwnerDocument().createComment(text) : (SOAPTextImpl)super.getOwnerDocument().createTextNode(text);
        super.appendChild((org.w3c.dom.Node)textNode);
        return this;
    }

    public Iterator getAllAttributes() {
        IteratorImpl result = new IteratorImpl();
        NamedNodeMap attributes = this.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attribute = (Attr)attributes.item(i);
            SOAPNameImpl name = new SOAPNameImpl();
            name.init(attribute.getPrefix(), attribute.getLocalName(), attribute.getNamespaceURI());
            result.addElement(name);
            ++i;
        }
        return result;
    }

    public String getAttributeValue(Name name) {
        String result = this.getAttributeNS(name.getURI(), name.getLocalName());
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    public Iterator getChildElements() {
        org.w3c.dom.Node child = this.getFirstChild();
        IteratorImpl result = new IteratorImpl();
        while (child != null) {
            result.addElement(child);
            child = child.getNextSibling();
        }
        return result;
    }

    private boolean compareString(String ns1, String ns2) {
        if (ns1 == ns2) {
            return true;
        }
        if (ns1 != null && ns1.equals(ns2)) {
            return true;
        }
        return ns2 != null && ns2.equals(ns1);
    }

    public Iterator getChildElements(Name name) {
        org.w3c.dom.Node child = this.getFirstChild();
        IteratorImpl result = new IteratorImpl();
        while (child != null) {
            if (child.getNodeType() == 1 && child.getLocalName().equals(name.getLocalName()) && this.compareString(child.getNamespaceURI(), name.getURI())) {
                result.addElement(child);
            }
            child = child.getNextSibling();
        }
        return result;
    }

    public Name getElementName() {
        SOAPNameImpl result = new SOAPNameImpl();
        result.init(this.getPrefix(), this.getLocalName(), this.getNamespaceURI());
        return result;
    }

    public String getEncodingStyle() {
        return super.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
    }

    public Iterator getNamespacePrefixes() {
        IteratorImpl result = new IteratorImpl();
        NamedNodeMap attrs = this.getAttributes();
        int nAttrs = attrs.getLength();
        int i = 0;
        while (i < nAttrs) {
            org.w3c.dom.Node attr = attrs.item(i);
            String qname = attr.getNodeName();
            String value = attr.getNodeValue();
            if (qname.equals("xmlns")) {
                if (value != null && value.length() != 0) {
                    result.addElement("");
                }
            } else if (qname.startsWith("xmlns:") && value != null && value.length() != 0) {
                String prefix = qname.substring(6);
                result.addElement(prefix);
            }
            ++i;
        }
        return result;
    }

    public Iterator getVisibleNamespacePrefixes() {
        HashSet<String> set = new HashSet<String>();
        HashSet<String> undeclared = new HashSet<String>();
        Object node = this;
        boolean isDefaultNSReached = false;
        while (node instanceof Element) {
            String prefix;
            NamedNodeMap attrs = node.getAttributes();
            int nAttrs = attrs.getLength();
            int i = 0;
            while (i < nAttrs) {
                String prefix2;
                org.w3c.dom.Node attr = attrs.item(i);
                String qname = attr.getNodeName();
                String value = attr.getNodeValue();
                if (qname.equals("xmlns") && !isDefaultNSReached) {
                    isDefaultNSReached = true;
                    if (value.length() != 0) {
                        set.add("");
                    }
                } else if (qname.startsWith("xmlns:")) {
                    prefix2 = qname.substring(6);
                    if (!undeclared.contains(prefix2) && value.length() != 0 && !set.contains(prefix2)) {
                        set.add(prefix2);
                    } else if (value.length() == 0) {
                        undeclared.add(prefix2);
                    }
                } else if (attr.getNamespaceURI() != null && (prefix2 = attr.getPrefix()) != null && !undeclared.contains(prefix2) && !set.contains(prefix2)) {
                    set.add(prefix2);
                }
                ++i;
            }
            if (node.getNamespaceURI() != null && (prefix = node.getPrefix()) != null && !undeclared.contains(prefix) && !set.contains(prefix)) {
                set.add(prefix);
            }
            node = node.getParentNode();
        }
        return set.iterator();
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return DOM.prefixToURI((String)prefix, (org.w3c.dom.Node)((Object)this));
    }

    public boolean removeAttribute(Name name) {
        if (this.hasAttributeNS(name.getURI(), name.getLocalName())) {
            this.removeAttributeNS(name.getURI(), name.getLocalName());
            return true;
        }
        return false;
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        String qname = prefix == null || prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
        if (this.hasAttribute(qname)) {
            this.removeAttribute(qname);
            return true;
        }
        return false;
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (!"http://schemas.xmlsoap.org/soap/encoding/".equals(encodingStyle)) {
            throw new IllegalArgumentException("Only SOAP Encoding [http://schemas.xmlsoap.org/soap/encoding/] is allowed for soap messages, but you try to set [" + encodingStyle + "].");
        }
        super.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:encodingStyle", encodingStyle);
    }

    public String getValue() {
        org.w3c.dom.Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof SOAPTextImpl) {
                return ((SOAPTextImpl)child).getValue();
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public void setValue(String data) {
        org.w3c.dom.Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof SOAPTextImpl) {
                ((SOAPTextImpl)child).setValue(data);
                return;
            }
            child = child.getNextSibling();
        }
        SOAPTextImpl textNode = (SOAPTextImpl)super.getOwnerDocument().createTextNode(data);
        super.appendChild((org.w3c.dom.Node)textNode);
    }

    public void setParentElement(SOAPElement soapelement) throws SOAPException {
        if (this.elementType == 1) {
            if (soapelement == null) {
                throw new IllegalArgumentException("Parent Element of SOAPHeaderElement can not be set to null.");
            }
            if (soapelement instanceof SOAPBody) {
                throw new IllegalArgumentException("SOAPHeaderElement can not have for parent a SOAPBody.");
            }
        }
        if (this.elementType == 2) {
            if (soapelement == null) {
                throw new IllegalArgumentException("Parent Element of SOAPBodyElement can not be set to null.");
            }
            if (soapelement instanceof SOAPHeader) {
                throw new IllegalArgumentException("SOAPBodyElement can not have for parent a SOAPHeader.");
            }
        }
        this.setParent((NodeImpl)((SOAPElementImpl)soapelement));
    }

    public SOAPElement getParentElement() {
        return (SOAPElementImpl)((Object)this.getParentNode());
    }

    public void detachNode() {
        if (this.getParentNode() != null) {
            this.getParentNode().removeChild((org.w3c.dom.Node)((Object)this));
            this.setParent(null);
        }
    }

    public void recycleNode() {
        NodeList childs = super.getChildNodes();
        int size = childs.getLength();
        int i = 0;
        while (i < size) {
            Node node = (Node)childs.item(i);
            node.recycleNode();
            ++i;
        }
        ((SOAPDocumentImpl)((Object)this.getOwnerDocument())).pool.reuseElement(this);
    }

    public final boolean isReference() {
        return this.getAttribute("href").length() != 0;
    }

    public final String getReferenceId() {
        String result = this.getAttribute("href");
        result = result != null && result.trim().length() <= 1 ? null : result.trim().substring(1);
        return result;
    }

    public void setActor(String actorURI) {
        this.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:actor", actorURI);
    }

    public String getActor() {
        return this.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor");
    }

    public void setMustUnderstand(boolean flag) {
        if (flag) {
            this.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:mustUnderstand", "1");
        } else {
            this.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:mustUnderstand", "0");
        }
    }

    public boolean getMustUnderstand() {
        String result = this.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
        return "1".equals(result) || "true".equals(result);
    }

    public void removeContents() {
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            super.removeChild((org.w3c.dom.Node)it.next());
        }
    }
}

