/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.engine.services.webservices.jaxm.soap.HTTPSocket;
import com.sap.engine.services.webservices.jaxm.soap.MessageFactoryImpl;
import com.sap.engine.services.webservices.jaxm.soap.SAPSoapException;
import com.sap.engine.services.webservices.jaxm.soap.SOAPMessageImpl;
import com.sap.engine.services.webservices.jaxm.soap.accessor.NestedSOAPException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.messaging.Endpoint;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SOAPConnectionImpl
extends SOAPConnection {
    private MessageFactoryImpl messageFactory = new MessageFactoryImpl();
    private String userName = null;
    private String password = "";
    private String proxyHost = SystemProperties.getProperty((String)"http.proxyHost", null);
    private int proxyPort = new Integer(SystemProperties.getProperty((String)"http.proxyPort", (String)"-1"));
    private String excludeList;
    private boolean closed = false;

    public SOAPConnectionImpl() {
        this.userName = SystemProperties.getProperty((String)"http.proxyUserName", null);
        this.password = SystemProperties.getProperty((String)"http.proxyPassword", null);
        this.excludeList = SystemProperties.getProperty((String)"http.nonProxyHosts", null);
    }

    private boolean useProxyForAddress(String address) {
        if (this.excludeList == null) {
            return true;
        }
        if (SOAPConnectionImpl.useProxyForSpecificAddress(address = address.toLowerCase(), this.excludeList)) {
            try {
                InetAddress[] addresses = InetAddress.getAllByName(address);
                int i = 0;
                while (i < addresses.length) {
                    InetAddress addr = addresses[i];
                    if (!SOAPConnectionImpl.useProxyForSpecificAddress(addr.getHostAddress(), this.excludeList)) {
                        return false;
                    }
                    if (!SOAPConnectionImpl.useProxyForSpecificAddress(addr.getHostName(), this.excludeList)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            catch (UnknownHostException uhe) {
                return true;
            }
        }
        return false;
    }

    private static boolean checkExcludeList(String address, String excludeList, String separator) {
        StringTokenizer tokenizer = new StringTokenizer(excludeList, separator, false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            int starIndex = token.indexOf("*");
            if (starIndex != -1) {
                String start = token.substring(0, starIndex);
                String end = token.substring(starIndex + 1);
                if (!address.startsWith(start) || !address.endsWith(end)) continue;
                return false;
            }
            if (!token.equals(address)) continue;
            return false;
        }
        return true;
    }

    private static boolean useProxyForSpecificAddress(String address, String excludeList) {
        if ("localhost".equals(address) || "127.0.0.1".equals(address)) {
            return false;
        }
        if (excludeList == null || excludeList.trim().length() == 0) {
            return true;
        }
        if (!SOAPConnectionImpl.checkExcludeList(address, excludeList, ";")) {
            return false;
        }
        return SOAPConnectionImpl.checkExcludeList(address, excludeList, "|");
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void setProxyExcludeList(String excludeList) {
        this.excludeList = excludeList;
    }

    public String getProxyExcludeList() {
        return this.excludeList;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserPassword(String password) {
        this.password = password;
    }

    public SOAPMessage call(SOAPMessage message, Endpoint endpoint) throws SOAPException {
        try {
            if (this.closed) {
                throw new NestedSOAPException("webservices_3714");
            }
            HTTPSocket httpsock = this.createHTTPSocket(endpoint);
            return this.call(message, httpsock);
        }
        catch (IOException e) {
            throw new SAPSoapException("IOError while transmiting message ! See nested Exception !", e);
        }
    }

    public SOAPMessage call(SOAPMessage message, HTTPSocket httpsock) throws SOAPException {
        try {
            if (message.saveRequired()) {
                message.saveChanges();
            }
            MimeHeaders mimeheaders = message.getMimeHeaders();
            Iterator iterator = mimeheaders.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeheader = (MimeHeader)iterator.next();
                httpsock.setHeader(mimeheader.getName(), mimeheader.getValue());
            }
            OutputStream outputstream = httpsock.getOutputStream();
            message.writeTo(outputstream);
            outputstream.flush();
            int http_response = httpsock.getResponseCode();
            if (http_response != 200) {
                if (http_response == 500) {
                    if (httpsock.getContentType() == null || httpsock.getContentType().indexOf("text/xml") == -1) {
                        throw new NestedSOAPException("webservices_3711", httpsock.getResponseMessage());
                    }
                    InputStream inputstream = httpsock.getInputStream();
                    SOAPMessageImpl messageReply = (SOAPMessageImpl)this.messageFactory.createMessage(inputstream);
                    inputstream.close();
                    httpsock.disconnect();
                    return messageReply;
                }
                throw new NestedSOAPException("webservices_3711", httpsock.getResponseMessage());
            }
            MimeHeaders mimeheaders1 = new MimeHeaders();
            Enumeration en = httpsock.getHeaderNames();
            while (en.hasMoreElements()) {
                String current = (String)en.nextElement();
                String[] currentHeaderValues = httpsock.getHeader(current);
                int i = 0;
                while (i < currentHeaderValues.length) {
                    mimeheaders1.addHeader(current, currentHeaderValues[i]);
                    ++i;
                }
            }
            InputStream inputstream = httpsock.getInputStream();
            SOAPMessage message1 = this.messageFactory.createMessage(mimeheaders1, inputstream);
            inputstream.close();
            httpsock.disconnect();
            return message1;
        }
        catch (IOException e) {
            throw new NestedSOAPException("webservices_3709", e);
        }
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw new NestedSOAPException("webservices_3715");
        }
        this.closed = true;
    }

    private static String encodeAuth(String userName, String password) {
        byte[] result = BASE64Encoder.encode((byte[])(userName + ":" + password).getBytes());
        return new String(result, 0, result.length);
    }

    public HTTPSocket createHTTPSocket(String endpoint) throws MalformedURLException {
        return this.createHTTPSocket(new Endpoint(endpoint));
    }

    public HTTPSocket createHTTPSocket(Endpoint endpoint) throws MalformedURLException {
        URL url = new URL(endpoint.toString());
        HTTPSocket sock = new HTTPSocket(url);
        sock.setRequestMethod("POST");
        if (this.userName != null && this.userName.length() != 0) {
            sock.setHeader("Authorization", "Basic " + SOAPConnectionImpl.encodeAuth(this.userName, this.password));
        }
        sock.setHeader("Connection", "Close");
        if (this.proxyHost != null && this.useProxyForAddress(url.getHost())) {
            sock.setProxy(this.proxyHost, this.proxyPort);
        }
        return sock;
    }

    public SOAPMessage call(SOAPMessage soapMessage, Object o) throws SOAPException {
        if (this.closed) {
            throw new NestedSOAPException("webservices_3714");
        }
        if (o instanceof Endpoint) {
            return this.call(soapMessage, (Endpoint)o);
        }
        if (o instanceof String) {
            return this.call(soapMessage, new Endpoint((String)o));
        }
        if (o instanceof HTTPSocket) {
            return this.call(soapMessage, (HTTPSocket)o);
        }
        return null;
    }
}

