/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamLogger
extends BufferedOutputStream {
    private OutputStream log;

    public OutputStreamLogger(OutputStream out, OutputStream log) {
        super(out);
        this.log = log;
    }

    public OutputStreamLogger(OutputStream out, int size, OutputStream log) {
        super(out, size);
        this.log = log;
    }

    public synchronized void write(int b) throws IOException {
        super.write(b);
        this.log.write(b);
        this.log.flush();
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.log.write(b, off, len);
        this.log.flush();
    }

    public synchronized void flush() throws IOException {
        super.flush();
        this.log.flush();
    }

    public synchronized void writeHidden(String normalText, String hiddenText) throws IOException {
        byte[] normalTextBytes = normalText.getBytes();
        super.write(normalTextBytes, 0, normalTextBytes.length);
        this.log.write(hiddenText.getBytes());
        this.log.flush();
    }
}

