/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.interfaces.webservices.client.WSConnection;
import com.sap.engine.interfaces.webservices.client.WSConnectionFactory;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxy;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.engine.services.webservices.jaxm.soap.InputStreamLogger;
import com.sap.engine.services.webservices.jaxm.soap.OutputStreamLogger;
import com.sap.engine.services.webservices.jaxm.soap.SSLSocketUtilInterface;
import com.sap.engine.services.webservices.tools.ChunkedInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class HTTPSocket {
    public static boolean onServer = false;
    private OutputStream logInputStream = null;
    private OutputStream logOutputStream = null;
    private Socket sock = null;
    private WSConnection wsConnection;
    private InputStream connectionInputStream;
    private OutputStream connectionOutputStream;
    private String host = null;
    private String portStr = null;
    private int port = -1;
    private String file = null;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyUser;
    private String proxyPass;
    private HTTPProxyResolver proxyResolver;
    private Hashtable headers = new Hashtable();
    private Hashtable headerNames = new Hashtable();
    private String lastPutHeader;
    private BufferedInputStream inputStream = null;
    private BufferedOutputStream outputStream = null;
    private boolean bSentHeaders = false;
    private boolean bReadHeaders = false;
    private CharArray buffer = new CharArray(100);
    private int responseCode = -1;
    private String responseString = null;
    private String requestMethod = null;
    private boolean secure = false;
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private int socketTimeout = 60000;
    List clientCertificateList;
    List serverCertificateList;
    boolean ignoreServerCertificates = true;

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setLogger(OutputStream logInputStream, OutputStream logOutputStream) {
        this.logInputStream = logInputStream;
        this.logOutputStream = logOutputStream;
    }

    public OutputStream getInputLogger() {
        return this.logInputStream;
    }

    public OutputStream getOutputLogger() {
        return this.logOutputStream;
    }

    public HTTPSocket(URL url) {
        if ("https".equals(url.getProtocol())) {
            this.secure = true;
        }
        this.host = url.getHost();
        this.portStr = Integer.toString(url.getPort());
        this.port = url.getPort();
        this.file = url.getFile();
    }

    public HTTPSocket(String host, int port, String file) {
        this.host = host;
        this.portStr = Integer.toString(port);
        this.port = port;
        this.file = file;
    }

    public void setProxy(String host, int port) {
        this.setProxy(host, port, null, null);
    }

    public void setProxy(String host, int port, String proxyUser, String proxyPass) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyUser = proxyUser;
        this.proxyPass = proxyPass;
    }

    public void setHTTPProxyResolver(HTTPProxyResolver proxyResolver) {
        this.proxyResolver = proxyResolver;
    }

    public void setHeader(String headerName, String value) {
        String header = headerName.toLowerCase();
        this.headerNames.put(header, headerName);
        String[] hh = (String[])this.headers.get(header);
        String[] newhh = null;
        if (hh == null) {
            newhh = new String[]{value};
        } else {
            newhh = new String[hh.length + 1];
            System.arraycopy(hh, 0, newhh, 0, hh.length);
            newhh[hh.length] = value;
        }
        this.lastPutHeader = header;
        this.headers.put(header, newhh);
    }

    private void setHeader(String headerName, String value, boolean check) {
        String header = headerName.toLowerCase();
        this.headerNames.put(header, headerName);
        String[] hh = (String[])this.headers.get(header);
        hh[hh.length - 1] = hh[hh.length - 1] + value;
        this.headers.put(header, hh);
    }

    public String[] getHeader(String header) {
        header = header.toLowerCase();
        return (String[])this.headers.get(header);
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public Hashtable getHeaders() {
        return this.headers;
    }

    public int getResponseCode() throws IOException {
        if (!this.bReadHeaders) {
            this.getInputStream();
        }
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        if (!this.bReadHeaders) {
            this.getInputStream();
        }
        return this.responseString;
    }

    public String getContentType() throws IOException {
        String[] h;
        if (!this.bReadHeaders) {
            this.getInputStream();
        }
        if ((h = this.getHeader("Content-Type")) != null) {
            return h[h.length - 1];
        }
        return null;
    }

    public int getContentLength() throws IOException {
        String[] h;
        if (!this.bReadHeaders) {
            this.getInputStream();
        }
        if ((h = this.getHeader("Content-Length")) != null) {
            return Integer.parseInt(h[h.length - 1]);
        }
        return -1;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.bSentHeaders) {
            this.getOutputStream();
        }
        if (!this.bReadHeaders) {
            String[] encodings;
            this.headers.clear();
            this.inputStream = this.logInputStream != null ? new InputStreamLogger(this.connectionInputStream, this.logInputStream) : new BufferedInputStream(this.connectionInputStream);
            String line = null;
            boolean bReadFirstLine = false;
            boolean bGotEmptyLine = false;
            while ((line = this.readLine()) != null) {
                if (line.startsWith("HTTP/1.1 100")) {
                    do {
                        if ((line = this.readLine()) != null) continue;
                        throw new IOException("Unexpected end of response!");
                    } while (!line.startsWith("HTTP"));
                }
                if (!bGotEmptyLine && line.length() == 0) break;
                if (!bReadFirstLine) {
                    this.parseFirstLine(line);
                    bReadFirstLine = true;
                    continue;
                }
                this.parseHeaderLine(line);
            }
            if ((encodings = this.getHeader("Transfer-Encoding")) != null) {
                int i = 0;
                while (i < encodings.length) {
                    if ("chunked".equalsIgnoreCase(encodings[i])) {
                        if (this.logInputStream != null) {
                            this.inputStream = new InputStreamLogger((InputStream)new ChunkedInputStream(this.inputStream), this.logInputStream);
                            break;
                        }
                        this.inputStream = new BufferedInputStream(new ChunkedInputStream(this.inputStream));
                        break;
                    }
                    ++i;
                }
            }
            this.bReadHeaders = true;
            if (this.logInputStream != null) {
                ((InputStreamLogger)this.inputStream).setParseHeaders(false);
            }
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.bSentHeaders) {
            this.initializeStreams();
            this.outputStream = this.logOutputStream != null ? new OutputStreamLogger(this.connectionOutputStream, this.logOutputStream) : new BufferedOutputStream(this.connectionOutputStream);
            this.sendRequest();
            this.sendHeaders();
            this.bSentHeaders = true;
        }
        return this.outputStream;
    }

    private void initializeStreams() throws IOException {
        if (this.port == -1) {
            this.port = this.secure ? 443 : 80;
        }
        if (this.proxyHost == null && this.proxyResolver != null) {
            HTTPProxy proxy = this.proxyResolver.getHTTPProxyForHost(this.host);
            if (proxy != null) {
                this.proxyHost = proxy.getProxyHost();
                this.proxyPort = proxy.getProxyPort();
                this.proxyUser = proxy.getProxyUser();
                this.proxyPass = proxy.getProxyPass();
            } else {
                this.proxyHost = null;
                this.proxyPort = 80;
                this.proxyUser = null;
                this.proxyPass = null;
            }
        }
        if (onServer) {
            this.initStreamsFromConnection();
        } else {
            this.initStreamsFromSocket();
        }
    }

    private void initStreamsFromConnection() throws IOException {
        WSConnectionFactory factory;
        try {
            InitialContext ctx = new InitialContext();
            factory = (WSConnectionFactory)ctx.lookup("/wsContext/WSConnectionFactory");
        }
        catch (NamingException e) {
            throw new IOException(e.toString());
        }
        this.wsConnection = this.secure ? factory.getSSLConnection(this.host, this.port, this.proxyHost, this.proxyPort) : factory.getConnection(this.host, this.port, this.proxyHost, this.proxyPort);
        this.connectionOutputStream = this.wsConnection.getOutputStream();
        this.connectionInputStream = this.wsConnection.getInputStream();
    }

    private void initStreamsFromSocket() throws IOException {
        if (this.proxyHost != null) {
            if (!this.secure) {
                this.sock = new Socket(this.proxyHost, this.proxyPort);
                if (this.proxyUser != null) {
                    this.setHeader("Proxy-Authorization", "Basic " + HTTPSocket.encodeAuth(this.proxyUser, this.proxyPass));
                }
            } else {
                SSLSocketUtilInterface sslUtil = null;
                try {
                    sslUtil = (SSLSocketUtilInterface)Class.forName("com.sap.engine.services.webservices.jaxm.soap.SSLUtilUsingHttpsLibImpl").newInstance();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                if (sslUtil == null) {
                    try {
                        sslUtil = (SSLSocketUtilInterface)Class.forName("com.sap.engine.services.webservices.jaxm.soap.SSLUtilImpl").newInstance();
                    }
                    catch (Throwable ex) {
                        throw new IOException("SSL not available: " + ex.toString());
                    }
                }
                this.sock = sslUtil.createSSLSocket(this.host, this.port, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPass, this.clientCertificateList, this.serverCertificateList, this.isIgnoreServerCertificates());
            }
        } else if (!this.secure) {
            this.sock = new Socket(this.host, this.port);
        } else {
            SSLSocketUtilInterface sslUtil = null;
            try {
                sslUtil = (SSLSocketUtilInterface)Class.forName("com.sap.engine.services.webservices.jaxm.soap.SSLUtilUsingHttpsLibImpl").newInstance();
            }
            catch (Throwable ex) {
                // empty catch block
            }
            if (sslUtil == null) {
                try {
                    sslUtil = (SSLSocketUtilInterface)Class.forName("com.sap.engine.services.webservices.jaxm.soap.SSLUtilImpl").newInstance();
                }
                catch (Throwable ex) {
                    throw new IOException("SSL not available: " + ex.getMessage());
                }
            }
            this.sock = sslUtil.createSSLSocket(this.host, this.port, this.clientCertificateList, this.serverCertificateList, this.isIgnoreServerCertificates());
        }
        this.connectionOutputStream = this.sock.getOutputStream();
        this.connectionInputStream = this.sock.getInputStream();
        this.sock.setSoTimeout(this.socketTimeout);
        this.sock.setTcpNoDelay(true);
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void disconnect() throws IOException {
        this.inputStream.close();
        this.outputStream.close();
        if (this.sock != null) {
            this.sock.close();
        }
        if (this.wsConnection != null) {
            this.wsConnection.close();
        }
    }

    private void write(String data) throws IOException {
        int i = 0;
        while (i < data.length()) {
            this.outputStream.write((byte)data.charAt(i));
            ++i;
        }
    }

    private void sendRequest() throws IOException {
        this.write(this.requestMethod);
        this.write(" ");
        if (!this.secure && this.proxyHost != null) {
            this.write("http://");
            this.write(this.host);
            if (this.port != -1 && this.port != 80) {
                this.write(":");
                this.write(this.portStr);
            }
        }
        if (this.file.length() > 0 && this.file.charAt(0) != '/') {
            this.write("/");
        }
        this.write(this.file);
        this.write(" HTTP/1.1\r\n");
        this.write("Host: " + this.host + ":" + this.port + "\r\n");
    }

    private void sendHeaders() throws IOException {
        Enumeration headerKeys = this.headers.keys();
        boolean hasLog = this.outputStream instanceof OutputStreamLogger;
        while (headerKeys.hasMoreElements()) {
            String name = (String)headerKeys.nextElement();
            String realName = (String)this.headerNames.get(name);
            if (realName == null) {
                realName = name;
            }
            String[] values = (String[])this.headers.get(name);
            int i = 0;
            while (i < values.length) {
                if (hasLog && ("authorization".equalsIgnoreCase(name) || "cookie".equalsIgnoreCase(name) || "set-cookie".equalsIgnoreCase(name))) {
                    ((OutputStreamLogger)this.outputStream).writeHidden(realName + ": " + values[i] + "\r\n", realName + ": <value is hidden>\r\n");
                } else {
                    this.write(realName);
                    this.write(": ");
                    this.write(values[i]);
                    this.write("\r\n");
                }
                ++i;
            }
        }
        this.write("\r\n");
    }

    private String readLine() throws IOException {
        int r = 0;
        this.buffer.clear();
        while ((r = this.inputStream.read()) != -1 && r != 10) {
            if (r == 13) continue;
            this.buffer.append((char)r);
        }
        if (r == -1 && this.buffer.length() == 0) {
            return null;
        }
        return this.buffer.toString();
    }

    private void parseFirstLine(String line) throws IOException {
        if (!line.startsWith("HTTP/1.0") && !line.startsWith("HTTP/1.1")) {
            throw new IOException("Bad Response: " + line);
        }
        this.responseCode = Integer.parseInt(line.substring(9, 12));
        this.responseString = line.substring(13);
    }

    private void parseHeaderLine(String line) throws IOException {
        if (line.startsWith(" ") || line.startsWith("\t")) {
            if (this.lastPutHeader == null) {
                throw new IOException("Incorrect header line: " + line);
            }
            this.setHeader(this.lastPutHeader, line.trim(), true);
        } else {
            int idx = line.indexOf(58);
            if (idx == -1) {
                throw new IOException("Expected ':' in header line: " + line);
            }
            String header = line.substring(0, idx).trim();
            String value = line.substring(idx + 1).trim();
            this.setHeader(header, value);
        }
    }

    public List getClientCertificateList() {
        return this.clientCertificateList;
    }

    public List getServerCertificateList() {
        return this.serverCertificateList;
    }

    public void setClientCertificateList(List clientCertificateList) {
        this.clientCertificateList = clientCertificateList;
    }

    public void setServerCertificateList(List serverCertificateList) {
        this.serverCertificateList = serverCertificateList;
    }

    public boolean isIgnoreServerCertificates() {
        return this.ignoreServerCertificates;
    }

    public void setIgnoreServerCertificates(boolean ignoreServerCertificates) {
        this.ignoreServerCertificates = ignoreServerCertificates;
    }

    public static String encodeAuth(String userName, String password) {
        byte[] result = BASE64Encoder.encode((byte[])(userName + ":" + password).getBytes());
        return new String(result, 0, result.length);
    }
}

