/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

import com.sap.lcr.api.cimclient.CIMConst;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.HttpDestinationStore;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimclient.SecureStoreAccess;
import com.sap.lcr.api.log.Logger;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.entities.ByteArrayEntity;
import com.tssap.dtr.client.lib.protocol.requests.RequestBase;
import com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.Properties;

public class SetDefaultConnect
implements CIMConst {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$util$SetDefaultConnect == null ? (class$com$sap$lcr$api$util$SetDefaultConnect = SetDefaultConnect.class$("com.sap.lcr.api.util.SetDefaultConnect")) : class$com$sap$lcr$api$util$SetDefaultConnect).getName());
    private static final String SPECIAL_PORT_VALUE = "DELETE";
    private static final String REMOVE_PARAM_NAME = "removeConfiguration";
    private static final String STORE_SERVLET_PATH = "/sld/store";
    static /* synthetic */ Class class$com$sap$lcr$api$util$SetDefaultConnect;

    SetDefaultConnect() {
    }

    private void usage() {
        System.err.println("Usage:");
        System.err.println(this.getClass() + " <SYShost> <SYSport> <SYSuser> <SYSpwd> <Servlet-Path> <SLDhost> <SLDport> <SLDuser> <SLDpwd>");
    }

    public static void main(String[] args) {
        SetDefaultConnect setter = new SetDefaultConnect();
        setter.set(args);
    }

    void set(String[] args) {
        if (args.length != 9) {
            this.usage();
            System.exit(1);
        }
        String syshost = args[0];
        String sysport = args[1];
        String sysuser = args[2];
        String syspass = args[3];
        String srvpath = args[4];
        String sldhost = args[5];
        String sldport = args[6];
        String slduser = args[7];
        String sldpass = args[8];
        if (sysuser.equals("EMPTY")) {
            sysuser = "";
        }
        if (syspass.equals("EMPTY")) {
            syspass = "";
        }
        if (srvpath.equals("EMPTY")) {
            srvpath = STORE_SERVLET_PATH;
        }
        if (slduser.equals("EMPTY")) {
            slduser = "";
        }
        if (sldpass.equals("EMPTY")) {
            sldpass = "";
        }
        Properties connProps = SetDefaultConnect.createConnectProperties(sldhost, sldport, slduser, sldpass);
        SetDefaultConnect.executeConfigRequest(syshost, sysport, sysuser, syspass, srvpath, connProps, "SLD connect parameters");
    }

    /*
     * WARNING - void declaration
     */
    public static void executeConfigRequest(String syshost, String sysport, String sysuser, String syspass, String servletPath, Properties connProps, String propHeader) {
        SessionContext sessionContext = new SessionContext(sysuser, syspass);
        sessionContext.setAuthenticator((IAuthenticator)new BasicAuthenticator((ISessionContext)sessionContext));
        URL servletURL = null;
        Connection servletConnection = null;
        try {
            servletURL = new URL("http", syshost, Integer.valueOf(sysport).intValue(), servletPath);
            servletConnection = new Connection(servletURL, (ISessionContext)sessionContext);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            System.exit(1);
        }
        RequestBase configRequest = new RequestBase("POST", servletPath);
        ByteArrayOutputStream entityStream = new ByteArrayOutputStream();
        try {
            connProps.store(entityStream, propHeader);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
        }
        byte[] entity = entityStream.toByteArray();
        configRequest.setRequestEntity((IRequestEntity)new ByteArrayEntity(entity, "text/xml; charset=iso-8859-1"));
        IResponse response = null;
        try {
            response = servletConnection.send((IRequest)configRequest);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            System.exit(1);
        }
        catch (HTTPException he) {
            System.out.println(he.getMessage());
            System.exit(1);
        }
        try {
            String inputLine;
            int responseCode = response.getStatus();
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("HTTP response code: " + responseCode);
            }
            InputStreamReader streamReader = new InputStreamReader(response.getStream());
            BufferedReader bufferedReader = new BufferedReader(streamReader);
            while ((inputLine = bufferedReader.readLine()) != null) {
                void var17_22;
                System.out.println((String)var17_22);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static Properties createConnectProperties(String host, String port, String user, String pwd) {
        Properties connProps;
        HttpDestinationStore dests;
        try {
            dests = SecureStoreAccess.loadConfigFromSecureStore();
        }
        catch (LcrException lce) {
            dests = null;
        }
        if (dests == null) {
            if (CIMTraceUtil.traceLevel >= 2) {
                myLogger.info("No SLD destinations found in secure store");
            }
            dests = new HttpDestinationStore();
        }
        if (port.equals(SPECIAL_PORT_VALUE)) {
            connProps = new Properties();
            connProps.setProperty(REMOVE_PARAM_NAME, "yes");
            if (CIMTraceUtil.traceLevel >= 2) {
                myLogger.info("Delete request for SLD destinations created");
            }
        } else {
            int iport;
            try {
                iport = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                if (CIMTraceUtil.traceLevel >= 3) {
                    myLogger.debug("Invalid port number " + port, nfe);
                }
                iport = 0;
            }
            dests.setHttpDestination(null, host, iport, user, pwd);
            connProps = dests.getProperties();
            if (CIMTraceUtil.traceLevel >= 2) {
                myLogger.info("Change request for the default SLD destination created");
            }
        }
        return connProps;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

