/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassList;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemList;
import com.sap.lcr.api.cim.CIMItemWAWQ;
import com.sap.lcr.api.cim.CIMNamespace;
import com.sap.lcr.api.cim.CIMQualifierDeclaration;
import com.sap.lcr.api.cim.CIMQualifierDeclarationList;
import com.sap.lcr.api.cim.CIMValueNamedInstance;
import com.sap.lcr.api.cim.CIMValueNamedInstanceList;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMNames;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.HttpRequestSender;
import com.sap.lcr.api.cimclient.LcrException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NamespaceDifference {
    private static final int MIN_MAP_SIZE = 32;
    private static final CIMClassname[] EXCLUDE_CLASSES = new CIMClassname[]{CIMNames.C_SAP_CIMData, CIMNames.C_SAP_CIMDataPrerequisite, CIMNames.C_SAP_CIMExportLine, CIMNames.C_SAP_CIMExportIncompatibility, CIMNames.C_SAP_MemberOfExportLine, CIMNames.C___Namespace};
    private static final HashSet REPLACE_OWNER_CLASSES = new HashSet<CIMClassname>(Arrays.asList(CIMNames.C_SAP_AllowedNamespacePrefix, CIMNames.C_SAP_BuiltSoftwareComponentArchive, CIMNames.C_SAP_DevelopmentComponent, CIMNames.C_SAP_PropagationRequest, CIMNames.C_SAP_SoftwareComponent));
    private static PrintStream[] printStreams;
    private CIMOMHandle leftCIMClient;
    private CIMOMHandle rightCIMClient;
    private CIMNamespace leftCIMNamespace;
    private CIMNamespace rightCIMNamespace;
    private ArrayList leftMissingClasses = new ArrayList();
    private ArrayList rightMissingClasses = new ArrayList();
    private ArrayList leftMissingQualifiers = new ArrayList();
    private ArrayList rightMissingQualifiers = new ArrayList();
    private ArrayList leftMissingInstances = new ArrayList();
    private ArrayList rightMissingInstances = new ArrayList();
    private ArrayList differingClasses = new ArrayList();
    private ArrayList differingQualifiers = new ArrayList();
    private ArrayList differingInstances = new ArrayList();
    private ArrayList ownerDifferingInstances = new ArrayList();
    private ArrayList bothClassNames = new ArrayList();
    static /* synthetic */ Class class$com$sap$lcr$api$util$NamespaceDifference;

    public NamespaceDifference(String leftNamespace, CIMOMHandle leftClient, String rightNamespace, CIMOMHandle rightClient) {
        this.leftCIMNamespace = CIMFactory.namespace(leftNamespace);
        this.leftCIMClient = leftClient;
        this.rightCIMNamespace = CIMFactory.namespace(rightNamespace);
        this.rightCIMClient = rightClient;
        this.leftCIMClient.setLocalNamespacePath(CIMFactory.localnamespacepath(this.leftCIMNamespace));
        this.rightCIMClient.setLocalNamespacePath(CIMFactory.localnamespacepath(this.rightCIMNamespace));
    }

    private void prepareItem(CIMItemWAWQ item) {
        item.removeQualifier("SAP_CreationTime");
        item.removeQualifier("SAP_LastModificationTime");
        item.removeQualifier("SAP_ProviderSyncTime");
    }

    private void prepareItemList(CIMItemList itemList) {
        Iterator iter = itemList.iterator();
        while (iter.hasNext()) {
            CIMItem nextItem = (CIMItem)iter.next();
            if (nextItem instanceof CIMItemWAWQ) {
                this.prepareItem((CIMItemWAWQ)nextItem);
                continue;
            }
            if (!(nextItem instanceof CIMValueNamedInstance)) continue;
            CIMInstance nextInstance = ((CIMValueNamedInstance)nextItem).getInstance();
            this.prepareItem(nextInstance);
        }
    }

    public void evaluateQualifierDifference() throws CIMClientException, LcrException {
        CIMQualifierDeclarationList leftQualifiers = this.leftCIMClient.enumerateQualifiers();
        CIMQualifierDeclarationList rightQualifiers = this.rightCIMClient.enumerateQualifiers();
        int i = 0;
        while (i < leftQualifiers.size()) {
            CIMQualifierDeclaration nextQualifier1 = leftQualifiers.get(i);
            CIMQualifierDeclaration nextQualifier2 = this.searchQualifier(nextQualifier1, rightQualifiers);
            if (nextQualifier2 == null) {
                this.rightMissingQualifiers.add(nextQualifier1);
            } else if (!nextQualifier2.equals(nextQualifier1)) {
                this.differingQualifiers.add(new QualifierDifference(nextQualifier1, nextQualifier2));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < rightQualifiers.size()) {
            CIMQualifierDeclaration nextQualifier1 = rightQualifiers.get(i2);
            CIMQualifierDeclaration nextQualifier2 = this.searchQualifier(nextQualifier1, leftQualifiers);
            if (nextQualifier2 == null) {
                this.leftMissingQualifiers.add(nextQualifier1);
            }
            ++i2;
        }
    }

    private CIMQualifierDeclaration searchQualifier(CIMQualifierDeclaration qSearch, CIMQualifierDeclarationList qList) {
        String qSearchName = qSearch.getName();
        int i = 0;
        while (i < qList.size()) {
            CIMQualifierDeclaration nextQual = qList.get(i);
            if (nextQual.getName().equalsIgnoreCase(qSearchName)) {
                return nextQual;
            }
            ++i;
        }
        return null;
    }

    public void evaluateClassDifference(boolean excludeStd) throws CIMClientException, LcrException {
        CIMClassList leftClasses = (CIMClassList)this.leftCIMClient.enumerateClasses(null, true, false, true, true).getWritable();
        this.prepareItemList(leftClasses);
        CIMClassList rightClasses = (CIMClassList)this.rightCIMClient.enumerateClasses(null, true, false, true, true).getWritable();
        this.prepareItemList(rightClasses);
        HashMap leftMap = new HashMap(1 + 4 * leftClasses.size() / 3);
        HashMap rightMap = new HashMap(1 + 4 * rightClasses.size() / 3);
        this.fillClassMap(leftClasses, leftMap);
        this.fillClassMap(rightClasses, rightMap);
        int i = 0;
        while (i < leftClasses.size()) {
            CIMClass nextClass1 = leftClasses.get(i);
            if (!excludeStd || !this.excludeClass(nextClass1)) {
                CIMClass nextClass2 = this.searchClass(nextClass1, rightMap);
                if (nextClass2 == null) {
                    this.rightMissingClasses.add(nextClass1);
                } else if (!nextClass2.equals(nextClass1)) {
                    this.differingClasses.add(new ClassDifference(nextClass1, nextClass2));
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < rightClasses.size()) {
            CIMClass nextClass2;
            CIMClass nextClass1 = rightClasses.get(i2);
            if (!(excludeStd && this.excludeClass(nextClass1) || (nextClass2 = this.searchClass(nextClass1, leftMap)) != null)) {
                this.leftMissingClasses.add(nextClass1);
            }
            ++i2;
        }
    }

    private CIMClass searchClass(CIMClass cSearch, Map cMap) {
        CIMClassname cSearchName = cSearch.getCIMClassname();
        return (CIMClass)cMap.get(cSearchName);
    }

    private void fillClassMap(CIMClassList iList, Map iMap) {
        Iterator iter = iList.iterator();
        while (iter.hasNext()) {
            CIMClass nextClass = (CIMClass)iter.next();
            iMap.put(nextClass.getCIMClassname(), nextClass);
        }
    }

    private boolean excludeClass(CIMClass cTest) {
        int i = 0;
        while (i < EXCLUDE_CLASSES.length) {
            if (cTest.getCIMClassname().equals(EXCLUDE_CLASSES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void evaluateInstanceDifference(String className, boolean withSubClasses, boolean excludeStd) throws CIMClientException, LcrException {
        CIMValueNamedInstanceList rightInstances;
        CIMValueNamedInstanceList leftInstances;
        if (className == null) {
            CIMClassList allLeftClasses = this.leftCIMClient.enumerateClasses(null, true, false, true, true);
            CIMClassList allRightClasses = this.rightCIMClient.enumerateClasses(null, true, false, true, true);
            int i = 0;
            while (i < allLeftClasses.size()) {
                CIMClass nextLeftClass = allLeftClasses.get(i);
                if (!(nextLeftClass.isIndication() || excludeStd && this.excludeClass(nextLeftClass))) {
                    CIMClassname nextLeftClassName = nextLeftClass.getCIMClassname();
                    boolean found = false;
                    int j = 0;
                    while (j < allRightClasses.size()) {
                        CIMClassname nextRightClassName = allRightClasses.get(j).getCIMClassname();
                        if (nextLeftClassName.equals(nextRightClassName)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (found) {
                        this.bothClassNames.add(nextLeftClassName);
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.bothClassNames.size()) {
                this.evaluateInstanceDifference(((CIMClassname)this.bothClassNames.get(i2)).toString(), withSubClasses, excludeStd);
                ++i2;
            }
            return;
        }
        CIMClassname compClassName = CIMFactory.classname(className);
        if (withSubClasses) {
            leftInstances = (CIMValueNamedInstanceList)this.leftCIMClient.enumerateInstances(compClassName, false, true, true, true, null).getWritable();
            rightInstances = (CIMValueNamedInstanceList)this.rightCIMClient.enumerateInstances(compClassName, false, true, true, true, null).getWritable();
        } else {
            leftInstances = (CIMValueNamedInstanceList)this.leftCIMClient.enumerateInstancesNoSubclasses(compClassName, false, true, true, null).getWritable();
            rightInstances = (CIMValueNamedInstanceList)this.rightCIMClient.enumerateInstancesNoSubclasses(compClassName, false, true, true, null).getWritable();
        }
        this.prepareItemList(leftInstances);
        this.prepareItemList(rightInstances);
        HashMap leftMap = null;
        HashMap rightMap = null;
        if (leftInstances.size() >= 32) {
            leftMap = new HashMap(1 + 4 * leftInstances.size() / 3);
            this.fillInstanceMap(leftInstances, leftMap);
        }
        if (rightInstances.size() >= 32) {
            rightMap = new HashMap(1 + 4 * rightInstances.size() / 3);
            this.fillInstanceMap(rightInstances, rightMap);
        }
        int i = 0;
        while (i < leftInstances.size()) {
            CIMValueNamedInstance nextInstance1 = leftInstances.get(i);
            CIMValueNamedInstance nextInstance2 = this.searchInstance(nextInstance1, rightInstances, rightMap);
            if (nextInstance2 == null) {
                this.rightMissingInstances.add(nextInstance1);
            } else if (!nextInstance2.getInstance().equals(nextInstance1.getInstance())) {
                boolean onlyOwnerDifference = false;
                if (excludeStd && REPLACE_OWNER_CLASSES.contains(nextInstance1.getInstance().getCIMClassname())) {
                    CIMInstance instance1 = nextInstance1.getInstance();
                    CIMInstance instance2 = nextInstance2.getInstance();
                    instance1.removeProperty("Owner");
                    instance2.removeProperty("Owner");
                    onlyOwnerDifference = instance1.equals(instance2);
                }
                InstanceDifference instanceDifference = new InstanceDifference(nextInstance1, nextInstance2);
                if (onlyOwnerDifference) {
                    this.ownerDifferingInstances.add(instanceDifference);
                } else {
                    this.differingInstances.add(instanceDifference);
                }
            }
            ++i;
        }
        int i3 = 0;
        while (i3 < rightInstances.size()) {
            CIMValueNamedInstance nextInstance1 = rightInstances.get(i3);
            CIMValueNamedInstance nextInstance2 = this.searchInstance(nextInstance1, leftInstances, leftMap);
            if (nextInstance2 == null) {
                this.leftMissingInstances.add(nextInstance1);
            }
            ++i3;
        }
    }

    private CIMValueNamedInstance searchInstance(CIMValueNamedInstance iSearch, CIMValueNamedInstanceList iList, Map iMap) {
        CIMInstancename iSearchName = iSearch.getInstancename();
        if (iMap == null) {
            int i = 0;
            while (i < iList.size()) {
                CIMValueNamedInstance nextVNI = iList.get(i);
                if (nextVNI.getInstancename().equals(iSearchName)) {
                    return nextVNI;
                }
                ++i;
            }
        } else {
            return (CIMValueNamedInstance)iMap.get(iSearchName);
        }
        return null;
    }

    private void fillInstanceMap(CIMValueNamedInstanceList iList, Map iMap) {
        Iterator iter = iList.iterator();
        while (iter.hasNext()) {
            CIMValueNamedInstance nextVNI = (CIMValueNamedInstance)iter.next();
            iMap.put(nextVNI.getInstancename(), nextVNI);
        }
    }

    public CIMOMHandle getLeftCIMClient() {
        return this.leftCIMClient;
    }

    public List getdifferingClasses() {
        return this.differingClasses;
    }

    public List getDifferingInstances() {
        return this.differingInstances;
    }

    public List getOwnerDifferingInstances() {
        return this.ownerDifferingInstances;
    }

    public List getBothClassNames() {
        return this.bothClassNames;
    }

    public List getdifferingQualifiers() {
        return this.differingQualifiers;
    }

    public List getLeftMissingClasses() {
        return this.leftMissingClasses;
    }

    public List getLeftMissingInstances() {
        return this.leftMissingInstances;
    }

    public List getLeftMissingQualifiers() {
        return this.leftMissingQualifiers;
    }

    public CIMOMHandle getRightCIMClient() {
        return this.rightCIMClient;
    }

    public List getRightMissingClasses() {
        return this.rightMissingClasses;
    }

    public List getRightMissingInstances() {
        return this.rightMissingInstances;
    }

    public List getRightMissingQualifiers() {
        return this.rightMissingQualifiers;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int i22222;
        Throwable throwable2;
        block30: {
            block29: {
                try {
                    int i22222;
                    NamespaceDifference diff;
                    boolean excludeStd;
                    block28: {
                        int i22222;
                        int iport2;
                        int iport1;
                        block27: {
                            int i22222;
                            block26: {
                                int i22222;
                                if (args.length < 12) {
                                    NamespaceDifference.printUsage();
                                    Object var14_1 = null;
                                    if (printStreams == null) return;
                                    int i22222 = 0;
                                    while (i22222 < printStreams.length) {
                                        printStreams[i22222].close();
                                        ++i22222;
                                    }
                                    return;
                                }
                                try {
                                    iport1 = Integer.parseInt(args[1]);
                                    break block26;
                                }
                                catch (NumberFormatException nfe) {
                                    NamespaceDifference.println("Illegal port number: " + args[1]);
                                    Object var14_2 = null;
                                    if (printStreams == null) return;
                                    i22222 = 0;
                                }
                                while (i22222 < printStreams.length) {
                                    printStreams[i22222].close();
                                    ++i22222;
                                }
                                return;
                            }
                            try {
                                iport2 = Integer.parseInt(args[6]);
                                break block27;
                            }
                            catch (NumberFormatException nfe) {
                                NamespaceDifference.println("Illegal port number: " + args[6]);
                                Object var14_3 = null;
                                if (printStreams == null) return;
                                i22222 = 0;
                            }
                            while (i22222 < printStreams.length) {
                                printStreams[i22222].close();
                                ++i22222;
                            }
                            return;
                        }
                        excludeStd = false;
                        if (args[11].equals("standard")) {
                            excludeStd = true;
                        }
                        try {
                            ClientFactory clientFactory = ClientFactory.newInstance();
                            CIMOMClient leftClient = clientFactory.createClient(ClientFactory.newSAPHttpURL(args[0], iport1), args[2], args[3]);
                            CIMOMClient rightClient = clientFactory.createClient(ClientFactory.newSAPHttpURL(args[5], iport2), args[7], args[8]);
                            ArrayList<PrintStream> streams = new ArrayList<PrintStream>();
                            streams.add(System.out);
                            int i3 = 12;
                            while (true) {
                                if (i3 >= args.length) {
                                    printStreams = streams.toArray(new PrintStream[streams.size()]);
                                    diff = new NamespaceDifference(args[4], leftClient, args[9], rightClient);
                                    break block28;
                                }
                                String arg = args[i3];
                                if (arg.startsWith("echoToFile")) {
                                    String name = arg.substring(1 + arg.indexOf(61));
                                    streams.add(new PrintStream(new FileOutputStream(name)));
                                } else {
                                    int timeout = 1000 * Integer.parseInt(args[12]);
                                    HttpRequestSender sender = (HttpRequestSender)leftClient.getRequestSender();
                                    sender.getConnection().setSocketReadTimeout(timeout);
                                    sender = (HttpRequestSender)rightClient.getRequestSender();
                                    sender.getConnection().setSocketReadTimeout(timeout);
                                }
                                ++i3;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            Object var14_4 = null;
                            if (printStreams == null) return;
                            i22222 = 0;
                        }
                        while (i22222 < printStreams.length) {
                            printStreams[i22222].close();
                            ++i22222;
                        }
                        return;
                    }
                    try {
                        NamespaceDifference.println("Evaluating qualifier differences ...");
                        diff.evaluateQualifierDifference();
                        diff.printQualifierResult(args[10]);
                        NamespaceDifference.println("Evaluating class differences ...");
                        diff.evaluateClassDifference(excludeStd);
                        diff.printClassResult(args[10]);
                        NamespaceDifference.println("Evaluating instance differences, please be patient ...");
                        diff.evaluateInstanceDifference(null, false, excludeStd);
                        diff.printInstanceResult(args[10]);
                        NamespaceDifference.println("Namespace differences evaluated successfully.");
                        break block29;
                    }
                    catch (CIMClientException cce) {
                        cce.printStackTrace();
                        Object var14_5 = null;
                        if (printStreams == null) return;
                        i22222 = 0;
                    }
                    while (i22222 < printStreams.length) {
                        printStreams[i22222].close();
                        ++i22222;
                    }
                    return;
                    catch (LcrException lce) {
                        lce.printStackTrace();
                        Object var14_6 = null;
                        if (printStreams == null) return;
                        i22222 = 0;
                    }
                    while (i22222 < printStreams.length) {
                        printStreams[i22222].close();
                        ++i22222;
                    }
                    return;
                }
                catch (Throwable throwable2) {
                    Object var14_8 = null;
                    if (printStreams == null) throw throwable2;
                    i22222 = 0;
                    break block30;
                }
            }
            Object var14_7 = null;
            if (printStreams == null) return;
            int i22222 = 0;
            while (i22222 < printStreams.length) {
                printStreams[i22222].close();
                ++i22222;
            }
            return;
        }
        while (true) {
            if (i22222 >= printStreams.length) {
                throw throwable2;
            }
            printStreams[i22222].close();
            ++i22222;
        }
    }

    private static void printUsage() {
        System.err.println("Usage:");
        System.err.println((class$com$sap$lcr$api$util$NamespaceDifference == null ? (class$com$sap$lcr$api$util$NamespaceDifference = NamespaceDifference.class$("com.sap.lcr.api.util.NamespaceDifference")) : class$com$sap$lcr$api$util$NamespaceDifference).getName() + " <host1> <port1> <user1> <pwd1> <namespace1>" + " <host2> <port2> <user2> <pwd2> <namespace2>" + " count/list all/standard [socketReadTimeoutSeconds] [echoToFile=path]");
    }

    private void printQualifierResult(String mode) {
        NamespaceDifference.println("Qualifier differences: " + this.leftMissingQualifiers.size() + " missing left, " + this.differingQualifiers.size() + " differing, " + this.rightMissingQualifiers.size() + " missing right.");
        if (mode.equals("list")) {
            int i = 0;
            while (i < this.leftMissingQualifiers.size()) {
                CIMQualifierDeclaration nextQ = (CIMQualifierDeclaration)this.leftMissingQualifiers.get(i);
                NamespaceDifference.println("LeftMissing: " + nextQ.getName());
                ++i;
            }
            int i2 = 0;
            while (i2 < this.differingQualifiers.size()) {
                QualifierDifference nextDiff = (QualifierDifference)this.differingQualifiers.get(i2);
                NamespaceDifference.println("Differing: " + nextDiff.qualifier1.getName());
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.rightMissingQualifiers.size()) {
                CIMQualifierDeclaration nextQ = (CIMQualifierDeclaration)this.rightMissingQualifiers.get(i3);
                NamespaceDifference.println("RightMissing: " + nextQ.getName());
                ++i3;
            }
        }
    }

    private void printClassResult(String mode) {
        NamespaceDifference.println("Class differences: " + this.leftMissingClasses.size() + " missing left, " + this.differingClasses.size() + " differing, " + this.rightMissingClasses.size() + " missing right.");
        if (mode.equals("list")) {
            int i = 0;
            while (i < this.leftMissingClasses.size()) {
                CIMClass nextC = (CIMClass)this.leftMissingClasses.get(i);
                NamespaceDifference.println("LeftMissing: " + nextC.getName());
                ++i;
            }
            int i2 = 0;
            while (i2 < this.differingClasses.size()) {
                ClassDifference nextDiff = (ClassDifference)this.differingClasses.get(i2);
                NamespaceDifference.println("Differing: " + nextDiff.class1.getName());
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.rightMissingClasses.size()) {
                CIMClass nextC = (CIMClass)this.rightMissingClasses.get(i3);
                NamespaceDifference.println("RightMissing: " + nextC.getName());
                ++i3;
            }
        }
    }

    private void printInstanceResult(String mode) {
        NamespaceDifference.println("Number of common classes = " + this.bothClassNames.size());
        NamespaceDifference.print("Instance differences in common classes: " + this.leftMissingInstances.size() + " missing left, " + this.differingInstances.size() + " differing, ");
        if (this.ownerDifferingInstances.size() > 0) {
            NamespaceDifference.print(this.ownerDifferingInstances.size() + " differing owners, ");
        }
        NamespaceDifference.println(this.rightMissingInstances.size() + " missing right.");
        if (mode.equals("list")) {
            int i = 0;
            while (i < this.leftMissingInstances.size()) {
                CIMValueNamedInstance nextI = (CIMValueNamedInstance)this.leftMissingInstances.get(i);
                NamespaceDifference.println("LeftMissing: " + nextI.getInstancename().toDisplayString());
                ++i;
            }
            int i2 = 0;
            while (i2 < this.differingInstances.size()) {
                InstanceDifference nextDiff = (InstanceDifference)this.differingInstances.get(i2);
                NamespaceDifference.println("Differing: " + nextDiff.instance1.getInstancename().toDisplayString());
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.ownerDifferingInstances.size()) {
                InstanceDifference nextDiff = (InstanceDifference)this.ownerDifferingInstances.get(i3);
                NamespaceDifference.println("Owner differing: " + nextDiff.instance1.getInstancename().toDisplayString());
                ++i3;
            }
            int i4 = 0;
            while (i4 < this.rightMissingInstances.size()) {
                CIMValueNamedInstance nextI = (CIMValueNamedInstance)this.rightMissingInstances.get(i4);
                NamespaceDifference.println("RightMissing: " + nextI.getInstancename().toDisplayString());
                ++i4;
            }
        }
    }

    private static void println(String text) {
        int i = 0;
        while (i < printStreams.length) {
            printStreams[i].println(text);
            ++i;
        }
    }

    private static void print(String text) {
        int i = 0;
        while (i < printStreams.length) {
            printStreams[i].print(text);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class QualifierDifference {
        public CIMQualifierDeclaration qualifier1;
        public CIMQualifierDeclaration qualifier2;

        public QualifierDifference(CIMQualifierDeclaration q1, CIMQualifierDeclaration q2) {
            this.qualifier1 = q1;
            this.qualifier2 = q2;
        }
    }

    public static class InstanceDifference {
        public CIMValueNamedInstance instance1;
        public CIMValueNamedInstance instance2;

        public InstanceDifference(CIMValueNamedInstance i1, CIMValueNamedInstance i2) {
            this.instance1 = i1;
            this.instance2 = i2;
        }
    }

    public static class ClassDifference {
        public CIMClass class1;
        public CIMClass class2;

        public ClassDifference(CIMClass c1, CIMClass c2) {
            this.class1 = c1;
            this.class2 = c2;
        }
    }
}

