/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

import com.sap.lcr.api.cimclient.WrapperException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class GUID
implements Serializable {
    static final long serialVersionUID = 42L;
    private long replow;
    private long rephigh;
    private static long nodeaddress;
    private static long ltime;
    private static short lcount;
    private static Random rand;
    public static final int NUMBYTES = 16;
    public static final int VERSION_NIL = 0;
    public static final int VERSION_TIME = 1;
    public static final int VERSION_NAME = 3;
    public static final int VERSION_RANDOM = 4;
    private static final char[] hexDigits;

    public GUID() {
        this.genguidbytime();
    }

    public GUID(String value) {
        this.genguidbyname(value);
    }

    public GUID(int version) throws GUIDVersionException {
        switch (version) {
            case 0: {
                break;
            }
            case 1: {
                this.genguidbytime();
                break;
            }
            case 4: {
                this.genguidbyrandom();
                break;
            }
            default: {
                throw new GUIDVersionException();
            }
        }
    }

    public GUID(byte[] g) throws GUIDFormatException {
        if (g.length < 16) {
            throw new GUIDFormatException();
        }
        try {
            this.replow = (long)(g[15] & 0xFF | (g[14] & 0xFF) << 8 | (g[13] & 0xFF) << 16 | (g[12] & 0xFF) << 24) & 0xFFFFFFFFL | (long)(g[11] & 0xFF | (g[10] & 0xFF) << 8 | (g[9] & 0xFF) << 16 | (g[8] & 0xFF) << 24) << 32;
            this.rephigh = (long)(g[7] & 0xFF | (g[6] & 0xFF) << 8 | (g[5] & 0xFF) << 16 | (g[4] & 0xFF) << 24) & 0xFFFFFFFFL | (long)(g[3] & 0xFF | (g[2] & 0xFF) << 8 | (g[1] & 0xFF) << 16 | (g[0] & 0xFF) << 24) << 32;
        }
        catch (Exception e) {
            throw new GUIDFormatException(e);
        }
    }

    GUID(GUID originalGUID, byte[] variantDescriptor) {
        int len = variantDescriptor.length;
        byte[] buffer = new byte[16 + len];
        System.arraycopy(originalGUID.toBytes(), 0, buffer, 0, 16);
        System.arraycopy(variantDescriptor, 0, buffer, 16, len);
        this.genguidbyname(buffer);
    }

    public String toString() {
        char[] buf = new char[36];
        int n1 = (int)this.replow;
        buf[35] = hexDigits[n1 & 0xF];
        buf[34] = hexDigits[n1 >>> 4 & 0xF];
        buf[33] = hexDigits[n1 >>> 8 & 0xF];
        buf[32] = hexDigits[n1 >>> 12 & 0xF];
        buf[31] = hexDigits[n1 >>> 16 & 0xF];
        buf[30] = hexDigits[n1 >>> 20 & 0xF];
        buf[29] = hexDigits[n1 >>> 24 & 0xF];
        buf[28] = hexDigits[n1 >>> 28 & 0xF];
        int n2 = (int)(this.replow >>> 32);
        buf[27] = hexDigits[n2 & 0xF];
        buf[26] = hexDigits[n2 >>> 4 & 0xF];
        buf[25] = hexDigits[n2 >>> 8 & 0xF];
        buf[24] = hexDigits[n2 >>> 12 & 0xF];
        buf[23] = 45;
        buf[22] = hexDigits[n2 >>> 16 & 0xF];
        buf[21] = hexDigits[n2 >>> 20 & 0xF];
        buf[20] = hexDigits[n2 >>> 24 & 0xF];
        buf[19] = hexDigits[n2 >>> 28 & 0xF];
        buf[18] = 45;
        int n3 = (int)this.rephigh;
        buf[17] = hexDigits[n3 & 0xF];
        buf[16] = hexDigits[n3 >>> 4 & 0xF];
        buf[15] = hexDigits[n3 >>> 8 & 0xF];
        buf[14] = hexDigits[n3 >>> 12 & 0xF];
        buf[13] = 45;
        buf[12] = hexDigits[n3 >>> 16 & 0xF];
        buf[11] = hexDigits[n3 >>> 20 & 0xF];
        buf[10] = hexDigits[n3 >>> 24 & 0xF];
        buf[9] = hexDigits[n3 >>> 28 & 0xF];
        buf[8] = 45;
        int n4 = (int)(this.rephigh >>> 32);
        buf[7] = hexDigits[n4 & 0xF];
        buf[6] = hexDigits[n4 >>> 4 & 0xF];
        buf[5] = hexDigits[n4 >>> 8 & 0xF];
        buf[4] = hexDigits[n4 >>> 12 & 0xF];
        buf[3] = hexDigits[n4 >>> 16 & 0xF];
        buf[2] = hexDigits[n4 >>> 20 & 0xF];
        buf[1] = hexDigits[n4 >>> 24 & 0xF];
        buf[0] = hexDigits[n4 >>> 28 & 0xF];
        return new String(buf);
    }

    public String toHexString() {
        char[] buf = new char[32];
        int n1 = (int)this.replow;
        buf[31] = hexDigits[n1 & 0xF];
        buf[30] = hexDigits[n1 >>> 4 & 0xF];
        buf[29] = hexDigits[n1 >>> 8 & 0xF];
        buf[28] = hexDigits[n1 >>> 12 & 0xF];
        buf[27] = hexDigits[n1 >>> 16 & 0xF];
        buf[26] = hexDigits[n1 >>> 20 & 0xF];
        buf[25] = hexDigits[n1 >>> 24 & 0xF];
        buf[24] = hexDigits[n1 >>> 28 & 0xF];
        int n2 = (int)(this.replow >>> 32);
        buf[23] = hexDigits[n2 & 0xF];
        buf[22] = hexDigits[n2 >>> 4 & 0xF];
        buf[21] = hexDigits[n2 >>> 8 & 0xF];
        buf[20] = hexDigits[n2 >>> 12 & 0xF];
        buf[19] = hexDigits[n2 >>> 16 & 0xF];
        buf[18] = hexDigits[n2 >>> 20 & 0xF];
        buf[17] = hexDigits[n2 >>> 24 & 0xF];
        buf[16] = hexDigits[n2 >>> 28 & 0xF];
        int n3 = (int)this.rephigh;
        buf[15] = hexDigits[n3 & 0xF];
        buf[14] = hexDigits[n3 >>> 4 & 0xF];
        buf[13] = hexDigits[n3 >>> 8 & 0xF];
        buf[12] = hexDigits[n3 >>> 12 & 0xF];
        buf[11] = hexDigits[n3 >>> 16 & 0xF];
        buf[10] = hexDigits[n3 >>> 20 & 0xF];
        buf[9] = hexDigits[n3 >>> 24 & 0xF];
        buf[8] = hexDigits[n3 >>> 28 & 0xF];
        int n4 = (int)(this.rephigh >>> 32);
        buf[7] = hexDigits[n4 & 0xF];
        buf[6] = hexDigits[n4 >>> 4 & 0xF];
        buf[5] = hexDigits[n4 >>> 8 & 0xF];
        buf[4] = hexDigits[n4 >>> 12 & 0xF];
        buf[3] = hexDigits[n4 >>> 16 & 0xF];
        buf[2] = hexDigits[n4 >>> 20 & 0xF];
        buf[1] = hexDigits[n4 >>> 24 & 0xF];
        buf[0] = hexDigits[n4 >>> 28 & 0xF];
        return new String(buf);
    }

    public byte[] toBytes() {
        byte[] b = new byte[16];
        int n1 = (int)this.replow;
        b[15] = (byte)n1;
        b[14] = (byte)(n1 >>> 8);
        b[13] = (byte)(n1 >>> 16);
        b[12] = (byte)(n1 >>> 24);
        int n2 = (int)(this.replow >>> 32);
        b[11] = (byte)n2;
        b[10] = (byte)(n2 >>> 8);
        b[9] = (byte)(n2 >>> 16);
        b[8] = (byte)(n2 >>> 24);
        int n3 = (int)this.rephigh;
        b[7] = (byte)n3;
        b[6] = (byte)(n3 >>> 8);
        b[5] = (byte)(n3 >>> 16);
        b[4] = (byte)(n3 >>> 24);
        int n4 = (int)(this.rephigh >>> 32);
        b[3] = (byte)n4;
        b[2] = (byte)(n4 >>> 8);
        b[1] = (byte)(n4 >>> 16);
        b[0] = (byte)(n4 >>> 24);
        return b;
    }

    public static GUID fromBytes(byte[] b) throws GUIDFormatException {
        if (b.length != 16) {
            throw new GUIDFormatException();
        }
        try {
            return new GUID(b);
        }
        catch (Exception e) {
            throw new GUIDFormatException(e);
        }
    }

    public boolean equals(GUID guid) {
        if (guid == null) {
            return false;
        }
        if (this == guid) {
            return true;
        }
        return this.rephigh == guid.rephigh && this.replow == guid.replow;
    }

    public boolean equals(Object obj) {
        return obj instanceof GUID && this.equals((GUID)obj);
    }

    public int hashCode() {
        return (int)(this.rephigh ^ this.rephigh >> 32 ^ this.replow ^ this.replow >> 32);
    }

    public int getVersion() {
        return (int)this.rephigh >>> 12 & 0xF;
    }

    public int getVariant() {
        return 2;
    }

    public boolean isNil() {
        return this.rephigh == 0L && this.replow == 0L;
    }

    private void genguidbytime() {
        long ts = this.gettimestamp();
        this.rephigh = 0x1000L | (ts & 0xFFFFFFFFL) << 32 | (ts & 0xFFFF00000000L) >> 16 | (ts & 0xFFF000000000000L) >> 48;
        this.replow = Long.MIN_VALUE | (long)rand.nextInt(20479) << 48 | nodeaddress;
    }

    private void genguidbyname(String value) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] digest = md5.digest(value.getBytes("UTF-8"));
            this.rephigh = (long)((0xFF & digest[0]) << 24 | (0xFF & digest[1]) << 16 | (0xFF & digest[2]) << 8 | 0xFF & digest[3]) << 32 | (long)((0xFF & digest[4]) << 24 | (0xFF & digest[5]) << 16 | (0xFF & digest[6]) << 8 | 0xFF & digest[7]) & 0xFFFFFFFFL;
            this.replow = (long)((0xFF & digest[8]) << 24 | (0xFF & digest[9]) << 16 | (0xFF & digest[10]) << 8 | 0xFF & digest[11]) << 32 | (long)((0xFF & digest[12]) << 24 | (0xFF & digest[13]) << 16 | (0xFF & digest[14]) << 8 | 0xFF & digest[15]) & 0xFFFFFFFFL;
            this.replow &= 0x3FFFFFFFFFFFFFFFL;
            this.replow |= Long.MIN_VALUE;
            this.rephigh &= 0xFFFFFFFFFFFF0FFFL;
            this.rephigh |= 0x3000L;
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void genguidbyname(byte[] value) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] digest = md5.digest(value);
            this.rephigh |= (long)(0xFF & digest[0]) << 56 | (long)(0xFF & digest[1]) << 48 | (long)(0xFF & digest[2]) << 40 | (long)(0xFF & digest[3]) << 32 | (long)(0xFF & digest[4]) << 24 | (long)(0xFF & digest[5]) << 16 | (long)(0xFF & digest[6]) << 8 | (long)(0xFF & digest[7]);
            this.replow |= (long)(0xFF & digest[8]) << 56 | (long)(0xFF & digest[9]) << 48 | (long)(0xFF & digest[10]) << 40 | (long)(0xFF & digest[11]) << 32 | (long)(0xFF & digest[12]) << 24 | (long)(0xFF & digest[13]) << 16 | (long)(0xFF & digest[14]) << 8 | (long)(0xFF & digest[15]);
            this.replow &= 0x3FFFFFFFFFFFFFFFL;
            this.replow |= Long.MIN_VALUE;
            this.rephigh &= 0xFFFFFFFFFFFF0FFFL;
            this.rephigh |= 0x3000L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    private void genguidbyrandom() {
        this.rephigh = 0x4000L | rand.nextLong() & 0xFFFFFFFFFFFF0FFFL;
        this.replow = rand.nextLong() & 0x3FFFFFFFFFFFFFFFL | 0x800000000000L;
    }

    private static long getnodeaddress() {
        try {
            String nodestr = System.getProperty("ieee802.address");
            if (nodestr != null && nodestr.length() == 17) {
                return Long.parseLong(nodestr.substring(0, 2), 16) << 40 | Long.parseLong(nodestr.substring(3, 5), 16) << 32 | Long.parseLong(nodestr.substring(6, 8), 16) << 24 | Long.parseLong(nodestr.substring(9, 11), 16) << 16 | Long.parseLong(nodestr.substring(12, 14), 16) << 8 | Long.parseLong(nodestr.substring(15, 17), 16);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            byte[] ipaddr = InetAddress.getLocalHost().getAddress();
            return 0xC00000000000L | (long)rand.nextInt(16383) << 32 | (long)(0xFF & ipaddr[0]) << 24 | (long)(0xFF & ipaddr[1]) << 16 | (long)(0xFF & ipaddr[2]) << 8 | (long)(0xFF & ipaddr[3]);
        }
        catch (Exception exception) {
            return 0x800000000000L | rand.nextLong() & 0x3FFFFFFFFFFFL;
        }
    }

    private long gettimestamp() {
        long t = System.currentTimeMillis();
        if (t != ltime) {
            ltime = t;
            lcount = (short)-1;
        }
        lcount = (short)(lcount + 1);
        return (t + 12219292800000L) * 10000L + (long)lcount & 0xFFFFFFFFFFFFFFFL;
    }

    public long getTimestamp() {
        if (this.getVersion() != 1) {
            return 0L;
        }
        long t = this.rephigh >> 32 & 0xFFFFFFFFL | this.rephigh << 16 & 0xFFFF00000000L | this.rephigh << 48 & 0xFFF000000000000L;
        return t / 10000L - 12219292800000L;
    }

    public int getClockSeq() {
        return (int)((this.replow & 0x3FFF000000000000L) >> 48);
    }

    public static GUID parseGUID(String guid) throws GUIDFormatException {
        if (guid.length() != 36) {
            throw new GUIDFormatException();
        }
        try {
            GUID g = new GUID(0);
            g.rephigh = Long.parseLong(guid.substring(0, 8), 16) << 32 | Long.parseLong(guid.substring(9, 13), 16) << 16 | Long.parseLong(guid.substring(14, 18), 16);
            g.replow = Long.parseLong(guid.substring(19, 23), 16) << 48 | Long.parseLong(guid.substring(24, 36), 16);
            return g;
        }
        catch (Exception e) {
            throw new GUIDFormatException(e);
        }
    }

    public static GUID parseHexGUID(String guid) throws GUIDFormatException {
        if (guid.length() != 32) {
            throw new GUIDFormatException();
        }
        try {
            GUID g = new GUID(0);
            g.rephigh = Long.parseLong(guid.substring(0, 8), 16) << 32 | Long.parseLong(guid.substring(8, 16), 16);
            g.replow = Long.parseLong(guid.substring(16, 24), 16) << 32 | Long.parseLong(guid.substring(24, 32), 16);
            return g;
        }
        catch (Exception e) {
            throw new GUIDFormatException(e);
        }
    }

    public int compareTo(Object otherGUID) {
        if (otherGUID == null) {
            throw new IllegalArgumentException("Can not compare with NULL");
        }
        if (!(otherGUID instanceof GUID) && !(otherGUID instanceof byte[])) {
            throw new IllegalArgumentException("Can not compare with instances of: " + otherGUID.getClass().getName());
        }
        GUID other = null;
        if (otherGUID instanceof byte[]) {
            try {
                other = new GUID((byte[])otherGUID);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Can not compare with malformed byte[]: " + ex.getMessage());
            }
        } else {
            other = (GUID)otherGUID;
        }
        if (this.rephigh < other.rephigh) {
            return -1;
        }
        if (this.rephigh > other.rephigh) {
            return 1;
        }
        if (this.replow < other.replow) {
            return -1;
        }
        if (this.replow > other.replow) {
            return 1;
        }
        return 0;
    }

    static {
        ltime = System.currentTimeMillis();
        rand = new Random(System.currentTimeMillis() ^ (long)new Object().hashCode());
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        nodeaddress = GUID.getnodeaddress();
    }

    public static class GUIDVersionException
    extends Exception {
        static final long serialVersionUID = 42L;
    }

    public static class GUIDFormatException
    extends WrapperException {
        static final long serialVersionUID = 42L;

        public GUIDFormatException() {
        }

        GUIDFormatException(Exception cause) {
            super(null, cause);
        }
    }
}

