/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.saputil;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cim.CIMPropertyArray;
import com.sap.lcr.api.cim.CIMPropertyReference;
import com.sap.lcr.api.cim.CIMQualifier;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMClientHandle;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.HttpRequestSender;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.LcrUtility;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.URL;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

public class GetPropertyComments
extends LcrUtility {
    private static final int connectionArgCount = 5;
    private static Logger logger = Logger.getLogger((class$com$sap$lcr$api$saputil$GetPropertyComments == null ? (class$com$sap$lcr$api$saputil$GetPropertyComments = GetPropertyComments.class$("com.sap.lcr.api.saputil.GetPropertyComments")) : class$com$sap$lcr$api$saputil$GetPropertyComments).getName());
    static /* synthetic */ Class class$com$sap$lcr$api$saputil$GetPropertyComments;

    public GetPropertyComments(CIMClientHandle aClientHandle) throws MalformedURLException {
        super(aClientHandle);
    }

    public void keepImportsUsed(Iterator anIter, ArrayList anArrayList, TreeSet aTreeSet) {
    }

    public static void main(String[] args) {
        CIMTraceUtil.traceLevel = 0;
        GetPropertyComments util = null;
        int port = 80;
        String host = null;
        String user = null;
        String password = null;
        String namespace = null;
        CIMClient client = null;
        CIMClient myClient = null;
        Connection connection = null;
        if (args.length != 6) {
            System.out.println("Usage: GetPropertyComments <host> <port> <user> <password> <classname>");
            System.exit(1);
        }
        host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            logger.debug("NumberFormatException encountered", e);
            System.out.println("Bad port (not a number): " + args[1]);
            System.exit(1);
        }
        user = args[2];
        password = args[3];
        System.err.println("User    : <" + user + ">");
        System.err.println("Password: <" + password + ">");
        if (user.equalsIgnoreCase("EMPTY")) {
            user = "";
        }
        if (password.equalsIgnoreCase("EMPTY")) {
            password = "";
        }
        System.err.println("User    : <" + user + ">");
        System.err.println("Password: <" + password + ">");
        namespace = args[4];
        try {
            URL url = ClientFactory.newSAPHttpURL(host, port);
            myClient = new CIMClient(ClientFactory.newInstance().createClient(url, user, password));
            myClient.setLocalNamespacePath(namespace);
            HttpRequestSender sender = (HttpRequestSender)myClient.getRequestSender();
            connection = sender.getConnection();
            connection.setSocketReadTimeout(300000);
            client = myClient;
        }
        catch (Exception e) {
            logger.debug("Failed to create client", e);
            System.out.println("Exception while creating client instance");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            util = new GetPropertyComments(client);
        }
        catch (MalformedURLException e) {
            logger.debug("Malformed URL", e);
            System.out.println("Bad URL");
            System.exit(1);
        }
        String[] propArgs = new String[]{args[5]};
        try {
            util.getPropertyComments(propArgs);
        }
        catch (Exception e) {
            logger.debug("Exception from getPropertyComments call", e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public String getPropertyComments(String[] privArgs) throws CIMClientException, ItemConstructionExcp, LcrException {
        CIMPropertyReference cimPropertyReference;
        CIMPropertyArray cimPropertyArray;
        CIMQualifier cimQualifier;
        String localString;
        String classOrigin;
        String propname;
        CIMProperty cimProperty;
        String result = null;
        if (privArgs.length != 1) {
            System.out.println("Wrong argument count: getClassComment(classname)");
            System.exit(1);
        }
        String thisClassname = privArgs[0];
        CIMClass cimClass = this.client.getCIMClass(thisClassname, false, true, true, null);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iter = cimClass.getPropertyIterator();
        while (iter.hasNext()) {
            cimProperty = (CIMProperty)iter.next();
            arrayList.add(cimProperty.getName());
        }
        TreeSet treeSet = new TreeSet(arrayList);
        iter = treeSet.iterator();
        while (iter.hasNext()) {
            propname = (String)iter.next();
            cimProperty = cimClass.getPropertyByName(propname);
            classOrigin = cimProperty.getClassOrigin();
            localString = classOrigin.equalsIgnoreCase(thisClassname) ? "local" : classOrigin;
            cimQualifier = cimProperty.getQualifierByName("Description");
            result = cimQualifier != null ? cimQualifier.getValue() : "---  No description available ---";
            System.out.println("PROPERTYSIMPLE " + propname + " " + localString + "\n" + result);
        }
        arrayList = new ArrayList();
        iter = cimClass.getPropertyArrayIterator();
        while (iter.hasNext()) {
            cimPropertyArray = (CIMPropertyArray)iter.next();
            arrayList.add(cimPropertyArray.getName());
        }
        treeSet = new TreeSet(arrayList);
        iter = treeSet.iterator();
        while (iter.hasNext()) {
            propname = (String)iter.next();
            cimPropertyArray = cimClass.getPropertyArrayByName(propname);
            classOrigin = cimPropertyArray.getClassOrigin();
            localString = classOrigin.equalsIgnoreCase(thisClassname) ? "local" : classOrigin;
            cimQualifier = cimPropertyArray.getQualifierByName("Description");
            result = cimQualifier != null ? cimQualifier.getValue() : "---  No description available ---";
            System.out.println("PROPERTYARRAY " + propname + " " + localString + "\n" + result);
        }
        arrayList = new ArrayList();
        iter = cimClass.getPropertyReferenceIterator();
        while (iter.hasNext()) {
            cimPropertyReference = (CIMPropertyReference)iter.next();
            arrayList.add(cimPropertyReference.getName());
        }
        treeSet = new TreeSet(arrayList);
        iter = treeSet.iterator();
        while (iter.hasNext()) {
            propname = (String)iter.next();
            cimPropertyReference = cimClass.getPropertyReferenceByName(propname);
            classOrigin = cimPropertyReference.getClassOrigin();
            localString = classOrigin.equalsIgnoreCase(thisClassname) ? "local" : classOrigin;
            cimQualifier = cimPropertyReference.getQualifierByName("Description");
            result = cimQualifier != null ? cimQualifier.getValue() : "---  No description available ---";
            System.out.println("PROPERTYREFERENCE " + propname + " " + localString + "\n" + result);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

