/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import com.sap.lcr.api.log.Level;
import com.sap.lcr.api.log.Logger;
import java.util.Date;

public class LogRecord {
    private static long count = 0L;
    private String loggerName;
    private Level level;
    private String message;
    private long number;
    private String thread;
    private Date date;
    private Throwable thrown;
    private String user;
    private Logger logger = null;

    public LogRecord(String loggerName, Level level, String message) {
        this.loggerName = loggerName;
        this.level = level;
        this.message = message;
        this.number = count++;
        this.thread = Thread.currentThread().getName();
        this.date = new Date();
        this.thrown = null;
        this.user = null;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.loggerName);
        }
        return this.logger;
    }

    public long getSequenceNumber() {
        return this.number;
    }

    public String getThreadName() {
        return this.thread;
    }

    public Date getDate() {
        return this.date;
    }

    public long getMillis() {
        return this.date.getTime();
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public String getUser() {
        return this.user;
    }

    void setThrown(Throwable t) {
        this.thrown = t;
    }

    void setUser(String user) {
        this.user = user;
    }
}

