/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cim.CIMCim;
import com.sap.lcr.api.cim.CIMMessage;
import com.sap.lcr.api.cim.CIMMultiReq;
import com.sap.lcr.api.cim.CIMSimpleReq;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMHttp;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.ByteArrayEntity;
import com.tssap.dtr.client.lib.protocol.requests.RequestBase;

class WbemPostRequest
extends RequestBase {
    private static final String ACCEPT_XML_TYPES = "application/xml, text/xml";
    private static final String ACCEPT_WITH_COMPRESSION = "identity, deflate";
    private final boolean useCompression;
    final int simpleRequestCount;

    public WbemPostRequest(CIMCim cimRequest, boolean useMPost, boolean useCompression, String path) throws CIMClientException {
        super(useMPost ? "M-POST" : "POST", path);
        byte[] bytes;
        this.useCompression = useCompression;
        CIMMessage message = cimRequest.getMessage();
        if (message == null) {
            throw new CIMClientException("Request does not contain a MESSAGE");
        }
        this.setHeader("CIMProtocolVersion", "1.0");
        this.setHeader("CIMOperation", "MethodCall");
        CIMSimpleReq simpleReq = message.getSimpleReq();
        if (simpleReq != null) {
            this.simpleRequestCount = 1;
            try {
                this.setHeader("CIMMethod", CIMHttp.escapeUnicodeHeader(simpleReq.getMethodName()));
                this.setHeader("CIMObject", CIMHttp.escapeUnicodeHeader(simpleReq.getObjectPath()));
            }
            catch (NullPointerException npe) {
                throw new CIMClientException("Invalid SIMPLEREQ");
            }
        } else {
            CIMMultiReq multiReq = message.getMultiReq();
            if (multiReq != null) {
                this.setHeader("CIMBatch", "");
                this.simpleRequestCount = multiReq.getSimpleReqs().size();
            } else {
                throw new CIMClientException("Invalid request (no SIMPLEREQ or MULTIREQ)");
            }
        }
        this.setHeader("Accept", ACCEPT_XML_TYPES);
        this.setHeader("Accept-Charset", "UTF-8");
        if (useCompression) {
            this.setHeader("Accept-Encoding", ACCEPT_WITH_COMPRESSION);
            this.setHeader("Content-Encoding", "deflate");
            bytes = cimRequest.toCompressedXml();
        } else {
            this.setHeader("Accept-Encoding", "identity");
            this.setHeader("Content-Encoding", "identity");
            bytes = cimRequest.toUTF8Xml(null);
        }
        this.setRequestEntity((IRequestEntity)new ByteArrayEntity(bytes, "application/xml; charset=utf-8"));
    }
}

