/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cim.CIMCim;
import com.sap.lcr.api.cim.CIMConstants;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.Xml2Cim;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMHttp;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.HttpDestinationStore;
import com.sap.lcr.api.cimclient.IRequestSender;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimclient.SecureStoreAccess;
import com.sap.lcr.api.cimclient.UnauthorizedUserException;
import com.sap.lcr.api.cimclient.WbemPostRequest;
import com.sap.lcr.api.log.Level;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Util;
import com.sap.lcr.api.util.Version;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.requests.RequestBase;
import com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.SSO2Authenticator;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Properties;

public class HttpRequestSender
implements IRequestSender {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cimclient$HttpRequestSender == null ? (class$com$sap$lcr$api$cimclient$HttpRequestSender = HttpRequestSender.class$("com.sap.lcr.api.cimclient.HttpRequestSender")) : class$com$sap$lcr$api$cimclient$HttpRequestSender).getName());
    private static final String DEFAULT_PROTOCOL = "http";
    static final String DEFAULT_SERVLET_PATH = "/sld/cimom";
    public static final int DEFAULT_READ_TIMEOUT_MS = 90000;
    private static final int COMPRESSION_DISABLED = -2;
    private static final int COMPRESSION_NO = -1;
    private static final int COMPRESSION_YES = 1;
    private static final int COMPRESSION_UNKNOWN = 0;
    private static final int SERVER_VERSION_UNKNOWN = -1;
    private static final int SERVER_VERSION_PRE30 = 0;
    private static final int SERVER_VERSION_CURRENT = 1;
    private Xml2Cim xml2cim = new Xml2Cim();
    private Connection connection;
    private String servletPath;
    private int compressionSupport = 0;
    private int serverVersion = -1;
    static /* synthetic */ Class class$com$sap$lcr$api$cimclient$HttpRequestSender;

    private static Connection buildConnection(URL url, String user, String pwd) throws MalformedURLException {
        SessionContext sessionContext = new SessionContext(user, pwd);
        sessionContext.setAuthenticator((IAuthenticator)new SSO2Authenticator((ISessionContext)sessionContext, (IAuthenticator)new BasicAuthenticator((ISessionContext)sessionContext)));
        Connection connection = new Connection(url, (ISessionContext)sessionContext);
        connection.setSocketReadTimeout(90000);
        return connection;
    }

    HttpRequestSender(Connection connection, boolean setDefaultReadTimeout) {
        this.connection = connection;
        if (setDefaultReadTimeout) {
            connection.setSocketReadTimeout(90000);
        }
    }

    public HttpRequestSender() throws IOException {
        this(null);
    }

    public HttpRequestSender(String configurationName) throws IOException {
        HttpDestinationStore dests;
        boolean fromSecStore = true;
        try {
            dests = SecureStoreAccess.loadConfigFromSecureStore();
        }
        catch (LcrException lce) {
            dests = null;
        }
        if (dests == null) {
            Properties sldconnectProperties = new Properties();
            sldconnectProperties.load(new BufferedInputStream(new FileInputStream("sldconnect.properties")));
            dests = new HttpDestinationStore(sldconnectProperties);
            fromSecStore = false;
        }
        String host = dests.getHost(configurationName);
        int iport = dests.getPort(configurationName);
        String user = dests.getUser(configurationName);
        String pwd = dests.getPwd(configurationName);
        if (host == null || iport == 0 || user == null || pwd == null) {
            String origin = fromSecStore ? " in secure store" : " in file system";
            throw new IOException("Invalid sldconnect.properties" + origin);
        }
        this.connection = HttpRequestSender.buildConnection(new URL(DEFAULT_PROTOCOL, host, iport, DEFAULT_SERVLET_PATH), user, pwd);
    }

    public HttpRequestSender(URL cimomUrl, String user, String password) throws IOException {
        this.connection = HttpRequestSender.buildConnection(HttpRequestSender.checkURL(cimomUrl), user, password);
    }

    public HttpRequestSender(java.net.URL cimomUrl, String user, String password) throws IOException {
        this(CIMHttp.java2DtrHttpURL(cimomUrl), user, password);
    }

    public HttpRequestSender(String host, int port, String user, String password) throws IOException {
        this(new URL(DEFAULT_PROTOCOL, host, port, DEFAULT_SERVLET_PATH), user, password);
    }

    public HttpRequestSender(URL cimomUrl, SessionContext sessionContext) throws IOException {
        this.connection = new Connection(HttpRequestSender.checkURL(cimomUrl), (ISessionContext)sessionContext);
        this.connection.setSocketReadTimeout(90000);
    }

    public HttpRequestSender(String host, int port, SessionContext sessionContext) throws IOException {
        this(new URL(DEFAULT_PROTOCOL, host, port, DEFAULT_SERVLET_PATH), sessionContext);
    }

    public Object clone() {
        try {
            HttpRequestSender clone = (HttpRequestSender)super.clone();
            clone.xml2cim = new Xml2Cim();
            clone.connection = new Connection((IConnectionTemplate)this.connection);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    static URL checkURL(URL cimomUrl) {
        String pathPart = cimomUrl.getPath();
        if (pathPart == null || pathPart.length() == 0 || pathPart.equals("/")) {
            return new URL(cimomUrl.getProtocol(), cimomUrl.getHost(), cimomUrl.getPort(), DEFAULT_SERVLET_PATH);
        }
        return cimomUrl;
    }

    public boolean isUseCompression() {
        return this.compressionSupport == 1 || this.compressionSupport == 0;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getHost() {
        return this.connection.getHost();
    }

    public int getPort() {
        return this.connection.getPort();
    }

    public void setUseCompression(boolean compression) {
        if (this.compressionSupport == -1) {
            return;
        }
        if (compression) {
            if (this.compressionSupport == -2) {
                this.compressionSupport = 0;
            }
        } else {
            this.compressionSupport = -2;
        }
    }

    private String getServletPath() {
        if (this.servletPath == null) {
            this.servletPath = this.connection.getBasePath();
            if (this.servletPath.endsWith("/")) {
                this.servletPath = this.servletPath.substring(0, this.servletPath.length() - 1);
            }
        }
        return this.servletPath;
    }

    private void setCommonHeaders(IRequest request) {
        request.setHeader("SAP-CIM-Client", "3.3");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CIMCim processResponse(IResponse response, CIMCim cimRequest) throws CIMClientException, LcrException, IOException {
        Object vServer;
        String hdrCimOp;
        int responseCode = response.getStatus();
        if (CIMTraceUtil.traceLevel >= 3) {
            logger.debug("HTTP response code: " + responseCode);
        }
        switch (responseCode) {
            case 200: 
            case 207: {
                break;
            }
            case 401: {
                throw new UnauthorizedUserException("User credentials are invalid or user is denied access");
            }
            case 415: {
                if (this.compressionSupport != 0) throw new CIMClientException("Unsupported media type");
                this.compressionSupport = -1;
                if (CIMTraceUtil.traceLevel < 3) return this.send(cimRequest);
                logger.debug("turning off compression");
                return this.send(cimRequest);
            }
            default: {
                throw this.newClientException(response);
            }
        }
        if (CIMTraceUtil.traceLevel >= 6 && Util.isLogging(logger, Level.FINEST)) {
            StringBuffer buf = new StringBuffer(1024);
            buf.append("response headers:").append(CIMConstants.NEWLINE);
            Iterator iter = response.getHeaderNames();
            while (true) {
                if (!iter.hasNext()) {
                    logger.finest(buf.toString());
                    break;
                }
                String key = (String)iter.next();
                String value = response.getHeaderValue(key);
                buf.append(key).append(": ").append(value).append(CIMConstants.NEWLINE);
            }
        }
        if (!"MethodResponse".equals(hdrCimOp = response.getHeaderValue("CIMOperation"))) {
            String user = null;
            ISessionContext sessionContext = this.connection.getSessionContext();
            if (sessionContext != null) {
                user = sessionContext.getUser();
            }
            if (user != null) {
                throw new CIMClientException(MessageFormat.format("Received response is not a CIM Operation Response! Check \"{0}\" is the correct URL for the SLD CIM Object Manager and that user \"{1}\" has access to the SLD via {2}.", this.connection.getUrl(this.getServletPath()), user, this.connection.getProtocol()));
            }
            throw new CIMClientException(MessageFormat.format("Received response is not a CIM Operation Response. Check {0} is the correct URL for the SLD CIM server.", this.connection.getUrl(this.getServletPath())));
        }
        if (this.compressionSupport == 0) {
            this.compressionSupport = 1;
        }
        if (this.serverVersion == -1) {
            Version v30 = new Version(3, 0);
            String serverVersionHeader = response.getHeaderValue("SAP-CIM-Server");
            vServer = new Version(serverVersionHeader, Version.ZERO);
            this.serverVersion = ((Version)vServer).isHigherOrEqualTo(v30) ? 1 : 0;
        }
        InputStream in = response.getStream();
        try {
            CIMItem cimItem = null;
            try {
                cimItem = this.xml2cim.xml2Cim(in);
                if (CIMTraceUtil.traceLevel >= 6 && Util.isLogging(logger, Level.FINEST)) {
                    logger.finest(cimItem.toXml());
                }
                vServer = (CIMCim)cimItem;
                Object var10_9 = null;
            }
            catch (ItemConstructionExcp ex) {
                CIMClientException cce = new CIMClientException("Invalid server response (XML not valid)");
                cce.setCause(ex);
                throw cce;
            }
            catch (ClassCastException cce) {
                throw new CIMClientException("Invalid server response (" + cimItem.getDTDName() + " received instead of CIM");
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            response.releaseStream();
            throw throwable;
        }
        response.releaseStream();
        return vServer;
    }

    private CIMClientException newClientException(IResponse response) {
        String cimErrorMsg;
        String statusDescription = response.getStatusDescription();
        if (statusDescription == null) {
            statusDescription = "";
        }
        if ((cimErrorMsg = response.getHeaderValue("CIMError")) == null) {
            if (statusDescription.length() == 0) {
                return new CIMClientException(response.getStatus());
            }
            return new CIMClientException(response.getStatus(), statusDescription);
        }
        return new CIMClientException(response.getStatus(), MessageFormat.format("{0} ({1})", statusDescription, cimErrorMsg));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CIMCim send(CIMCim cimRequest) throws LcrException, CIMClientException {
        try {
            IResponse response;
            boolean useCompression = this.compressionSupport == 1 || this.compressionSupport == 0;
            WbemPostRequest request = new WbemPostRequest(cimRequest, false, useCompression, this.getServletPath());
            this.setCommonHeaders((IRequest)request);
            if (this.serverVersion != 1) {
                request.setHeader("SAP-Accepted-Cookie", "JSESSIONID");
            }
            if (request.simpleRequestCount > 1) {
                int increasedTimeOut = (int)Math.round(Math.sqrt(request.simpleRequestCount) * 90000.0);
                this.connection.setSocketReadTimeout(increasedTimeOut);
            }
            try {
                try {
                    response = this.connection.send((IRequest)request);
                }
                catch (IllegalArgumentException ex) {
                    throw new CIMClientException(ex);
                }
                Object var7_8 = null;
                if (request.simpleRequestCount <= 1) return this.processResponse(response, cimRequest);
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (request.simpleRequestCount <= 1) throw throwable;
                this.connection.setSocketReadTimeout(90000);
                throw throwable;
            }
            this.connection.setSocketReadTimeout(90000);
            return this.processResponse(response, cimRequest);
        }
        catch (IOException ex) {
            throw new CIMClientException(ex);
        }
        catch (HTTPException ex) {
            throw new CIMClientException((Exception)((Object)ex));
        }
    }

    public void disconnect() {
        block5: {
            try {
                RequestBase logOutRequest = new RequestBase("LogOut", this.getServletPath());
                this.setCommonHeaders((IRequest)logOutRequest);
                IResponse response = this.connection.send((IRequest)logOutRequest);
                int status = response.getStatus();
                if (status != 200 && CIMTraceUtil.traceLevel >= 1) {
                    logger.warning("Log out failed: {0} {1}", new Object[]{new Integer(status), response.getStatusDescription()});
                }
                this.connection.close();
            }
            catch (IOException e) {
                if (CIMTraceUtil.traceLevel >= 1) {
                    logger.warning("Error during log out", e);
                }
            }
            catch (HTTPException e) {
                if (CIMTraceUtil.traceLevel < 1) break block5;
                logger.warning("Error during log out", e);
            }
        }
    }

    public boolean returnWritableObjectsPerDefault() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

