/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cimclient.CIMHttp;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimclient.SecureStoreAccess;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class HttpDestinationStore
implements Serializable {
    static final long serialVersionUID = -2043292028574157676L;
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_CONFIG_NAME = "default";
    private static final int classVersion = 0;
    private static final String destinationComment = "SLD HTTP destinations";
    private int instanceVersion = 0;
    byte[] destinationStream = null;
    transient Properties destinationProperties;

    public HttpDestinationStore() {
        this.destinationProperties = new Properties();
    }

    public HttpDestinationStore(Properties connectProperties) {
        this.destinationProperties = (Properties)((Hashtable)connectProperties).clone();
    }

    public static HttpDestinationStore getHttpDestinations() throws LcrException {
        HttpDestinationStore currentDests = SecureStoreAccess.loadConfigFromSecureStore();
        return currentDests;
    }

    public void setHttpDestination(String destinationName, String host, int port, String user, String pwd) {
        String config;
        if (destinationName == null) {
            this.destinationProperties.setProperty("defaultConfiguration", DEFAULT_CONFIG_NAME);
            config = DEFAULT_CONFIG_NAME;
        } else {
            config = destinationName;
        }
        this.destinationProperties.setProperty(config + ".host", host);
        this.destinationProperties.setProperty(config + ".port", String.valueOf(port));
        this.destinationProperties.setProperty(config + ".user", user);
        this.destinationProperties.setProperty(config + ".pwd", pwd);
        ((Hashtable)this.destinationProperties).remove(config + ".URL");
    }

    public void setHttpDestination(String destinationName, String host, int port, String user, String pwd, String namespace) {
        String config;
        if (destinationName == null) {
            this.destinationProperties.setProperty("defaultConfiguration", DEFAULT_CONFIG_NAME);
            config = DEFAULT_CONFIG_NAME;
        } else {
            config = destinationName;
        }
        this.destinationProperties.setProperty(config + ".host", host);
        this.destinationProperties.setProperty(config + ".port", String.valueOf(port));
        this.destinationProperties.setProperty(config + ".user", user);
        this.destinationProperties.setProperty(config + ".pwd", pwd);
        this.destinationProperties.setProperty(config + ".namespace", namespace);
        ((Hashtable)this.destinationProperties).remove(config + ".URL");
    }

    public void setHttpDestination(String destinationName, URL url, String user, String pwd) {
        String config;
        if (destinationName == null) {
            this.destinationProperties.setProperty("defaultConfiguration", DEFAULT_CONFIG_NAME);
            config = DEFAULT_CONFIG_NAME;
        } else {
            config = destinationName;
        }
        this.destinationProperties.setProperty(config + ".URL", url.toString());
        this.destinationProperties.setProperty(config + ".user", user);
        this.destinationProperties.setProperty(config + ".pwd", pwd);
    }

    public void setHttpDestination(String destinationName, URL url, String user, String pwd, String namespace) {
        String config;
        if (destinationName == null) {
            this.destinationProperties.setProperty("defaultConfiguration", DEFAULT_CONFIG_NAME);
            config = DEFAULT_CONFIG_NAME;
        } else {
            config = destinationName;
        }
        this.destinationProperties.setProperty(config + ".URL", url.toString());
        this.destinationProperties.setProperty(config + ".user", user);
        this.destinationProperties.setProperty(config + ".pwd", pwd);
        this.destinationProperties.setProperty(config + ".namespace", namespace);
    }

    public void setHttpDestination(String destinationName, com.tssap.dtr.client.lib.protocol.URL url, String user, String pwd, String namespace) {
        try {
            this.setHttpDestination(destinationName, new URL(url.toString()), user, pwd, namespace);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public void setHttpDestination(String destinationName, URL url, String user, String pwd, String namespace, String truststore, String keystore) {
        String config;
        if (destinationName == null) {
            this.destinationProperties.setProperty("defaultConfiguration", DEFAULT_CONFIG_NAME);
            config = DEFAULT_CONFIG_NAME;
        } else {
            config = destinationName;
        }
        this.destinationProperties.setProperty(config + ".URL", url.toString());
        if (user != null) {
            this.destinationProperties.setProperty(config + ".user", user);
        }
        if (pwd != null) {
            this.destinationProperties.setProperty(config + ".pwd", pwd);
        }
        if (namespace != null) {
            this.destinationProperties.setProperty(config + ".namespace", namespace);
        }
        if (truststore != null) {
            this.destinationProperties.setProperty(config + ".truststore", truststore);
        }
        if (keystore != null) {
            this.destinationProperties.setProperty(config + ".keystore", keystore);
        }
    }

    public void removeDestination(String destinationName) {
        if (destinationName == null) {
            return;
        }
        ((Hashtable)this.destinationProperties).remove(destinationName + ".host");
        ((Hashtable)this.destinationProperties).remove(destinationName + ".port");
        ((Hashtable)this.destinationProperties).remove(destinationName + ".URL");
        ((Hashtable)this.destinationProperties).remove(destinationName + ".user");
        ((Hashtable)this.destinationProperties).remove(destinationName + ".pwd");
        ((Hashtable)this.destinationProperties).remove(destinationName + ".namespace");
        ((Hashtable)this.destinationProperties).remove(destinationName + ".truststore");
        ((Hashtable)this.destinationProperties).remove(destinationName + ".keystore");
    }

    public String getDefaultConfigName() {
        return this.destinationProperties.getProperty("defaultConfiguration");
    }

    public com.tssap.dtr.client.lib.protocol.URL getSAPURL(String destinationName) {
        try {
            URL javaURL = this.getURL(destinationName);
            if (javaURL == null) {
                return null;
            }
            return CIMHttp.java2DtrHttpURL(javaURL);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URL getURL(String destinationName) {
        URL urlObj2;
        int iport;
        String config = destinationName != null ? destinationName : this.getDefaultConfigName();
        String urlVal = this.destinationProperties.getProperty(config + ".URL");
        if (urlVal != null) {
            URL urlObj2;
            try {
                urlObj2 = new URL(urlVal);
            }
            catch (MalformedURLException mue) {
                return null;
            }
            return urlObj2;
        }
        String host = this.destinationProperties.getProperty(config + ".host");
        String port = this.destinationProperties.getProperty(config + ".port");
        if (host == null || port == null) {
            return null;
        }
        try {
            iport = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        try {
            urlObj2 = new URL(DEFAULT_PROTOCOL, host, iport, "");
        }
        catch (MalformedURLException mue) {
            return null;
        }
        return urlObj2;
    }

    public String getHost(String destinationName) {
        String config = destinationName != null ? destinationName : this.getDefaultConfigName();
        String urlVal = this.destinationProperties.getProperty(config + ".URL");
        if (urlVal != null) {
            URL urlObj;
            try {
                urlObj = new URL(urlVal);
            }
            catch (MalformedURLException mue) {
                return null;
            }
            return urlObj.getHost();
        }
        return this.destinationProperties.getProperty(config + ".host");
    }

    public int getPort(String destinationName) {
        int iport;
        String config = destinationName != null ? destinationName : this.getDefaultConfigName();
        String urlVal = this.destinationProperties.getProperty(config + ".URL");
        if (urlVal != null) {
            URL urlObj;
            try {
                urlObj = new URL(urlVal);
            }
            catch (MalformedURLException mue) {
                return 0;
            }
            return urlObj.getPort();
        }
        String port = this.destinationProperties.getProperty(config + ".port");
        try {
            iport = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
        return iport;
    }

    public String getUser(String destinationName) {
        String config = destinationName != null ? destinationName : this.getDefaultConfigName();
        return this.destinationProperties.getProperty(config + ".user");
    }

    public String getPwd(String destinationName) {
        String config = destinationName != null ? destinationName : this.getDefaultConfigName();
        return this.destinationProperties.getProperty(config + ".pwd");
    }

    public String getNamespace(String destinationName) {
        String config = destinationName != null ? destinationName : this.getDefaultConfigName();
        return this.destinationProperties.getProperty(config + ".namespace");
    }

    public String getTruststore(String destinationName) {
        String config = destinationName != null ? destinationName : this.getDefaultConfigName();
        return this.destinationProperties.getProperty(config + ".truststore");
    }

    public String getKeystore(String destinationName) {
        String config = destinationName != null ? destinationName : this.getDefaultConfigName();
        return this.destinationProperties.getProperty(config + ".keystore");
    }

    public Properties getProperties() {
        return this.destinationProperties;
    }

    public List getDestinationNames() {
        ArrayList<String> myDestNames = new ArrayList<String>();
        String defaultConfig = this.getDefaultConfigName();
        if (defaultConfig != null) {
            myDestNames.add(defaultConfig);
        }
        Set propSet = ((Hashtable)this.destinationProperties).keySet();
        Iterator propIter = propSet.iterator();
        while (propIter.hasNext()) {
            String nextConfigName;
            String nextPropKey = (String)propIter.next();
            if (!nextPropKey.endsWith(".host") || (nextConfigName = nextPropKey.substring(0, nextPropKey.length() - ".host".length())).length() <= 0 || nextConfigName.equals(defaultConfig)) continue;
            myDestNames.add(nextConfigName);
        }
        return myDestNames;
    }

    public boolean isValid() {
        String config = this.getDefaultConfigName();
        return this.isValid(config);
    }

    public boolean isValid(String config) {
        if (config == null) {
            return false;
        }
        return this.getHost(config) != null && this.getPort(config) != 0 && (this.getUser(config) != null && this.getPwd(config) != null || this.getKeystore(config) != null);
    }

    private void readObject(ObjectInputStream objIn) throws IOException, ClassNotFoundException {
        objIn.defaultReadObject();
        switch (this.instanceVersion) {
            default: 
        }
        this.instanceVersion = 0;
        this.buildDerivedProperties();
    }

    private void writeObject(ObjectOutputStream objOut) throws IOException {
        this.buildSerializedContent();
        objOut.defaultWriteObject();
    }

    private void buildDerivedProperties() throws IOException {
        if (this.destinationStream != null) {
            this.destinationProperties = new Properties();
            this.destinationProperties.load(new ByteArrayInputStream(this.destinationStream));
        }
    }

    private void buildSerializedContent() throws IOException {
        ByteArrayOutputStream destOut = new ByteArrayOutputStream();
        this.destinationProperties.store(destOut, destinationComment);
        this.destinationStream = destOut.toByteArray();
    }

    void dummyMethod() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream testBAOS = new ByteArrayOutputStream();
        this.writeObject(new ObjectOutputStream(testBAOS));
        byte[] testBA = testBAOS.toByteArray();
        this.readObject(new ObjectInputStream(new ByteArrayInputStream(testBA)));
    }
}

