/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cimclient.CIMConst;
import com.sap.lcr.api.cimclient.CIMStatusCodes;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.ByteBuffer;
import com.sap.lcr.api.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public final class CIMHttp
implements CIMStatusCodes,
CIMConst {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cimclient$CIMHttp == null ? (class$com$sap$lcr$api$cimclient$CIMHttp = CIMHttp.class$("com.sap.lcr.api.cimclient.CIMHttp")) : class$com$sap$lcr$api$cimclient$CIMHttp).getName());
    private static final String ENC_ISO_8859_1 = "ISO-8859-1";
    public static final String METHOD_M_POST = "M-POST";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_LOGOUT = "LogOut";
    public static final String UTF8 = "UTF-8";
    public static final String LATIN1 = "ISO-8859-1";
    public static final String IDENTITY = "identity";
    public static final String DEFLATE = "deflate";
    public static final String TEXT_XML = "text/xml";
    public static final String APPL_XML = "application/xml";
    public static final String TEXT_XML_UTF8 = "text/xml; charset=utf-8";
    public static final String APPL_XML_UTF8 = "application/xml; charset=utf-8";
    public static final String TEXT_XML_LATIN1 = "text/xml; charset=iso-8859-1";
    public static final String HDR_ACCEPT = "Accept";
    public static final String HDR_ACCEPT_CS = "Accept-Charset";
    public static final String HDR_ACCEPT_ENC = "Accept-Encoding";
    public static final String HDR_ACCEPT_LANG = "Accept-Language";
    public static final String HDR_ACCEPT_RANGES = "Accept-Ranges";
    public static final String HDR_ALLOW = "Allow";
    public static final String HDR_AUTHORIZATION = "Authorization";
    public static final String HDR_CACHE = "Cache-Control";
    public static final String HDR_CONTENT_ENC = "Content-Encoding";
    public static final String HDR_CONTENT_LANG = "Content-Language";
    public static final String HDR_CONTENT_TYPE = "Content-Type";
    public static final String HDR_PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String HDR_WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String HDR_COOKIE = "Cookie";
    public static final String HDR_SET_COOKIE = "Set-Cookie";
    public static final String HDR_LOGOUT = "LogOut";
    public static final String EXTHDR_CIMOperation = "CIMOperation";
    public static final String EXTHDR_CIMMethod = "CIMMethod";
    public static final String EXTHDR_CIMObject = "CIMObject";
    public static final String EXTHDR_CIMBatch = "CIMBatch";
    public static final String EXTHDR_CIMError = "CIMError";
    public static final String EXTHDR_CIMProtocolVersion = "CIMProtocolVersion";
    public static final String CIMOP_CALL = "MethodCall";
    public static final String CIMOP_RESPONSE = "MethodResponse";
    public static final String ERR_PROT_VERSION = "unsupported-protocol-version";
    public static final String ERR_MULTIREQ_NOT_SUPPORTED = "multiple-requests-unsupported";
    public static final String ERR_CIM_VERSION = "unsupported-cim-version";
    public static final String ERR_DTD_VERSION = "unsupported-dtd-version";
    public static final String ERR_INVALID_REQ = "request-not-valid";
    public static final String ERR_WELL_FORMEDNESS = "request-not-well-formed";
    public static final String ERR_NOT_LOOSELY_VALID = "request-not-loosely-valid";
    public static final String ERR_HEADER_MISMATCH = "header-mismatch";
    public static final String ERR_UNSUPPORTED_OP = "unsupported-operation";
    public static final String COOKIE_SAP_LOGON_TICKET = "MYSAPSSO2";
    public static final String COOKIE_JSESSIONID = "JSESSIONID";
    public static final String HDR_SAP_ACCEPTED_COOKIE = "SAP-Accepted-Cookie";
    public static final String HDR_SAP_CIM_CLIENT = "SAP-CIM-Client";
    public static final String HDR_SAP_CIM_SERVER = "SAP-CIM-Server";
    private static final String CIM_NAMESPACE_QUERY_PARAM_NAME = "CIMNameSpace";
    public static final String SAP_CIM_CLIENT_VERSION_JAVA = "2.3";
    public static final String SAP_CIM_CLIENT_VERSION_DTR = "3.3";
    public static final String SAP_CIM_SERVER_VERSION = "3.3";
    static /* synthetic */ Class class$com$sap$lcr$api$cimclient$CIMHttp;

    public static byte[] readInputStream(InputStream istream, int contentLength) throws IOException {
        if (contentLength == 0) {
            return null;
        }
        int read = 0;
        int readAll = 0;
        int availableGuess = 0;
        try {
            availableGuess = Math.max(4096, Math.max(contentLength, istream.available()));
            ByteBuffer buf = new ByteBuffer(availableGuess);
            byte[] bytes = new byte[8192];
            while ((read = istream.read(bytes)) != -1) {
                readAll += read;
                buf.append(bytes, 0, read);
            }
            return buf.toByteArray();
        }
        catch (RuntimeException ex) {
            if (CIMTraceUtil.traceLevel >= 1) {
                logger.warning("Failed to read from input stream {0}, read={1}, readAll={2}, availableGuess={3}, contentLenght={4}", new Object[]{istream.getClass().getName(), new Integer(read), new Integer(readAll), new Integer(availableGuess), new Integer(contentLength)}, (Throwable)ex);
            }
            throw ex;
        }
    }

    public static String escapeUnicodeHeader(String arg) {
        byte[] bytes = CIMHttp.escapeUnicodeHeaderBA(arg);
        try {
            return new String(bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public static String escapeUnicodeURLSubElement(String arg) {
        byte[] bytes = CIMHttp.encodeURLElement(arg, true);
        try {
            return new String(bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public static byte[] escapeUnicodeHeaderBA(String arg) {
        return CIMHttp.encodeURLElement(arg, false);
    }

    private static byte[] encodeURLElement(String arg, boolean escapeReserved) {
        byte[] utf8 = Util.toUTF8(arg);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(3 * utf8.length);
        int i = 0;
        while (i < utf8.length) {
            char c = (char)(0xFF & utf8[i]);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')') {
                buf.write(c);
            } else if (!(escapeReserved || c != ';' && c != '/' && c != '?' && c != ':' && c != '@' && c != '&' && c != '=' && c != '+' && c != '$' && c != ',')) {
                buf.write(c);
            } else {
                String hex = Integer.toHexString(c);
                buf.write(37);
                if (hex.length() == 1) {
                    buf.write(48);
                    buf.write(hex.charAt(0));
                } else {
                    buf.write(hex.charAt(0));
                    buf.write(hex.charAt(1));
                }
            }
            ++i;
        }
        return buf.toByteArray();
    }

    public static String unescapeUnicodeURLSubElement(String arg) {
        return CIMHttp.unescapeUnicodeHeader(arg);
    }

    public static String unescapeUnicodeHeader(String arg) {
        if (arg == null) {
            return null;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream(arg.length());
        int index = 0;
        while (index < arg.length()) {
            char c = arg.charAt(index);
            if (c != '%') {
                ++index;
                buf.write(c & 0xFF);
                continue;
            }
            if ((index += 3) > arg.length()) {
                index -= 2;
                buf.write(c & 0xFF);
                continue;
            }
            String hex = arg.substring(index - 2, index);
            buf.write(Integer.parseInt(hex, 16));
        }
        return Util.fromUTF8(buf.toByteArray());
    }

    public static String[] getListTokens(String arg) {
        StringTokenizer tok = new StringTokenizer(arg, " ,\r\n\f\t");
        String[] array = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            array[i++] = tok.nextToken();
        }
        return array;
    }

    public static boolean contains(String[] array, String string, boolean ignoreCase) {
        if (ignoreCase) {
            int i = 0;
            while (i < array.length) {
                if (string.equalsIgnoreCase(array[i])) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < array.length) {
                if (string.equals(array[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String getValue(String arg) {
        int i = arg.indexOf(";");
        if (i == -1) {
            return arg.trim();
        }
        return arg.substring(0, i).trim();
    }

    public static String getParameter(String arg) {
        int i = arg.indexOf(";");
        if (i == -1) {
            return null;
        }
        return arg.substring(i + 1).trim();
    }

    public static String getParamKey(String arg) {
        int i = arg.indexOf("=");
        if (i == -1) {
            return arg.trim();
        }
        return arg.substring(0, i).trim();
    }

    public static String getParamValue(String arg) {
        int i = arg.indexOf("=");
        if (i == -1) {
            return null;
        }
        return arg.substring(i + 1).trim();
    }

    public static URL setPartition(URL inURL, String partition) throws MalformedURLException {
        com.tssap.dtr.client.lib.protocol.URL dtrUrl = CIMHttp.java2DtrHttpURL(inURL);
        dtrUrl = CIMHttp.setPartition(dtrUrl, partition);
        return new URL(dtrUrl.toString());
    }

    public static com.tssap.dtr.client.lib.protocol.URL setPartition(com.tssap.dtr.client.lib.protocol.URL inURL, String partition) throws MalformedURLException {
        String orgFragment;
        String orgQuery;
        StringBuffer newUrlBuffer = new StringBuffer();
        newUrlBuffer.append(inURL.getWebLocator());
        String path = inURL.getPath();
        if (path == null || path.length() == 0) {
            path = "/";
        }
        newUrlBuffer.append(path);
        if (partition != null) {
            newUrlBuffer.append('?').append(CIM_NAMESPACE_QUERY_PARAM_NAME).append('=').append(CIMHttp.escapeUnicodeURLSubElement(partition));
        }
        if ((orgQuery = inURL.getQuery()) != null && orgQuery.length() > 0) {
            String queryParam = "CIMNameSpace=";
            boolean appendQuestionMark = partition == null;
            StringTokenizer paramTokenizer = new StringTokenizer(orgQuery, "&");
            while (paramTokenizer.hasMoreTokens()) {
                String nextQueryPart = paramTokenizer.nextToken();
                if (nextQueryPart.startsWith("CIMNameSpace=")) continue;
                newUrlBuffer.append(appendQuestionMark ? (char)'?' : '&');
                newUrlBuffer.append(nextQueryPart);
                appendQuestionMark = false;
            }
        }
        if ((orgFragment = inURL.getFragment()) != null && orgFragment.length() != 0) {
            newUrlBuffer.append('#').append(orgFragment);
        }
        return new com.tssap.dtr.client.lib.protocol.URL(newUrlBuffer.toString());
    }

    public static String getPartition(URL inURL) {
        try {
            return CIMHttp.getPartition(CIMHttp.java2DtrHttpURL(inURL));
        }
        catch (MalformedURLException mfue) {
            return null;
        }
    }

    public static String getPartition(com.tssap.dtr.client.lib.protocol.URL inURL) {
        String paramValue = inURL.getQueryParameter(CIM_NAMESPACE_QUERY_PARAM_NAME);
        return paramValue == null ? null : CIMHttp.unescapeUnicodeURLSubElement(paramValue);
    }

    static com.tssap.dtr.client.lib.protocol.URL java2DtrHttpURL(URL javaURL) throws MalformedURLException {
        String path;
        String query = javaURL.getQuery();
        if (query != null && query.length() != 0 && ((path = javaURL.getPath()) == null || path.length() == 0)) {
            String urlString = javaURL.toString();
            int queryPos = urlString.indexOf("?" + query);
            StringBuffer buf = new StringBuffer(urlString.length() + 1);
            buf.append(urlString.substring(0, queryPos));
            buf.append("/?");
            buf.append(query);
            urlString = buf.toString();
            return new com.tssap.dtr.client.lib.protocol.URL(urlString);
        }
        return new com.tssap.dtr.client.lib.protocol.URL(javaURL.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

