/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cim.CIMSimpleRspList;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimclient.SimpleResponseAnalyser;

public class CIMBatchResult {
    private final CIMSimpleRspList responses;
    private final Object[] analysedResponses;
    private final boolean returnWritables;
    private int[] succeeded;
    private int[] failed;

    CIMBatchResult(CIMSimpleRspList responses, boolean returnWritables) {
        this.responses = responses;
        this.analysedResponses = new Object[responses.size()];
        this.returnWritables = returnWritables;
    }

    public Object getResult(int id) throws LcrException, CIMClientException {
        Object result = this.analyse(id);
        if (result instanceof LcrException) {
            throw (LcrException)result;
        }
        if (result instanceof CIMClientException) {
            throw (CIMClientException)result;
        }
        return result;
    }

    public boolean succeeded(int id) {
        Object result = this.analyse(id);
        return !(result instanceof Exception);
    }

    public int size() {
        return this.analysedResponses.length;
    }

    public int[] getSucceeded() {
        if (this.succeeded == null) {
            this.collectIDs();
        }
        return this.copy(this.succeeded);
    }

    public int[] getFailed() {
        if (this.failed == null) {
            this.collectIDs();
        }
        return this.copy(this.failed);
    }

    private int[] copy(int[] in) {
        int[] out = new int[in.length];
        System.arraycopy(in, 0, out, 0, in.length);
        return out;
    }

    private void collectIDs() {
        int len = this.analysedResponses.length;
        int[] tmp = new int[len];
        int nextSuccess = 0;
        int nextFailure = len - 1;
        int i = 0;
        while (i < len) {
            Object result = this.analyse(i);
            if (result instanceof Exception) {
                tmp[nextFailure--] = i;
            } else {
                tmp[nextSuccess++] = i;
            }
            ++i;
        }
        if (nextSuccess == len) {
            this.succeeded = tmp;
        } else {
            this.succeeded = new int[nextSuccess];
            System.arraycopy(tmp, 0, this.succeeded, 0, nextSuccess);
        }
        if (nextFailure == -1) {
            this.failed = tmp;
        } else {
            this.failed = new int[len - nextFailure - 1];
            int t = len - 1;
            int i2 = 0;
            while (i2 < this.failed.length) {
                this.failed[i2] = tmp[t--];
                ++i2;
            }
        }
    }

    private Object analyse(int id) {
        Object result = this.analysedResponses[id];
        if (result == null) {
            try {
                result = this.analysedResponses[id] = SimpleResponseAnalyser.getIResult(this.responses.get(id), this.returnWritables);
            }
            catch (LcrException ex) {
                result = this.analysedResponses[id] = ex;
            }
            catch (CIMClientException ex) {
                result = this.analysedResponses[id] = ex;
            }
        }
        if (result == null) {
            this.analysedResponses[id] = Void.TYPE;
        }
        return result == Void.TYPE ? null : result;
    }
}

