/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMConstants;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.util.EmptyStackException;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

final class Xml2CimTransformer
extends DefaultHandler {
    private final Stack itemStack = new Stack();
    private ItemConstructionExcp encounteredExcp;
    private boolean complete;
    private CIMItem createdItem;
    private CIMItem currentItem;
    private static final int iQUALIFIER = 1538654346;
    private static final int iPROPERTY = -210514475;
    private static final int iPROPERTYARRAY = 74367200;
    private static final int iPROPERTYREFERENCE = -649729454;
    private static final int iVALUE = 81434961;
    private static final int iVALUEARRAY = 567672668;
    private static final int iVALUEREFERENCE = 1538362062;
    private static final int iCLASS = 64205144;
    private static final int iINSTANCE = 1337754773;
    private static final int iCIM = 66727;
    private static final int iDECLARATION = 124455258;
    private static final int iDECLGROUP = -1075878923;
    private static final int iDECLGROUPWITHNAME = 1995733546;
    private static final int iDECLGROUPWITHPATH = 1995793348;
    private static final int iQUALIFIERDECLARATION = 1991131638;
    private static final int iSCOPE = 78726708;
    private static final int iVALUEREFARRAY = -1478078045;
    private static final int iVALUEOBJECT = 803780220;
    private static final int iVALUENAMEDINSTANCE = -1733825327;
    private static final int iVALUENAMEDOBJECT = 1249107579;
    private static final int iVALUEOBJECTWITHLOCALPATH = 739061486;
    private static final int iVALUEOBJECTWITHPATH = 915975271;
    private static final int iNAMESPACEPATH = -1377457184;
    private static final int iLOCALNAMESPACEPATH = -715442571;
    private static final int iHOST = 2223528;
    private static final int iNAMESPACE = -256154309;
    private static final int iCLASSPATH = -1517248131;
    private static final int iLOCALCLASSPATH = -1523269998;
    private static final int iCLASSNAME = -1517307933;
    private static final int iINSTANCEPATH = 1580437050;
    private static final int iLOCALINSTANCEPATH = -1723343611;
    private static final int iINSTANCENAME = 1580377248;
    private static final int iOBJECTPATH = 1552759780;
    private static final int iKEYBINDING = -912858298;
    private static final int iKEYVALUE = 1304430194;
    private static final int iMETHOD = -2024225567;
    private static final int iPARAMETER = 446088073;
    private static final int iPARAMETERREFERENCE = -1916252410;
    private static final int iPARAMETERARRAY = 1386717076;
    private static final int iPARAMETERREFARRAY = -1035327893;
    private static final int iMESSAGE = 1672907751;
    private static final int iMULTIREQ = 1436458181;
    private static final int iSIMPLEREQ = 662233484;
    private static final int iIMETHODCALL = 1729091528;
    private static final int iMETHODCALL = -237445441;
    private static final int iPARAMVALUE = 958969092;
    private static final int iIPARAMVALUE = -1369461235;
    private static final int iMULTIRSP = 1436458614;
    private static final int iSIMPLERSP = 662233917;
    private static final int iMETHODRESPONSE = 2128042018;
    private static final int iIMETHODRESPONSE = 510174379;
    private static final int iERROR = 66247144;
    private static final int iRETURNVALUE = 687384097;
    private static final int iIRETURNVALUE = 1520487992;

    public Xml2CimTransformer() {
        this.reinit();
    }

    public void reinit() {
        this.encounteredExcp = null;
        this.complete = false;
        this.createdItem = null;
        this.currentItem = null;
        this.itemStack.clear();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.errorOrComplete()) {
            return;
        }
        if (this.currentItem != null) {
            this.itemStack.push(this.currentItem);
            this.currentItem = null;
        }
        try {
            this.currentItem = this.getItemForElementName(qName);
            this.currentItem.setAttributes(attributes);
        }
        catch (ItemConstructionExcp e) {
            this.setEncounteredExcp(e);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (this.errorOrComplete()) {
            return;
        }
        if (this.currentItemMissing()) {
            return;
        }
        try {
            if (this.itemStack.empty()) {
                this.createdItem = this.currentItem;
                this.currentItem = null;
                this.complete = true;
            } else {
                CIMItem parentItem = (CIMItem)this.itemStack.pop();
                this.currentItem.endXmlBuild(parentItem);
                this.currentItem = parentItem;
            }
        }
        catch (EmptyStackException e) {
            this.setEncounteredExcp(new ItemConstructionExcp(e));
        }
        catch (ItemConstructionExcp e) {
            this.setEncounteredExcp(e);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.errorOrComplete()) {
            return;
        }
        if (length == 0) {
            return;
        }
        if (this.currentItemMissing()) {
            return;
        }
        String characters = new String(ch, start, length);
        try {
            this.currentItem.setCharacters(characters);
        }
        catch (ItemConstructionExcp e) {
            this.setEncounteredExcp(e);
        }
    }

    public CIMItem getCreatedItem() throws ItemConstructionExcp {
        try {
            if (this.encounteredExcp != null) {
                throw this.encounteredExcp;
            }
            CIMItem cIMItem = this.createdItem;
            Object var3_2 = null;
            this.reinit();
            return cIMItem;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.reinit();
            throw throwable;
        }
    }

    private boolean errorOrComplete() {
        if (this.encounteredExcp != null) {
            return true;
        }
        if (this.complete) {
            this.setEncounteredExcp(new ItemConstructionExcp(9, ItemConstructionExcp.getErrmsg(9)));
            return true;
        }
        return false;
    }

    private boolean currentItemMissing() {
        if (this.currentItem == null) {
            this.setEncounteredExcp(new ItemConstructionExcp(new NullPointerException("currentItem is missing")));
            return true;
        }
        return false;
    }

    protected CIMItem getItemForElementName(String elementname) throws ItemConstructionExcp {
        switch (elementname.hashCode()) {
            case 1538654346: {
                return CIMFactory.qualifier();
            }
            case -210514475: {
                return CIMFactory.property();
            }
            case 74367200: {
                return CIMFactory.propertyArray();
            }
            case -649729454: {
                return CIMFactory.propertyReference();
            }
            case 81434961: {
                return CIMFactory.value();
            }
            case 567672668: {
                return CIMFactory.valueArray();
            }
            case 1538362062: {
                return CIMFactory.valueReference();
            }
            case 64205144: {
                return CIMFactory.cimclass();
            }
            case 1337754773: {
                return CIMFactory.instance();
            }
            case 66727: {
                return CIMFactory.cim();
            }
            case 124455258: {
                return CIMFactory.declaration();
            }
            case -1075878923: {
                return CIMFactory.declgroup();
            }
            case 1995733546: {
                return CIMFactory.declgroupWithName();
            }
            case 1995793348: {
                return CIMFactory.declgroupWithPath();
            }
            case 1991131638: {
                return CIMFactory.qualifierDeclaration();
            }
            case 78726708: {
                return CIMFactory.scope();
            }
            case -1478078045: {
                return CIMFactory.valueRefarray();
            }
            case 803780220: {
                return CIMFactory.valueObject();
            }
            case -1733825327: {
                return CIMFactory.valueNamedInstance();
            }
            case 1249107579: {
                return CIMFactory.valueNamedObject();
            }
            case 739061486: {
                return CIMFactory.valueObjectWithLocalPath();
            }
            case 915975271: {
                return CIMFactory.valueObjectWithPath();
            }
            case -1377457184: {
                return CIMFactory.namespacepath();
            }
            case -715442571: {
                return CIMFactory.localnamespacepath();
            }
            case 2223528: {
                return CIMFactory.host();
            }
            case -256154309: {
                return CIMFactory.namespace();
            }
            case -1517248131: {
                return CIMFactory.classpath();
            }
            case -1523269998: {
                return CIMFactory.localclasspath();
            }
            case -1517307933: {
                return CIMFactory.classname();
            }
            case 1580437050: {
                return CIMFactory.instancepath();
            }
            case -1723343611: {
                return CIMFactory.localinstancepath();
            }
            case 1580377248: {
                return CIMFactory.instancename();
            }
            case 1552759780: {
                return CIMFactory.objectpath();
            }
            case -912858298: {
                return CIMFactory.keybinding();
            }
            case 1304430194: {
                return CIMFactory.keyValue();
            }
            case -2024225567: {
                return CIMFactory.method();
            }
            case 446088073: {
                return CIMFactory.parameter();
            }
            case -1916252410: {
                return CIMFactory.parameterReference();
            }
            case 1386717076: {
                return CIMFactory.parameterArray();
            }
            case -1035327893: {
                return CIMFactory.parameterRefarray();
            }
            case 1672907751: {
                return CIMFactory.message();
            }
            case 1436458181: {
                return CIMFactory.multiReq();
            }
            case 662233484: {
                return CIMFactory.simpleReq();
            }
            case 1729091528: {
                return CIMFactory.iMethodCall();
            }
            case -237445441: {
                return CIMFactory.methodCall();
            }
            case 958969092: {
                return CIMFactory.paramValue();
            }
            case -1369461235: {
                return CIMFactory.iParamValue();
            }
            case 1436458614: {
                return CIMFactory.multiRsp();
            }
            case 662233917: {
                return CIMFactory.simpleRsp();
            }
            case 2128042018: {
                return CIMFactory.methodResponse();
            }
            case 510174379: {
                return CIMFactory.iMethodResponse();
            }
            case 66247144: {
                return CIMFactory.error();
            }
            case 687384097: {
                return CIMFactory.returnValue();
            }
            case 1520487992: {
                return CIMFactory.iReturnValue();
            }
        }
        throw new ItemConstructionExcp(3, "Unknown xml tag: " + elementname);
    }

    private void setEncounteredExcp(ItemConstructionExcp encounteredExcp) {
        this.encounteredExcp = encounteredExcp;
        encounteredExcp.setXmlStackTrace(this.xmlStackTrace());
    }

    private String xmlStackTrace() {
        if (this.itemStack.size() == 0 && this.currentItem == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(32 + 32 * this.itemStack.size());
        if (this.currentItem != null) {
            this.appendItemToXmlStackTrace(this.currentItem, buf, this.itemStack.size() > 0);
        }
        int i = this.itemStack.size() - 1;
        while (i >= 0) {
            ICIMItem item = (ICIMItem)this.itemStack.get(i);
            this.appendItemToXmlStackTrace(item, buf, i != 0);
            --i;
        }
        return buf.toString();
    }

    private void appendItemToXmlStackTrace(ICIMItem item, StringBuffer buf, boolean newline) {
        buf.append("  in ");
        buf.append(CIMUtil.getQualifiedName(item));
        if (newline) {
            buf.append(CIMConstants.NEWLINE);
        }
    }
}

