/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ICIMReadOnly;

public class ReadOnlyException
extends RuntimeException {
    public ReadOnlyException(ICIMReadOnly item) {
        super("Readonly item can not be changed (" + ReadOnlyException.determineName(item) + ")");
    }

    private static String determineName(ICIMReadOnly item) {
        if (item instanceof ICIMNamedElement) {
            ICIMNamedElement namedElem = (ICIMNamedElement)item;
            return namedElem.getDTDName() + " " + namedElem.getName();
        }
        if (item instanceof ICIMItem) {
            ICIMItem cimItem = (ICIMItem)item;
            return cimItem.getDTDName();
        }
        return item.getClass().getName();
    }
}

