/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMUniqueList;
import com.sap.lcr.api.cim.ICIMNamedElement;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class PrependingIterator
implements Iterator {
    private final Iterator listIterator;
    private final ICIMNamedElement[] prependElements;
    private final int prependCount;
    private Object nextObject;
    private int nextPrepend;

    PrependingIterator(CIMUniqueList list, String[] prependNames) {
        this.listIterator = list.iterator();
        this.prependElements = new ICIMNamedElement[prependNames.length];
        int nextArrayIndex = 0;
        int i = 0;
        while (i < prependNames.length) {
            String name = prependNames[i];
            ICIMNamedElement element = list.getItem(name);
            if (element != null) {
                this.prependElements[nextArrayIndex++] = element;
            }
            ++i;
        }
        this.prependCount = nextArrayIndex;
        this.nextObject = this.determineNextObject();
    }

    private Object determineNextObject() {
        block0: while (this.listIterator.hasNext()) {
            Object nextCandidate = this.listIterator.next();
            int i = 0;
            while (i < this.prependCount) {
                if (nextCandidate == this.prependElements[i]) continue block0;
                ++i;
            }
            return nextCandidate;
        }
        return null;
    }

    public boolean hasNext() {
        return this.nextObject != null || this.nextPrepend < this.prependCount;
    }

    public Object next() {
        if (this.nextPrepend < this.prependCount) {
            return this.prependElements[this.nextPrepend++];
        }
        if (this.nextObject == null) {
            throw new NoSuchElementException();
        }
        Object returnObj = this.nextObject;
        this.nextObject = this.determineNextObject();
        return returnObj;
    }

    public void remove() {
        throw new UnsupportedOperationException("PrependingIterator does not support remove().");
    }
}

