/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMXmlAppender;
import com.sap.lcr.api.cim.ReadOnlyException;
import com.sap.lcr.api.cim.StringBufferWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.DeflaterOutputStream;

abstract class CIMXmlAppenderReadOnly
implements CIMXmlAppender,
Cloneable {
    private static final String UTF8 = "UTF-8";
    private static final String INDENT = "";
    private static final int BUFFER_SIZE = 4096;
    private static final int COMPRESSED_BUFFER_SIZE = 4096;
    private final boolean immutable;
    private boolean readOnly;

    CIMXmlAppenderReadOnly(boolean immutable) {
        this.immutable = immutable;
    }

    public final void appendXml(OutputStream stream, String indent) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, UTF8));
        this.appendXml(writer, indent);
        ((Writer)writer).flush();
    }

    public final void appendXml(StringBuffer buffer, String indent) {
        try {
            this.appendXml(new StringBufferWriter(buffer, 4096), indent);
        }
        catch (IOException ioEx) {
            throw new InternalError(ioEx.toString());
        }
    }

    public final void appendXmlCompressed(OutputStream out) throws IOException {
        DeflaterOutputStream deflaterOut = new DeflaterOutputStream(out);
        this.appendXml(deflaterOut, null);
        deflaterOut.finish();
        ((FilterOutputStream)deflaterOut).flush();
    }

    public final byte[] toCompressedXml() {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(4096);
            DeflaterOutputStream deflaterOut = new DeflaterOutputStream(byteOut);
            this.appendXml(deflaterOut, null);
            deflaterOut.close();
            return byteOut.toByteArray();
        }
        catch (IOException ioEx) {
            throw new InternalError(ioEx.getMessage());
        }
    }

    public final byte[] toUTF8Xml() {
        return this.toUTF8Xml(INDENT);
    }

    public final byte[] toUTF8Xml(String indentString) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            this.appendXml(out, indentString);
            return out.toByteArray();
        }
        catch (IOException ioEx) {
            throw new InternalError(ioEx.getMessage());
        }
    }

    public final String toXml() {
        return this.toXml(INDENT);
    }

    public final String toXml(String indentString) {
        try {
            StringBufferWriter writer = new StringBufferWriter(4096);
            this.appendXml(writer, indentString);
            return writer.toString();
        }
        catch (IOException ioEx) {
            throw new InternalError(ioEx.getMessage());
        }
    }

    public Object clone() {
        try {
            CIMXmlAppenderReadOnly clone = (CIMXmlAppenderReadOnly)super.clone();
            clone.readOnly = false;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public final Object getWritable() {
        return this.readOnly && !this.immutable ? this.clone() : this;
    }

    public final Object getReadOnly() {
        return this.readOnly || this.immutable ? this : ((CIMXmlAppenderReadOnly)this.clone()).makeReadOnly();
    }

    public final boolean isReadOnly() {
        return this.immutable ? false : this.readOnly;
    }

    public final Object makeReadOnly() {
        if (!this.readOnly) {
            this.readOnly = true;
            this.makeSubelementsReadOnly();
        }
        return this;
    }

    abstract void makeSubelementsReadOnly();

    final void checkWritable() {
        if (this.readOnly) {
            throw new ReadOnlyException(this);
        }
    }

    public abstract void appendXml(Writer var1, String var2) throws IOException;
}

