/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMClasspath;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMInstancepath;
import com.sap.lcr.api.cim.CIMItemList;
import com.sap.lcr.api.cim.CIMValueObjectWithPath;

public class CIMValueObjectWithPathList
extends CIMItemList {
    public static final CIMValueObjectWithPathList EMPTY = (CIMValueObjectWithPathList)CIMFactory.valueObjectWithPathList(0).makeReadOnly();

    CIMValueObjectWithPathList() {
    }

    CIMValueObjectWithPathList(int initialCapacity) {
        super(initialCapacity);
    }

    public CIMValueObjectWithPathList toWritable() {
        return (CIMValueObjectWithPathList)this.getWritable();
    }

    public void addValueObjectWithPath(CIMValueObjectWithPath aCIMValueObjectWithPath) {
        super.add(aCIMValueObjectWithPath);
    }

    public void addReadOnly(CIMValueObjectWithPath valueObjectWithPath) {
        super.addReadOnly(valueObjectWithPath);
    }

    public void addAll(CIMValueObjectWithPathList list) {
        super.addAll(list);
    }

    public void addAll(CIMValueObjectWithPath[] valueObjectsWithPath) {
        super.addAll(valueObjectsWithPath);
    }

    public void addAllReadOnly(CIMValueObjectWithPathList valueObjectWithPathList) {
        super.addAllReadOnly(valueObjectWithPathList);
    }

    public CIMValueObjectWithPath get(int idx) {
        return (CIMValueObjectWithPath)super.getItem(idx);
    }

    public int indexOf(CIMClasspath classPath) {
        int size = this.size();
        int i = 0;
        while (i < size) {
            CIMValueObjectWithPath obj = this.get(i);
            if (classPath.equals(obj.getClasspath())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(CIMClassname className) {
        int size = this.size();
        int i = 0;
        while (i < size) {
            CIMValueObjectWithPath obj = this.get(i);
            CIMClasspath classPath = obj.getClasspath();
            if (classPath != null && className.equals(classPath.getCIMClassname())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(CIMInstancepath instPath) {
        int size = this.size();
        int i = 0;
        while (i < size) {
            CIMValueObjectWithPath obj = this.get(i);
            if (instPath.equals(obj.getInstancepath())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(CIMInstancename instName) {
        int size = this.size();
        int i = 0;
        while (i < size) {
            CIMValueObjectWithPath obj = this.get(i);
            if (instName.equals(obj.getInstancename())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean contains(CIMClasspath classPath) {
        return this.indexOf(classPath) != -1;
    }

    public boolean contains(CIMClassname className) {
        return this.indexOf(className) != -1;
    }

    public boolean contains(CIMInstancepath instancePath) {
        return this.indexOf(instancePath) != -1;
    }

    public boolean contains(CIMInstancename instanceName) {
        return this.indexOf(instanceName) != -1;
    }

    public CIMValueObjectWithPath remove(CIMClasspath classPath) {
        int idx = this.indexOf(classPath);
        if (idx == -1) {
            return null;
        }
        return (CIMValueObjectWithPath)super.remove(idx);
    }

    public CIMValueObjectWithPath remove(CIMClassname className) {
        int idx = this.indexOf(className);
        if (idx == -1) {
            return null;
        }
        return (CIMValueObjectWithPath)super.remove(idx);
    }

    public CIMValueObjectWithPath remove(CIMInstancepath instancePath) {
        int idx = this.indexOf(instancePath);
        if (idx == -1) {
            return null;
        }
        return (CIMValueObjectWithPath)super.remove(idx);
    }

    public CIMValueObjectWithPath remove(CIMInstancename instanceName) {
        int idx = this.indexOf(instanceName);
        if (idx == -1) {
            return null;
        }
        return (CIMValueObjectWithPath)super.remove(idx);
    }

    public void set(int idx, CIMValueObjectWithPath valueObjectWithPath) {
        super.set(idx, valueObjectWithPath);
    }

    public void setReadOnly(int idx, CIMValueObjectWithPath valueObjectWithPath) {
        super.setReadOnly(idx, valueObjectWithPath);
    }

    public CIMValueObjectWithPath[] toTypedArray() {
        return (CIMValueObjectWithPath[])super.toArray(new CIMValueObjectWithPath[this.size()]);
    }
}

