/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClasspath;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMHost;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMInstancepath;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cim.CIMNamespacepath;
import com.sap.lcr.api.cim.CanonicalizedStrings;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMObject;
import com.sap.lcr.api.cim.ICIMObjectContainer;
import com.sap.lcr.api.cim.ICIMWithNamespacepath;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.LcrException;
import java.io.IOException;
import java.io.Writer;

public class CIMValueObjectWithPath
extends CIMItem
implements ICIMObjectContainer,
ICIMWithNamespacepath {
    public static final String DTD_NAME = "VALUE.OBJECTWITHPATH";
    private CIMClasspath classpath;
    private CIMClass theClass;
    private CIMInstancepath instancepath;
    private CIMInstance instance;
    private ICIMItem pathAppender;
    private ICIMItem objectAppender;

    protected CIMValueObjectWithPath() {
    }

    protected CIMValueObjectWithPath(CIMClasspath aClasspath, CIMClass aClass) {
        this.checkNonNull(aClass, "CLASS");
        this.checkNonNull(aClasspath, "CLASSPATH");
        this.classpath = aClasspath;
        this.pathAppender = this.classpath;
        this.theClass = aClass;
        this.objectAppender = this.theClass;
        if (this.pathAppender.isReadOnly() || this.objectAppender.isReadOnly()) {
            this.classpath = (CIMClasspath)this.classpath.getReadOnly();
            this.pathAppender = this.classpath;
            this.theClass = (CIMClass)this.theClass.getReadOnly();
            this.objectAppender = this.theClass;
            this.makeReadOnly();
        }
    }

    protected CIMValueObjectWithPath(CIMInstancepath anInstancepath, CIMInstance anInstance) {
        this.checkNonNull(anInstance, "INSTANCE");
        this.checkNonNull(anInstancepath, "INSTANCEPATH");
        this.instancepath = anInstancepath;
        this.pathAppender = this.instancepath;
        this.instance = anInstance;
        this.objectAppender = this.instance;
        if (this.pathAppender.isReadOnly() || this.objectAppender.isReadOnly()) {
            this.instancepath = (CIMInstancepath)this.instancepath.getReadOnly();
            this.pathAppender = this.instancepath;
            this.instance = (CIMInstance)this.instance.getReadOnly();
            this.objectAppender = this.instance;
            this.makeReadOnly();
        }
    }

    public CIMValueObjectWithPath toWritable() {
        return (CIMValueObjectWithPath)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.pathAppender != null) {
                this.pathAppender.validateCharacters(includeNames);
            }
            if (this.objectAppender != null) {
                this.objectAppender.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnly() {
        this.pathAppender.makeReadOnly();
        this.objectAppender.makeReadOnly();
    }

    boolean isDTDConformant() {
        return this.pathAppender != null && this.objectAppender != null;
    }

    public Object clone() {
        return this.clone(false, true, true, null);
    }

    public Object clone(boolean includeQualifiers) {
        return this.clone(false, includeQualifiers, true, null);
    }

    public Object clone(boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, CanonicalizedStrings propertyList) {
        CIMValueObjectWithPath clone = (CIMValueObjectWithPath)super.clone();
        if (this.theClass != null) {
            clone.theClass = (CIMClass)this.theClass.clone(localOnly, includeQualifiers, includeClassOrigin, propertyList);
            clone.objectAppender = clone.theClass;
        } else if (this.instance != null) {
            clone.instance = (CIMInstance)this.instance.clone(localOnly, includeQualifiers, includeClassOrigin, propertyList);
            clone.objectAppender = clone.instance;
        }
        if (this.instancepath != null) {
            clone.instancepath = (CIMInstancepath)this.instancepath.clone();
            clone.pathAppender = clone.instancepath;
        } else if (this.classpath != null) {
            clone.classpath = (CIMClasspath)this.classpath.clone();
            clone.pathAppender = clone.classpath;
        }
        return clone;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setClasspath(CIMClasspath aClasspath) {
        this.checkNonNull(aClasspath, "CLASSPATH");
        this.checkWritable();
        this.classpath = aClasspath.toWritable();
        this.pathAppender = this.classpath;
        this.instance = null;
        this.instancepath = null;
    }

    public void setClass(CIMClass aClass) {
        this.checkNonNull(aClass, "CLASS");
        this.checkWritable();
        this.theClass = aClass.toWritable();
        this.objectAppender = this.theClass;
        this.instance = null;
        this.instancepath = null;
    }

    public void setInstancepath(CIMInstancepath anInstancepath) {
        this.checkNonNull(anInstancepath, "INSTANCEPATH");
        this.checkWritable();
        this.instancepath = anInstancepath.toWritable();
        this.pathAppender = this.instancepath;
        this.classpath = null;
        this.theClass = null;
    }

    public void setInstance(CIMInstance anInstance) {
        this.checkNonNull(anInstance, "INSTANCE");
        this.checkWritable();
        this.instance = anInstance.toWritable();
        this.objectAppender = this.instance;
        this.classpath = null;
        this.theClass = null;
    }

    void addClasspath(CIMClasspath aClasspath) throws ItemConstructionExcp {
        if (this.pathAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aClasspath, this.pathAppender);
        }
        if (this.instance != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aClasspath, this.instance);
        }
        this.setClasspath(aClasspath);
    }

    void addClass(CIMClass aClass) throws ItemConstructionExcp {
        if (this.objectAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aClass, this.objectAppender);
        }
        if (this.instance != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aClass, this.instance);
        }
        this.setClass(aClass);
    }

    void addInstancepath(CIMInstancepath anInstancepath) throws ItemConstructionExcp {
        if (this.pathAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, anInstancepath, this.pathAppender);
        }
        if (this.theClass != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, anInstancepath, this.theClass);
        }
        this.setInstancepath(anInstancepath);
    }

    void addInstance(CIMInstance anInstance) throws ItemConstructionExcp {
        if (this.objectAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, anInstance, this.objectAppender);
        }
        if (this.theClass != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, anInstance, this.theClass);
        }
        this.setInstance(anInstance);
    }

    public CIMClasspath getClasspath() {
        return this.classpath;
    }

    public CIMInstancepath getInstancepath() {
        return this.instancepath;
    }

    public boolean equalsName(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj instanceof CIMValueObjectWithPath) {
            return this.toString().equals(((CIMValueObjectWithPath)aObj).toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equalsName(String aString) {
        if (this.instancepath != null) {
            CIMInstancepath cmpInstancePath;
            try {
                cmpInstancePath = CIMFactory.createInstancepathFromString(aString);
            }
            catch (LcrException lcre) {
                return false;
            }
            return cmpInstancePath.toString().equals(this.toString());
        }
        if (this.classpath != null) {
            CIMClasspath cmpClassPath;
            try {
                cmpClassPath = CIMFactory.createClasspathFromString(aString);
            }
            catch (LcrException lcre) {
                return false;
            }
            return cmpClassPath.toString().equals(this.toString());
        }
        return false;
    }

    public String toDisplayString() {
        return this.toString(false);
    }

    public String toString() {
        return this.toString(true);
    }

    String toString(boolean comparable) {
        if (this.classpath != null) {
            return this.classpath.toString(comparable);
        }
        if (this.instancepath != null) {
            return this.instancepath.toString(comparable);
        }
        return "";
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.pathAppender, this.objectAppender, indent);
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMValueObjectWithPath)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMValueObjectWithPath source = (CIMValueObjectWithPath)sourceItem;
        if (this.theClass != null && source.theClass != null) {
            this.theClass.merge(source.theClass);
        } else if (this.instance != null && source.instance != null) {
            this.instance.merge(source.instance);
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addValueObjectWithPath(this);
    }

    public CIMClass getCimClass() {
        return this.theClass;
    }

    public CIMInstance getInstance() {
        return this.instance;
    }

    public CIMInstancename getInstancename() {
        return this.instancepath == null ? null : this.instancepath.getInstancename();
    }

    public ICIMObject getContainedObject() {
        if (this.theClass != null) {
            return this.theClass;
        }
        return this.instance;
    }

    public CIMHost getHost() {
        CIMNamespacepath nsp = this.getNamespacepath();
        return nsp == null ? null : nsp.getHost();
    }

    public String getHostname() {
        CIMHost host = this.getHost();
        return host == null ? "" : host.toString();
    }

    public CIMNamespacepath getNamespacepath() {
        if (this.classpath != null) {
            return this.classpath.getNamespacepath();
        }
        if (this.instancepath != null) {
            return this.instancepath.getNamespacepath();
        }
        return null;
    }

    public CIMLocalnamespacepath getLocalnamespacepath() {
        CIMNamespacepath nsp;
        if (this.classpath != null && (nsp = this.classpath.getNamespacepath()) != null) {
            return nsp.getLocalnamespacepath();
        }
        if (this.instancepath != null && (nsp = this.instancepath.getNamespacepath()) != null) {
            return nsp.getLocalnamespacepath();
        }
        return null;
    }
}

