/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CanonicalizedStrings;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMObject;
import com.sap.lcr.api.cim.ICIMObjectContainer;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;

public class CIMValueObject
extends CIMItem
implements ICIMObjectContainer {
    public static final String DTD_NAME = "VALUE.OBJECT";
    private CIMClass theClass;
    private CIMInstance instance;
    private ICIMItem xmlAppender;

    protected CIMValueObject() {
    }

    protected CIMValueObject(CIMClass aCIMClass) {
        this.checkNonNull(aCIMClass, "CLASS");
        this.theClass = aCIMClass;
        this.xmlAppender = this.theClass;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMValueObject(CIMInstance aCIMInstance) {
        this.checkNonNull(aCIMInstance, "INSTANCE");
        this.instance = aCIMInstance;
        this.xmlAppender = this.instance;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMValueObject(ICIMObject object) {
        this.xmlAppender = object;
        if (object instanceof CIMClass) {
            this.theClass = (CIMClass)object;
        } else {
            this.instance = (CIMInstance)object;
        }
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    private void reinit() {
        this.checkWritable();
        this.theClass = null;
        this.instance = null;
        this.xmlAppender = null;
    }

    public CIMValueObject toWritable() {
        return (CIMValueObject)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.xmlAppender != null) {
                this.xmlAppender.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnly() {
        if (this.xmlAppender != null) {
            this.xmlAppender.makeReadOnly();
        }
    }

    boolean isDTDConformant() {
        return this.xmlAppender != null;
    }

    public Object clone() {
        return this.clone(false, true, true, null);
    }

    public Object clone(boolean includeQualifiers) {
        return this.clone(false, includeQualifiers, true, null);
    }

    public Object clone(boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, CanonicalizedStrings propertyList) {
        CIMValueObject clone = (CIMValueObject)super.clone();
        if (this.theClass != null) {
            clone.theClass = (CIMClass)this.theClass.clone(localOnly, includeQualifiers, includeClassOrigin, propertyList);
            clone.xmlAppender = clone.theClass;
        } else if (this.instance != null) {
            clone.instance = (CIMInstance)this.instance.clone(localOnly, includeQualifiers, includeClassOrigin, propertyList);
            clone.xmlAppender = clone.instance;
        }
        return clone;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setClass(CIMClass aClass) {
        this.reinit();
        this.theClass = aClass.toWritable();
        this.xmlAppender = this.theClass;
    }

    public void setInstance(CIMInstance anInstance) {
        this.reinit();
        this.instance = anInstance.toWritable();
        this.xmlAppender = this.instance;
    }

    public void setObject(ICIMObject object) {
        if (object instanceof CIMClass) {
            this.setClass((CIMClass)object);
        } else {
            this.setInstance((CIMInstance)object);
        }
    }

    void addClass(CIMClass aClass) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aClass, this.xmlAppender);
        }
        this.setClass(aClass);
    }

    void addInstance(CIMInstance anInstance) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, anInstance, this.xmlAppender);
        }
        this.setInstance(anInstance);
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.xmlAppender, indent);
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMValueObject)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMValueObject source = (CIMValueObject)sourceItem;
        if (this.theClass != null && source.theClass != null) {
            this.theClass.merge(source.theClass);
        } else if (this.instance != null && source.instance != null) {
            this.instance.merge(source.instance);
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addValueObject(this);
    }

    public CIMClass getCimClass() {
        return this.theClass;
    }

    public CIMInstance getInstance() {
        return this.instance;
    }

    public CIMInstancename getInstancename() {
        return null;
    }

    public ICIMObject getContainedObject() {
        if (this.theClass != null) {
            return this.theClass;
        }
        return this.instance;
    }
}

