/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMScope;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMQualifierDeclaration
extends CIMItemWA
implements ICIMNamedElement {
    public static final String DTD_NAME = "QUALIFIER.DECLARATION";
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cim$CIMQualifierDeclaration == null ? (class$com$sap$lcr$api$cim$CIMQualifierDeclaration = CIMQualifierDeclaration.class$("com.sap.lcr.api.cim.CIMQualifierDeclaration")) : class$com$sap$lcr$api$cim$CIMQualifierDeclaration).getName());
    private String attrName;
    private String attrType;
    private int attrArraySize;
    private boolean attrOverridable = true;
    private boolean attrToSubclass = true;
    private boolean attrToInstance;
    private boolean attrTranslatable;
    private Boolean attrIsArray;
    private CIMScope scope;
    private CIMValue value;
    private CIMValueArray valueArray;
    private ICIMItem valueXmlAppender;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMQualifierDeclaration;

    protected CIMQualifierDeclaration() {
    }

    protected CIMQualifierDeclaration(String name, String type, boolean isArray) throws ItemConstructionExcp {
        this.checkNonNull(name, "NAME");
        this.checkNonNull(type, "TYPE");
        CIMUtil.checkCIMType(type);
        this.attrName = name;
        this.attrType = type;
        this.attrIsArray = isArray ? Boolean.TRUE : Boolean.FALSE;
    }

    public CIMQualifierDeclaration toWritable() {
        return (CIMQualifierDeclaration)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
            }
            if (this.valueXmlAppender != null) {
                this.valueXmlAppender.validateCharacters(includeNames);
            }
            if (this.scope != null) {
                this.scope.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnly() {
        if (this.scope != null) {
            this.scope.makeReadOnly();
        }
        if (this.valueXmlAppender != null) {
            this.valueXmlAppender.makeReadOnly();
        }
    }

    boolean isDTDConformant() {
        return this.attrName != null && this.attrType != null;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public Object clone() {
        CIMQualifierDeclaration clone = (CIMQualifierDeclaration)super.clone();
        if (this.scope != null) {
            clone.scope = (CIMScope)this.scope.clone();
        }
        if (this.valueXmlAppender != null) {
            if (this.value != null) {
                clone.value = (CIMValue)this.value.clone();
                clone.valueXmlAppender = clone.value;
            } else if (this.valueArray != null) {
                clone.valueArray = (CIMValueArray)this.valueArray.clone();
                clone.valueXmlAppender = clone.valueArray;
            }
        }
        return clone;
    }

    public boolean equals(Object obj) {
        block5: {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CIMQualifierDeclaration) {
                try {
                    boolean ok;
                    CIMQualifierDeclaration other = (CIMQualifierDeclaration)obj;
                    boolean bl = ok = this.attrName.equalsIgnoreCase(other.attrName) && this.attrType.equals(other.attrType) && this.attrOverridable == other.attrOverridable && this.attrToSubclass == other.attrToSubclass && this.attrToInstance == other.attrToInstance && this.attrTranslatable == other.attrTranslatable && this.attrArraySize == other.attrArraySize && Util.equals(this.scope, other.scope) && Util.equals(this.value, other.value) && Util.equals(this.valueArray, other.valueArray);
                    if (!ok) {
                        return false;
                    }
                    Boolean thisIsArray = this.attrIsArray == null ? this.isArrayQualifier() : this.attrIsArray;
                    Boolean otherIsArray = other.attrIsArray == null ? other.isArrayQualifier() : other.attrIsArray;
                    return Util.equals(thisIsArray, otherIsArray);
                }
                catch (NullPointerException npe) {
                    if (CIMTraceUtil.traceLevel < 3) break block5;
                    logger.debug("Inconsistent CIMQualifierDeclaration", npe);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.attrName.toLowerCase().hashCode();
    }

    public String getName() {
        return this.attrName;
    }

    public String getType() {
        return this.attrType;
    }

    public void setScope(CIMScope aScope) {
        this.checkWritable();
        this.scope = aScope == null ? null : aScope.toWritable();
    }

    public CIMScope getScope() {
        return this.scope;
    }

    public CIMValue getCIMValue() {
        return this.value;
    }

    public String getValue() {
        return this.value == null ? null : this.value.getStringvalue();
    }

    public CIMValueArray getValueArray() {
        return this.valueArray;
    }

    public void setValue(CIMValue aValue) {
        this.checkWritable();
        this.value = aValue == null ? null : aValue.toWritable();
        this.valueXmlAppender = this.value;
        this.valueArray = null;
    }

    public void setValue(String aValue) {
        this.setValue(CIMFactory.value(aValue));
    }

    public void setValue(boolean aValue) {
        this.setValue(CIMFactory.value(aValue));
    }

    public void setValue(int aValue) {
        this.setValue(CIMFactory.value(aValue));
    }

    public void setValueArray(CIMValueArray aValueArray) {
        this.checkWritable();
        this.value = null;
        this.valueArray = aValueArray == null ? null : aValueArray.toWritable();
        this.valueXmlAppender = this.valueArray;
    }

    public void setFlavors(boolean overridable, boolean toSubclass, boolean toInstance, boolean translatable) {
        this.checkWritable();
        this.attrOverridable = overridable;
        this.attrToSubclass = toSubclass;
        this.attrToInstance = toInstance;
        this.attrTranslatable = translatable;
    }

    public boolean isOverridable() {
        return this.attrOverridable;
    }

    public boolean isToSubclass() {
        return this.attrToSubclass;
    }

    public boolean isToInstance() {
        return this.attrToInstance;
    }

    public boolean isTranslatable() {
        return this.attrTranslatable;
    }

    public void setOverridable(boolean aBoolean) {
        this.checkWritable();
        this.attrOverridable = aBoolean;
    }

    public void setToSubclass(boolean aBoolean) {
        this.checkWritable();
        this.attrToSubclass = aBoolean;
    }

    public void setToInstance(boolean aBoolean) {
        this.checkWritable();
        this.attrToInstance = aBoolean;
    }

    public void setTranslatable(boolean aBoolean) {
        this.checkWritable();
        this.attrTranslatable = aBoolean;
    }

    public Boolean isArray() {
        return this.attrIsArray;
    }

    public Boolean isArrayQualifier() {
        if (this.value != null) {
            return Boolean.FALSE;
        }
        if (this.valueArray != null) {
            return Boolean.TRUE;
        }
        if (this.attrIsArray != null) {
            return this.attrIsArray;
        }
        return null;
    }

    public void setIsArray(Boolean arg) {
        this.checkWritable();
        this.attrIsArray = arg;
    }

    public void setIsArray(boolean arg) {
        this.setIsArray(arg ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getArraySize() {
        return this.attrArraySize;
    }

    public void setArraySize(int arraySize) {
        this.checkWritable();
        this.attrArraySize = arraySize > 0 ? arraySize : 0;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.scope, this.valueXmlAppender, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
        CIMUtil.appendXmlAttributeUnescaped(writer, "TYPE", this.attrType);
        if (!this.attrOverridable) {
            CIMUtil.appendXmlAttribute(writer, "OVERRIDABLE", this.attrOverridable);
        }
        if (!this.attrToSubclass) {
            CIMUtil.appendXmlAttribute(writer, "TOSUBCLASS", this.attrToSubclass);
        }
        if (this.attrToInstance) {
            CIMUtil.appendXmlAttribute(writer, "TOINSTANCE", this.attrToInstance);
        }
        if (this.attrTranslatable) {
            CIMUtil.appendXmlAttribute(writer, "TRANSLATABLE", this.attrTranslatable);
        }
        if (this.attrIsArray != null) {
            CIMUtil.appendXmlAttribute(writer, "ISARRAY", this.attrIsArray);
        }
        if (this.attrArraySize > 0) {
            CIMUtil.appendXmlAttribute(writer, "ARRAYSIZE", this.attrArraySize);
        }
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMQualifierDeclaration)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMQualifierDeclaration source = (CIMQualifierDeclaration)sourceItem;
        if (this.value == null) {
            if (this.valueArray != null) {
                this.valueArray.merge(source.valueArray);
            } else if (source.value != null) {
                this.addValue((CIMValue)source.value.clone());
            } else if (source.valueArray != null) {
                this.addValueArray((CIMValueArray)source.valueArray.clone());
            }
        }
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("NAME".equals(name)) {
                this.attrName = value;
            } else if ("TYPE".equals(name)) {
                CIMUtil.checkCIMType(value);
                this.attrType = value;
            } else if ("ISARRAY".equals(name)) {
                boolean bool = CIMUtil.string2boolean(value);
                this.attrIsArray = bool ? Boolean.TRUE : Boolean.FALSE;
            } else if ("ARRAYSIZE".equals(name)) {
                try {
                    this.setArraySize(CIMUtil.toInt(value));
                }
                catch (NumberFormatException nfe) {
                    throw ItemConstructionExcp.createInvalidIntegerAttributeExcp(value, "ARRAYSIZE", this);
                }
            } else if ("OVERRIDABLE".equals(name)) {
                this.attrOverridable = CIMUtil.string2boolean(value);
            } else if ("TOSUBCLASS".equals(name)) {
                this.attrToSubclass = CIMUtil.string2boolean(value);
            } else if ("TOINSTANCE".equals(name)) {
                this.attrToInstance = CIMUtil.string2boolean(value);
            } else if ("TRANSLATABLE".equals(name)) {
                this.attrTranslatable = CIMUtil.string2boolean(value);
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
        if (this.attrType == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("TYPE", this);
        }
    }

    void addScope(CIMScope aScope) throws ItemConstructionExcp {
        if (this.scope != null) {
            throw ItemConstructionExcp.createDuplicateSubelementExcp(this, aScope);
        }
        this.setScope(aScope);
    }

    void addValue(CIMValue aValue) throws ItemConstructionExcp {
        if (this.valueXmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValue, this.valueXmlAppender);
        }
        this.setValue(aValue);
    }

    void addValueArray(CIMValueArray aValueArray) throws ItemConstructionExcp {
        if (this.valueXmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValueArray, this.valueXmlAppender);
        }
        this.setValueArray(aValueArray);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addQualifierDeclaration(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

