/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWAWQ;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMProperties;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.MultiIterator;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMPropertyArray
extends CIMItemWAWQ
implements ICIMProperties {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cim$CIMPropertyArray == null ? (class$com$sap$lcr$api$cim$CIMPropertyArray = CIMPropertyArray.class$("com.sap.lcr.api.cim.CIMPropertyArray")) : class$com$sap$lcr$api$cim$CIMPropertyArray).getName());
    public static final String DTD_NAME = "PROPERTY.ARRAY";
    private String attrName;
    private String attrType;
    private String attrClassOrigin;
    private int attrArraySize;
    private boolean attrPropagated;
    private CIMValueArray valueArray;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMPropertyArray;

    protected CIMPropertyArray() {
    }

    protected CIMPropertyArray(String aCIMName, String aCIMType) throws ItemConstructionExcp {
        this.checkNonNull(aCIMName, "NAME");
        this.checkNonNull(aCIMType, "TYPE");
        CIMUtil.checkCIMType(aCIMType);
        this.attrName = aCIMName;
        this.attrType = aCIMType;
    }

    protected CIMPropertyArray(String aCIMName, String aCIMType, CIMValueArray aValueArray) throws ItemConstructionExcp {
        this.checkNonNull(aCIMName, "NAME");
        this.checkNonNull(aCIMType, "TYPE");
        CIMUtil.checkCIMType(aCIMType);
        this.attrName = aCIMName;
        this.attrType = aCIMType;
        this.valueArray = aValueArray;
        if (this.valueArray != null && this.valueArray.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    public CIMPropertyArray toWritable() {
        return (CIMPropertyArray)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
                this.validateStringForXml(this.attrClassOrigin, "CLASSORIGIN");
            }
            if (this.valueArray != null) {
                this.valueArray.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnlyWOQualifiers() {
        if (this.valueArray != null) {
            this.valueArray.makeReadOnly();
        }
    }

    boolean isDTDConformant() {
        return this.attrName != null && this.attrType != null;
    }

    public Object clone(boolean includeQualifiers) {
        CIMPropertyArray clone = (CIMPropertyArray)super.clone(includeQualifiers);
        if (this.valueArray != null) {
            clone.valueArray = (CIMValueArray)this.valueArray.clone();
        }
        return clone;
    }

    public boolean equals(Object obj) {
        block4: {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CIMPropertyArray) {
                CIMPropertyArray other = (CIMPropertyArray)obj;
                try {
                    return this.attrName.equalsIgnoreCase(other.attrName) && this.attrType.equals(other.attrType) && Util.equals(this.valueArray, other.valueArray) && Util.equalsIgnoreCase(this.attrClassOrigin, other.attrClassOrigin) && this.attrPropagated == other.attrPropagated && this.attrArraySize == other.attrArraySize && this.getQualifiers().equals(other.getQualifiers());
                }
                catch (NullPointerException npe) {
                    if (CIMTraceUtil.traceLevel < 3) break block4;
                    logger.debug("Inconsistent CIMPropertyArray", npe);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.attrName.toLowerCase().hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setValueArray(CIMValueArray aValueArray) {
        this.checkWritable();
        this.valueArray = aValueArray == null ? null : aValueArray.toWritable();
    }

    public int getArraySize() {
        return this.attrArraySize;
    }

    public void setArraySize(int arraySize) {
        this.checkWritable();
        this.attrArraySize = arraySize > 0 ? arraySize : 0;
    }

    public String getType() {
        return this.attrType;
    }

    public void setType(String aType) throws LcrException {
        this.checkWritable();
        if (!CIMUtil.isValidCIMType(aType)) {
            throw new LcrException("Invalid type: " + aType);
        }
        this.attrType = aType;
    }

    public CIMValueArray getValueArray() {
        return this.valueArray;
    }

    public void removeValueArray() {
        this.checkWritable();
        this.valueArray = null;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        MultiIterator subelements = new MultiIterator();
        subelements.addIterator(this.getQualifiers());
        if (this.valueArray != null) {
            subelements.addObject(this.valueArray);
        }
        this.appendXml(writer, DTD_NAME, subelements, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
        CIMUtil.appendXmlAttributeUnescaped(writer, "TYPE", this.attrType);
        if (this.attrClassOrigin != null) {
            CIMUtil.appendXmlAttributeUnescaped(writer, "CLASSORIGIN", this.attrClassOrigin);
        }
        if (this.attrArraySize > 0) {
            CIMUtil.appendXmlAttribute(writer, "ARRAYSIZE", this.attrArraySize);
        }
        if (this.attrPropagated) {
            CIMUtil.appendXmlAttribute(writer, "PROPAGATED", this.attrPropagated);
        }
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMPropertyArray)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMPropertyArray source = (CIMPropertyArray)sourceItem;
        this.mergeQualifiersWritable(source);
        if (this.valueArray == null) {
            if (source.valueArray != null) {
                this.addValueArray((CIMValueArray)source.valueArray.clone());
            }
        } else {
            this.valueArray.merge(source.valueArray);
        }
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("NAME".equals(name)) {
                this.attrName = value;
            } else if ("TYPE".equals(name)) {
                CIMUtil.checkCIMType(value);
                this.attrType = value;
            } else if ("CLASSORIGIN".equals(name)) {
                this.attrClassOrigin = value;
            } else if ("PROPAGATED".equals(name)) {
                this.attrPropagated = CIMUtil.string2boolean(value);
            } else if ("ARRAYSIZE".equals(name)) {
                try {
                    this.setArraySize(CIMUtil.toInt(value));
                }
                catch (NumberFormatException nfe) {
                    throw ItemConstructionExcp.createInvalidIntegerAttributeExcp(value, "ARRAYSIZE", this);
                }
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
        if (this.attrType == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("TYPE", this);
        }
    }

    void addValueArray(CIMValueArray aValueArray) throws ItemConstructionExcp {
        if (this.valueArray != null) {
            throw ItemConstructionExcp.createDuplicateSubelementExcp(this, aValueArray);
        }
        this.setValueArray(aValueArray);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addPropertyArray(this);
    }

    public String getName() {
        return this.attrName;
    }

    public void setName(String name) {
        this.checkWritable();
        this.attrName = name;
    }

    public String getClassOrigin() {
        return this.attrClassOrigin;
    }

    public void setClassOrigin(String anOrigin) {
        this.checkWritable();
        this.attrClassOrigin = anOrigin;
    }

    public boolean isPropagated() {
        return this.attrPropagated;
    }

    public void setPropagated(boolean aBoolean) {
        this.checkWritable();
        this.attrPropagated = aBoolean;
    }

    public boolean isRequired() {
        String required = this.getQualifierValue("Required");
        return "true".equalsIgnoreCase(required);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

