/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWAWQ;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMKeyProperties;
import com.sap.lcr.api.cim.ICIMProperties;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.MultiIterator;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMProperty
extends CIMItemWAWQ
implements ICIMProperties,
ICIMKeyProperties {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cim$CIMProperty == null ? (class$com$sap$lcr$api$cim$CIMProperty = CIMProperty.class$("com.sap.lcr.api.cim.CIMProperty")) : class$com$sap$lcr$api$cim$CIMProperty).getName());
    public static final String DTD_NAME = "PROPERTY";
    private String attrName;
    private String attrType;
    private String attrClassOrigin;
    private boolean attrPropagated;
    private CIMValue value;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMProperty;

    protected CIMProperty() {
    }

    protected CIMProperty(String aCIMName, String aCIMType) throws ItemConstructionExcp {
        this.checkNonNull(aCIMName, "NAME");
        this.checkNonNull(aCIMType, "TYPE");
        CIMUtil.checkCIMType(aCIMType);
        this.attrName = aCIMName;
        this.attrType = aCIMType;
    }

    protected CIMProperty(String aCIMName, String aCIMType, CIMValue aValue) throws ItemConstructionExcp {
        this(aCIMName, aCIMType);
        this.value = aValue;
        if (this.value != null && this.value.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMProperty(String aCIMName, String aCIMType, String aValue) throws ItemConstructionExcp {
        this(aCIMName, aCIMType, aValue == null ? null : CIMFactory.value(aValue));
    }

    public CIMProperty toWritable() {
        return (CIMProperty)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
                this.validateStringForXml(this.attrClassOrigin, "CLASSORIGIN");
            }
            if (this.value != null) {
                this.value.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnlyWOQualifiers() {
        if (this.value != null) {
            this.value.makeReadOnly();
        }
    }

    boolean isDTDConformant() {
        return this.attrName != null && this.attrType != null;
    }

    public Object clone(boolean includeQualifiers) {
        CIMProperty clone = (CIMProperty)super.clone(includeQualifiers);
        if (this.value != null) {
            clone.value = (CIMValue)this.value.clone();
        }
        return clone;
    }

    public boolean equals(Object obj) {
        block4: {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CIMProperty) {
                CIMProperty other = (CIMProperty)obj;
                try {
                    return this.attrName.equalsIgnoreCase(other.attrName) && this.attrType.equals(other.attrType) && Util.equals(this.value, other.value) && Util.equalsIgnoreCase(this.attrClassOrigin, other.attrClassOrigin) && this.attrPropagated == other.attrPropagated && this.getQualifiers().equals(other.getQualifiers());
                }
                catch (NullPointerException npe) {
                    if (CIMTraceUtil.traceLevel < 3) break block4;
                    logger.debug("Inconsistent CIMProperty", npe);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.attrName.toLowerCase().hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void removeValue() {
        this.checkWritable();
        this.value = null;
    }

    public void setValue(CIMValue aValue) {
        this.checkWritable();
        this.value = aValue == null ? null : aValue.toWritable();
    }

    public void setValue(String aValue) {
        this.setValue(aValue == null ? null : CIMFactory.value(aValue));
    }

    public void setValue(int aValue) {
        this.setValue(CIMFactory.value(aValue));
    }

    public String getType() {
        return this.attrType;
    }

    public void setType(String aType) throws LcrException {
        this.checkWritable();
        if (!CIMUtil.isValidCIMType(aType)) {
            throw new LcrException("Invalid type: " + aType);
        }
        this.attrType = aType;
    }

    public String getValue() {
        if (this.value != null) {
            return this.value.getStringvalue();
        }
        return null;
    }

    public CIMValue getCIMValue() {
        return this.value;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        MultiIterator subelements = new MultiIterator();
        subelements.addIterator(this.getQualifiers());
        if (this.value != null) {
            subelements.addObject(this.value);
        }
        this.appendXml(writer, DTD_NAME, subelements, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
        CIMUtil.appendXmlAttributeUnescaped(writer, "TYPE", this.attrType);
        if (this.attrClassOrigin != null) {
            CIMUtil.appendXmlAttributeUnescaped(writer, "CLASSORIGIN", this.attrClassOrigin);
        }
        if (this.attrPropagated) {
            CIMUtil.appendXmlAttribute(writer, "PROPAGATED", this.attrPropagated);
        }
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMProperty)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMProperty source = (CIMProperty)sourceItem;
        this.mergeQualifiersWritable(source);
        if (this.value == null && source.value != null) {
            this.addValue((CIMValue)source.value.clone());
        }
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("NAME".equals(name)) {
                this.attrName = value;
            } else if ("TYPE".equals(name)) {
                CIMUtil.checkCIMType(value);
                this.attrType = value;
            } else if ("CLASSORIGIN".equals(name)) {
                this.attrClassOrigin = value;
            } else if ("PROPAGATED".equals(name)) {
                this.attrPropagated = CIMUtil.string2boolean(value);
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
        if (this.attrType == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("TYPE", this);
        }
    }

    void addValue(CIMValue aValue) throws ItemConstructionExcp {
        if (this.value != null) {
            throw ItemConstructionExcp.createDuplicateSubelementExcp(this, aValue);
        }
        this.setValue(aValue);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addProperty(this);
    }

    public String getName() {
        return this.attrName;
    }

    public void setName(String name) {
        this.checkWritable();
        this.attrName = name;
    }

    public String getClassOrigin() {
        return this.attrClassOrigin;
    }

    public void setClassOrigin(String aClassOrigin) {
        this.checkWritable();
        this.attrClassOrigin = aClassOrigin;
    }

    public boolean isPropagated() {
        return this.attrPropagated;
    }

    public void setPropagated(boolean aBoolean) {
        this.checkWritable();
        this.attrPropagated = aBoolean;
    }

    public boolean isRequired() {
        if (this.isKeyProperty()) {
            return true;
        }
        String required = this.getQualifierValue("Required");
        return "true".equalsIgnoreCase(required);
    }

    public boolean isKeyProperty() {
        String key = this.getQualifierValue("Key");
        return "true".equalsIgnoreCase(key);
    }

    public void declareAsKey() {
        this.checkWritable();
        this.addQualifier(CIMFactory.qualifier("Key", true));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

