/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.CIMValueRefarray;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMParamValue
extends CIMItemWA
implements ICIMNamedElement {
    public static final String DTD_NAME = "PARAMVALUE";
    private String attrName;
    private CIMValue value;
    private CIMValueReference valueReference;
    private CIMValueArray valueArray;
    private CIMValueRefarray valueRefarray;
    private ICIMItem xmlAppender;

    protected CIMParamValue() {
    }

    protected CIMParamValue(String aCIMName) {
        this.checkNonNull(aCIMName, "NAME");
        this.attrName = aCIMName;
    }

    protected CIMParamValue(String aCIMName, CIMValue aValue) {
        this(aCIMName);
        this.value = aValue;
        this.xmlAppender = this.value;
        if (this.xmlAppender != null && this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMParamValue(String aCIMName, CIMValueReference aValueReference) {
        this(aCIMName);
        this.valueReference = aValueReference;
        this.xmlAppender = this.valueReference;
        if (this.xmlAppender != null && this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMParamValue(String aCIMName, CIMValueArray aValueArray) {
        this(aCIMName);
        this.valueArray = aValueArray;
        this.xmlAppender = this.valueArray;
        if (this.xmlAppender != null && this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMParamValue(String aCIMName, CIMValueRefarray aValueRefarray) {
        this(aCIMName);
        this.valueRefarray = aValueRefarray;
        this.xmlAppender = this.valueRefarray;
        if (this.xmlAppender != null && this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    private void reinit() {
        this.checkWritable();
        this.value = null;
        this.valueReference = null;
        this.valueArray = null;
        this.valueRefarray = null;
        this.xmlAppender = null;
    }

    public CIMParamValue toWritable() {
        return (CIMParamValue)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
            }
            if (this.xmlAppender != null) {
                this.xmlAppender.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnly() {
        if (this.xmlAppender != null) {
            this.xmlAppender.makeReadOnly();
        }
    }

    boolean isDTDConformant() {
        return this.attrName != null;
    }

    public Object clone() {
        CIMParamValue clone = (CIMParamValue)super.clone();
        if (this.value != null) {
            clone.value = (CIMValue)this.value.clone();
            clone.xmlAppender = clone.value;
        } else if (this.valueArray != null) {
            clone.valueArray = (CIMValueArray)this.valueArray.clone();
            clone.xmlAppender = clone.valueArray;
        } else if (this.valueReference != null) {
            clone.valueReference = (CIMValueReference)this.valueReference.clone();
            clone.xmlAppender = clone.valueReference;
        } else if (this.valueRefarray != null) {
            clone.valueRefarray = (CIMValueRefarray)this.valueRefarray.clone();
            clone.xmlAppender = clone.valueRefarray;
        }
        return clone;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public String getName() {
        return this.attrName;
    }

    public void setValue(CIMValue aValue) {
        this.reinit();
        this.value = aValue;
        this.xmlAppender = this.value;
        if (this.xmlAppender != null) {
            this.xmlAppender = (ICIMItem)this.xmlAppender.getWritable();
        }
    }

    public void setValueReference(CIMValueReference aValueReference) {
        this.reinit();
        this.valueReference = aValueReference;
        this.xmlAppender = this.valueReference;
        if (this.xmlAppender != null) {
            this.xmlAppender = (ICIMItem)this.xmlAppender.getWritable();
        }
    }

    public void setValueArray(CIMValueArray aValueArray) {
        this.reinit();
        this.valueArray = aValueArray;
        this.xmlAppender = this.valueArray;
        if (this.xmlAppender != null) {
            this.xmlAppender = (ICIMItem)this.xmlAppender.getWritable();
        }
    }

    public void setValueRefarray(CIMValueRefarray aValueRefarray) {
        this.reinit();
        this.valueRefarray = aValueRefarray;
        this.xmlAppender = this.valueRefarray;
        if (this.xmlAppender != null) {
            this.xmlAppender = (ICIMItem)this.xmlAppender.getWritable();
        }
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.xmlAppender, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (!"NAME".equals(name)) {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            this.attrName = value;
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
    }

    void addValue(CIMValue aValue) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValue, this.xmlAppender);
        }
        this.setValue(aValue);
    }

    void addValueReference(CIMValueReference aValueReference) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValueReference, this.xmlAppender);
        }
        this.setValueReference(aValueReference);
    }

    void addValueArray(CIMValueArray aValueArray) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValueArray, this.xmlAppender);
        }
        this.setValueArray(aValueArray);
    }

    void addValueRefarray(CIMValueRefarray aValueRefarray) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValueRefarray, this.xmlAppender);
        }
        this.setValueRefarray(aValueRefarray);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addParamValue(this);
    }
}

