/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMHost;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimname.CIMObjectReference;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;

public class CIMNamespacepath
extends CIMItem {
    public static final String DTD_NAME = "NAMESPACEPATH";
    private CIMHost host;
    private CIMLocalnamespacepath localnamespacepath;
    private String toStringResult;

    protected CIMNamespacepath() {
    }

    protected CIMNamespacepath(CIMHost aHost, CIMLocalnamespacepath aLocalnamespacepath) {
        this.checkNonNull(aHost, "HOST");
        this.checkNonNull(aLocalnamespacepath, "LOCALNAMESPACEPATH");
        this.host = aHost;
        this.localnamespacepath = aLocalnamespacepath;
        if (this.host.isReadOnly() || aLocalnamespacepath.isReadOnly()) {
            this.host = (CIMHost)this.host.getReadOnly();
            this.localnamespacepath = (CIMLocalnamespacepath)this.localnamespacepath.getReadOnly();
            this.makeReadOnly();
        }
    }

    protected CIMNamespacepath(String aHost, CIMLocalnamespacepath aLocalnamespacepath) {
        this.checkNonNull(aHost, "HOST");
        this.checkNonNull(aLocalnamespacepath, "LOCALNAMESPACEPATH");
        this.host = CIMFactory.host(aHost);
        this.localnamespacepath = aLocalnamespacepath;
        if (aLocalnamespacepath.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    public CIMNamespacepath toWritable() {
        return (CIMNamespacepath)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        this.host.makeReadOnly();
        this.localnamespacepath.makeReadOnly();
    }

    boolean isDTDConformant() {
        return this.host != null && this.localnamespacepath != null;
    }

    public Object clone() {
        CIMNamespacepath clone = (CIMNamespacepath)super.clone();
        clone.toStringResult = null;
        if (this.host != null) {
            clone.host = (CIMHost)this.host.clone();
        }
        if (this.localnamespacepath != null) {
            clone.localnamespacepath = (CIMLocalnamespacepath)this.localnamespacepath.clone();
        }
        return clone;
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj instanceof CIMNamespacepath) {
            CIMNamespacepath nsp = (CIMNamespacepath)aObj;
            return Util.equals(this.host, nsp.host) && Util.equals(this.localnamespacepath, nsp.localnamespacepath);
        }
        return false;
    }

    public boolean equals(String aNamespacepath) {
        if (aNamespacepath == null) {
            return false;
        }
        try {
            return this.equals(CIMFactory.createNamespacepathFromString(aNamespacepath));
        }
        catch (LcrException ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setHost(CIMHost aHost) {
        this.checkNonNull(aHost, "HOST");
        this.checkWritable();
        this.host = aHost.toWritable();
    }

    public void setHost(String aHost) {
        this.checkNonNull(aHost, "HOST");
        this.checkWritable();
        this.host = CIMFactory.host(aHost);
    }

    public void setLocalnamespacepath(CIMLocalnamespacepath aLocalnamespacepath) {
        this.checkNonNull(aLocalnamespacepath, "LOCALNAMESPACEPATH");
        this.checkWritable();
        this.localnamespacepath = aLocalnamespacepath.toWritable();
    }

    void addHost(CIMHost aHost) throws ItemConstructionExcp {
        if (this.host != null) {
            throw ItemConstructionExcp.createDuplicateSubelementExcp(this, aHost);
        }
        this.setHost(aHost);
    }

    void addLocalnamespacepath(CIMLocalnamespacepath aLocalnamespacepath) throws ItemConstructionExcp {
        if (this.localnamespacepath != null) {
            throw ItemConstructionExcp.createDuplicateSubelementExcp(this, aLocalnamespacepath);
        }
        this.setLocalnamespacepath(aLocalnamespacepath);
    }

    public CIMHost getHost() {
        return this.host;
    }

    public String getHostname() {
        return this.host == null ? "" : this.host.toString();
    }

    public CIMLocalnamespacepath getLocalnamespacepath() {
        return this.localnamespacepath;
    }

    public String toDisplayString() {
        return this.toString(false);
    }

    public String toString() {
        return this.toString(true);
    }

    String toString(boolean comparable) {
        String result;
        if (comparable && this.toStringResult != null) {
            return this.toStringResult;
        }
        if (this.localnamespacepath == null || this.host == null) {
            result = "";
        } else {
            String strHost = this.host.toString(comparable);
            String strLnsp = this.localnamespacepath.toString(comparable);
            StringBuffer buf = new StringBuffer(strHost.length() + strLnsp.length() + 1 + "//".length());
            result = buf.append("//").append(strHost).append('/').append(strLnsp).toString();
        }
        if (comparable && this.isReadOnly()) {
            this.toStringResult = result;
        }
        return result;
    }

    public void addToCIMObjectReference(CIMObjectReference reference) {
        this.host.addToCIMObjectReference(reference);
        this.localnamespacepath.addToCIMObjectReference(reference);
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.host, this.localnamespacepath, indent);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addNamespacepath(this);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.host != null) {
                this.host.validateCharacters(includeNames);
            }
            if (this.localnamespacepath != null) {
                this.localnamespacepath.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }
}

