/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMError;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMParamValue;
import com.sap.lcr.api.cim.CIMParamValueList;
import com.sap.lcr.api.cim.CIMReturnValue;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMMethodResponse
extends CIMItemWA
implements ICIMNamedElement {
    public static final String DTD_NAME = "METHODRESPONSE";
    private String attrName;
    private CIMError error;
    private CIMReturnValue returnValue;
    private CIMParamValueList paramValueList;

    protected CIMMethodResponse() {
        this.paramValueList = CIMFactory.paramValueList();
    }

    protected CIMMethodResponse(String aCIMName) {
        this();
        this.checkNonNull(aCIMName, "NAME");
        this.attrName = aCIMName;
    }

    protected CIMMethodResponse(String aCIMName, CIMError aCIMError) {
        this(aCIMName);
        this.error = aCIMError;
        if (this.error != null && this.error.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMMethodResponse(String aCIMName, CIMReturnValue aCIMReturnValue) {
        this(aCIMName);
        this.returnValue = aCIMReturnValue;
        if (this.returnValue != null && this.returnValue.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMMethodResponse(String aCIMName, CIMParamValueList aCIMParamValueList) {
        this.checkNonNull(aCIMName, "NAME");
        this.attrName = aCIMName;
        CIMParamValueList cIMParamValueList = this.paramValueList = aCIMParamValueList == null ? CIMFactory.paramValueList() : aCIMParamValueList;
        if (this.paramValueList.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMMethodResponse(String aCIMName, CIMReturnValue aCIMReturnValue, CIMParamValueList aCIMParamValueList) {
        this.checkNonNull(aCIMName, "NAME");
        this.attrName = aCIMName;
        this.paramValueList = aCIMParamValueList == null ? CIMFactory.paramValueList() : aCIMParamValueList;
        this.returnValue = aCIMReturnValue;
        if (this.paramValueList.isReadOnly() || this.returnValue != null && this.returnValue.isReadOnly()) {
            this.paramValueList = (CIMParamValueList)this.paramValueList.getReadOnly();
            if (this.returnValue != null) {
                this.returnValue = (CIMReturnValue)this.returnValue.getReadOnly();
            }
            this.makeReadOnly();
        }
    }

    public CIMMethodResponse toWritable() {
        return (CIMMethodResponse)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        if (this.error != null) {
            this.error.makeReadOnly();
        }
        if (this.returnValue != null) {
            this.returnValue.makeReadOnly();
        }
        this.paramValueList.makeReadOnly();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
            }
            if (this.error != null) {
                this.error.validateCharacters(includeNames);
            }
            if (this.returnValue != null) {
                this.returnValue.validateCharacters(includeNames);
            }
            this.paramValueList.validateCharacters(includeNames);
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    boolean isDTDConformant() {
        return this.attrName != null;
    }

    public Object clone() {
        CIMMethodResponse clone = (CIMMethodResponse)super.clone();
        clone.paramValueList = (CIMParamValueList)this.paramValueList.clone();
        if (this.error != null) {
            clone.error = (CIMError)this.error.clone();
        } else if (this.returnValue != null) {
            clone.returnValue = (CIMReturnValue)this.returnValue.clone();
        }
        return clone;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public String getName() {
        return this.attrName;
    }

    public void setError(CIMError anError) {
        this.checkWritable();
        this.error = anError.toWritable();
        this.returnValue = null;
        this.paramValueList.clear();
    }

    public void setReturnValue(CIMReturnValue aReturnValue) {
        this.checkWritable();
        if (aReturnValue != null) {
            aReturnValue = aReturnValue.toWritable();
        }
        this.returnValue = aReturnValue;
        this.error = null;
    }

    public void addParamValue(CIMParamValue aParamValue) {
        this.checkWritable();
        this.error = null;
        this.paramValueList.add(aParamValue);
    }

    public CIMError getError() {
        return this.error;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        if (this.error != null) {
            this.appendXml(writer, DTD_NAME, this.error, indent);
        } else {
            this.appendXml(writer, DTD_NAME, this.returnValue, this.paramValueList, indent);
        }
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (!"NAME".equals(name)) {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            this.attrName = value;
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
    }

    void addError(CIMError anError) throws ItemConstructionExcp {
        if (this.returnValue != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, anError, this.returnValue);
        }
        if (this.paramValueList.size() != 0) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, anError, this.paramValueList.get(0));
        }
        this.setError(anError);
    }

    void addReturnValue(CIMReturnValue aReturnValue) throws ItemConstructionExcp {
        if (this.returnValue != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aReturnValue, this.returnValue);
        }
        if (this.error != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aReturnValue, this.error);
        }
        this.setReturnValue(aReturnValue);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addMethodResponse(this);
    }
}

