/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMKeyValue
extends CIMItemWA {
    public static final String DTD_NAME = "KEYVALUE";
    private String keyValue = "";
    private String attrValueType = "string";

    protected CIMKeyValue() {
    }

    protected CIMKeyValue(String aKeyValue) {
        this.checkNonNull(aKeyValue, "Value");
        this.keyValue = aKeyValue.trim();
    }

    protected CIMKeyValue(String aKeyValue, String type) throws ItemConstructionExcp {
        this(aKeyValue);
        this.setValueType(type);
    }

    protected CIMKeyValue(int aKeyValue) {
        this(Integer.toString(aKeyValue));
        this.setValuetypeNumeric();
    }

    protected CIMKeyValue(boolean aKeyValue) {
        this(aKeyValue ? "true" : "false");
        this.setValuetypeBoolean();
    }

    public CIMKeyValue toWritable() {
        return (CIMKeyValue)this.getWritable();
    }

    void makeSubelementsReadOnly() {
    }

    boolean isDTDConformant() {
        return true;
    }

    public int hashCode() {
        return this.keyValue.hashCode() + 31 * this.attrValueType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CIMKeyValue) {
            CIMKeyValue other = (CIMKeyValue)obj;
            return this.keyValue.equals(other.keyValue) && this.attrValueType.equals(other.attrValueType);
        }
        return false;
    }

    public boolean equals(String value) {
        return this.keyValue.equals(value);
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setValuetypeString() {
        this.checkWritable();
        this.attrValueType = "string";
    }

    public void setValuetypeBoolean() {
        this.checkWritable();
        this.attrValueType = "boolean";
    }

    public void setValuetypeNumeric() {
        this.checkWritable();
        this.attrValueType = "numeric";
    }

    public void setValueType(String type) throws ItemConstructionExcp {
        this.checkWritable();
        if ("string".equals(type)) {
            this.attrValueType = "string";
        } else if ("boolean".equals(type)) {
            this.attrValueType = "boolean";
        } else if ("numeric".equals(type)) {
            this.attrValueType = "numeric";
        } else {
            throw new ItemConstructionExcp(10, "Illegal VALUETYPE for KEYVALUE: " + type);
        }
    }

    public String getValue() {
        return this.keyValue;
    }

    public String toString() {
        return this.keyValue;
    }

    public String getType() {
        return this.attrValueType;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.keyValue, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        if (!"string".equals(this.attrValueType)) {
            CIMUtil.appendXmlAttributeUnescaped(writer, "VALUETYPE", this.attrValueType);
        }
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (!"VALUETYPE".equals(name)) {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            this.setValueType(value);
            ++i;
        }
    }

    void setCharacters(String nextChunk) {
        this.keyValue = this.keyValue + nextChunk;
    }

    void trim() {
        this.keyValue = this.keyValue.trim();
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        this.trim();
        parentItem.addKeyValue(this);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        this.validateStringForXml(this.keyValue, DTD_NAME);
    }
}

