/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMQualifier;
import com.sap.lcr.api.cim.CIMQualifierDeclaration;
import com.sap.lcr.api.cim.CIMQualifierList;
import com.sap.lcr.api.cim.ICIMWithQualifiers;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.util.Iterator;

public abstract class CIMItemWAWQ
extends CIMItemWA
implements ICIMWithQualifiers {
    private CIMQualifierList qualifiers = CIMFactory.qualifierList();

    protected CIMItemWAWQ() {
    }

    void makeSubelementsReadOnly() {
        this.qualifiers.makeReadOnly();
        this.makeSubelementsReadOnlyWOQualifiers();
    }

    abstract void makeSubelementsReadOnlyWOQualifiers();

    public final Object clone() {
        return this.clone(true);
    }

    public Object clone(boolean includeQualifiers) {
        CIMItemWAWQ clone = (CIMItemWAWQ)super.clone();
        clone.qualifiers = includeQualifiers ? (CIMQualifierList)this.qualifiers.clone() : CIMFactory.qualifierList();
        return clone;
    }

    final void mergeQualifiersWritable(CIMItemWAWQ source) throws ItemConstructionExcp {
        Iterator sourceQualIter = source.getQualifiers().iterator();
        while (sourceQualIter.hasNext()) {
            CIMQualifier sourceQualifier = (CIMQualifier)sourceQualIter.next();
            String sourceQualifierName = sourceQualifier.getName();
            CIMQualifier targetQualifier = this.getQualifierByName(sourceQualifierName);
            if (targetQualifier != null) {
                targetQualifier.merge(sourceQualifier);
                continue;
            }
            this.getQualifiers().add((CIMQualifier)sourceQualifier.clone());
        }
    }

    public final void addQualifier(CIMQualifier aQualifier) {
        this.qualifiers.add(aQualifier);
    }

    public final void addQualifier(CIMQualifierDeclaration qualDecl, String value) {
        try {
            CIMQualifier qual = CIMFactory.qualifier(qualDecl.getName(), qualDecl.getType(), value);
            qual.setFlavors(qualDecl.isOverridable(), qualDecl.isToSubclass(), qualDecl.isToInstance(), qualDecl.isTranslatable());
            this.qualifiers.add(qual);
        }
        catch (ItemConstructionExcp ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public final void removeQualifier(String qualifierName) {
        this.qualifiers.remove(qualifierName);
    }

    public final CIMQualifier getQualifierByName(String qualifierName) {
        return this.qualifiers.get(qualifierName);
    }

    public final String getQualifierValue(String qualifierName) {
        CIMQualifier qual = this.qualifiers.get(qualifierName);
        return qual == null ? null : qual.getValue();
    }

    public final CIMQualifierList getQualifiers() {
        return this.qualifiers;
    }

    public final void setQualifiers(CIMQualifierList qualifierList) {
        this.checkWritable();
        this.qualifiers = qualifierList;
    }

    public final Iterator getQualifierIterator() {
        return this.qualifiers.iterator();
    }
}

