/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMConstants;
import com.sap.lcr.api.cim.CIMDeclaration;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMMessage;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMCim
extends CIMItemWA {
    public static final String DTD_NAME = "CIM";
    private String attrCIMVersion = "2.0";
    private String attrDTDVersion = "2.0";
    private CIMMessage message;
    private CIMDeclaration declaration;
    private ICIMItem xmlAppender;

    protected CIMCim() {
    }

    protected CIMCim(String cimVersionIgnored, String dtdVersionIgnored, CIMMessage aCIMMessage) {
        this();
        this.checkNonNull(aCIMMessage, "MESSAGE");
        this.message = aCIMMessage;
        this.xmlAppender = this.message;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMCim(String cimVersionIgnored, String dtdVersionIgnored, CIMDeclaration aCIMDeclaration) {
        this();
        this.checkNonNull(aCIMDeclaration, "DECLARATION");
        this.declaration = aCIMDeclaration;
        this.xmlAppender = this.declaration;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    public CIMCim toWritable() {
        return (CIMCim)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        if (this.xmlAppender != null) {
            this.xmlAppender.makeReadOnly();
        }
    }

    boolean isDTDConformant() {
        return this.xmlAppender != null;
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("CIMVERSION".equals(name)) {
                this.attrCIMVersion = value;
            } else if ("DTDVERSION".equals(name)) {
                this.attrDTDVersion = value;
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
        if (this.attrCIMVersion == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("CIMVERSION", this);
        }
        if (this.attrDTDVersion == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("DTDVERSION", this);
        }
    }

    void addDeclaration(CIMDeclaration declaration) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, declaration, this.xmlAppender);
        }
        this.setDeclaration(declaration);
    }

    void addMessage(CIMMessage message) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, message, this.xmlAppender);
        }
        this.setMessage(message);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        throw new ItemConstructionExcp(4, "CIM must be root element of XML");
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public Object clone() {
        CIMCim clone = (CIMCim)super.clone();
        if (this.message != null) {
            clone.message = (CIMMessage)this.message.clone();
            clone.xmlAppender = clone.message;
        } else if (this.declaration != null) {
            clone.declaration = (CIMDeclaration)this.declaration.clone();
            clone.xmlAppender = clone.declaration;
        }
        return clone;
    }

    public void setDeclaration(CIMDeclaration aDeclaration) {
        this.checkNonNull(aDeclaration, "DECLARATION");
        this.checkWritable();
        this.message = null;
        this.declaration = aDeclaration.toWritable();
        this.xmlAppender = this.declaration;
    }

    public void setMessage(CIMMessage aMessage) {
        this.checkNonNull(aMessage, "MESSAGE");
        this.checkWritable();
        this.message = aMessage.toWritable();
        this.xmlAppender = this.message;
        this.declaration = null;
    }

    public CIMMessage getMessage() {
        return this.message;
    }

    public CIMDeclaration getDeclaration() {
        return this.declaration;
    }

    public String getCIMVersion() {
        return this.attrCIMVersion;
    }

    public String getDTDVersion() {
        return this.attrDTDVersion;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        writer.write("<?xml version=\"1.0\"?>");
        writer.write(CIMConstants.NEWLINE);
        this.appendXml(writer, DTD_NAME, this.xmlAppender, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeEscaped(writer, "CIMVERSION", this.attrCIMVersion);
        CIMUtil.appendXmlAttributeEscaped(writer, "DTDVERSION", this.attrDTDVersion);
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMCim)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMCim source = (CIMCim)sourceItem;
        if (this.xmlAppender != null) {
            this.xmlAppender.merge(source.xmlAppender);
        } else if (source.declaration != null) {
            this.addDeclaration((CIMDeclaration)source.declaration.clone());
        } else if (source.message != null) {
            this.addMessage((CIMMessage)source.message.clone());
        }
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.xmlAppender != null) {
                this.xmlAppender.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }
}

