/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder;

import com.sap.lcr.api.builder.IBuilder;
import com.sap.lcr.api.builder.IBuilderFactory;
import com.sap.lcr.api.builder.IDataQueue;
import com.sap.lcr.api.builder.IDirector;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.LcrException;
import java.util.ArrayList;

public abstract class GenericDirector
implements IDirector {
    protected ArrayList myBuilders = new ArrayList();
    private ArrayList myBuilderFactories = new ArrayList();
    private IDataQueue myDataQueue = null;
    private ArrayList myCIMClients = new ArrayList();

    public synchronized void addBuilders(IBuilderFactory aBuilderFactory) throws LcrException {
        if (this.getBuilders(aBuilderFactory).length == 0) {
            int i = 0;
            while (i < this.myCIMClients.size()) {
                CIMOMHandle nextCIMClient = (CIMOMHandle)this.myCIMClients.get(i);
                this.addBuilderInstance(aBuilderFactory, nextCIMClient);
                ++i;
            }
        } else {
            throw new LcrException("Builders of class " + aBuilderFactory.getBuilderClassName() + " already included.");
        }
        this.myBuilderFactories.add(aBuilderFactory);
    }

    private void addBuilderInstance(IBuilderFactory aBuilderFactory, CIMOMHandle aCIMClient) throws LcrException {
        IBuilder newBuilder = aBuilderFactory.newBuilder(aCIMClient);
        this.myBuilders.add(newBuilder);
    }

    public synchronized void removeBuilders(IBuilderFactory aBuilderFactory) {
        int i = this.myBuilders.size() - 1;
        while (i >= 0) {
            if (this.myBuilders.get(i).getClass().getName().equals(aBuilderFactory.getBuilderClassName())) {
                this.myBuilders.remove(i);
            }
            --i;
        }
        int i2 = this.myBuilderFactories.size() - 1;
        while (i2 >= 0) {
            if (((IBuilderFactory)this.myBuilderFactories.get(i2)).getBuilderClassName().equals(aBuilderFactory.getBuilderClassName())) {
                this.myBuilderFactories.remove(i2);
            }
            --i2;
        }
    }

    public synchronized IBuilder[] getBuilders(IBuilderFactory aBuilderFactory) {
        ArrayList resultList = new ArrayList();
        int i = 0;
        while (i < this.myBuilders.size()) {
            if (this.myBuilders.get(i).getClass().getName().equals(aBuilderFactory.getBuilderClassName())) {
                resultList.add(this.myBuilders.get(i));
            }
            ++i;
        }
        return resultList.toArray(new IBuilder[0]);
    }

    public IDataQueue getDataQueue() {
        return this.myDataQueue;
    }

    public void setDataQueue(IDataQueue aDataQueue) {
        this.myDataQueue = aDataQueue;
    }

    public synchronized void addCIMClient(CIMOMHandle aCIMClient) throws CIMClientException, LcrException {
        boolean found = false;
        String anObjectServer = aCIMClient.getObjectServer();
        int i = 0;
        while (i < this.myCIMClients.size()) {
            CIMOMHandle nextCIMClient = (CIMOMHandle)this.myCIMClients.get(i);
            if (nextCIMClient.getLocalNamespacePath().equals(aCIMClient.getLocalNamespacePath()) && nextCIMClient.getObjectServer().equals(anObjectServer)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.myCIMClients.add(aCIMClient);
            int i2 = 0;
            while (i2 < this.myBuilderFactories.size()) {
                IBuilderFactory nextBuilderFactory = (IBuilderFactory)this.myBuilderFactories.get(i2);
                this.addBuilderInstance(nextBuilderFactory, aCIMClient);
                ++i2;
            }
        }
    }

    public synchronized void removeCIMClient(CIMOMHandle aCIMClient) throws CIMClientException, LcrException {
        String anObjectServer = aCIMClient.getObjectServer();
        int i = this.myCIMClients.size() - 1;
        while (i >= 0) {
            CIMOMHandle nextCIMClient = (CIMOMHandle)this.myCIMClients.get(i);
            if (nextCIMClient.getLocalNamespacePath().equals(aCIMClient.getLocalNamespacePath()) && nextCIMClient.getObjectServer().equals(anObjectServer)) {
                this.myCIMClients.remove(i);
                int j = this.myBuilders.size() - 1;
                while (j >= 0) {
                    IBuilder nextBuilder = (IBuilder)this.myBuilders.get(j);
                    if (nextBuilder.getCIMClient().equals(nextCIMClient)) {
                        this.myBuilders.remove(j);
                    }
                    --j;
                }
            }
            --i;
        }
    }

    public abstract String printStatus();

    public abstract void distributeData() throws LcrException;
}

