/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder;

import com.sap.lcr.api.builder.DeltaElement;
import com.sap.lcr.api.builder.GenericBuilder;
import com.sap.lcr.api.builder.IDelta;
import com.sap.lcr.api.builder.MappingUtility;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMQualifier;
import com.sap.lcr.api.cim.CIMValueNamedInstanceList;
import com.sap.lcr.api.cim.CIMValueObjectWithPathList;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class GenericDeltaBuilder
extends GenericBuilder {
    protected boolean propertiesLocalOnly = false;
    protected boolean deepInheritance = true;
    protected boolean withInstanceQualifiers = false;
    protected boolean withClassOrigin = false;

    protected GenericDeltaBuilder(CIMOMHandle aCIMClient) {
        super(aCIMClient);
    }

    protected void evaluateSyncDelta(DeltaElement obj, boolean merge, IDelta delta) throws LcrException {
        DeltaElement serverObj = this.retrieveObject(obj);
        if (!serverObj.hasInstance()) {
            this.evaluateCreateDelta(obj, delta);
        } else {
            this.evaluateModifyDelta(obj, serverObj, merge, delta);
        }
    }

    protected void evaluateCreateDelta(DeltaElement obj, IDelta delta) throws LcrException {
        obj.setMyOperation(1);
        delta.add(obj);
    }

    protected void evaluateModifyDelta(DeltaElement obj, DeltaElement serverObj, boolean merge, IDelta delta) throws LcrException {
        if (MappingUtility.haveEqualValues(serverObj, obj)) {
            obj.setMyOperation(0);
        } else {
            obj.setMyOperation(2);
            obj.setMergeProperties(merge);
        }
        delta.add(obj);
    }

    protected void evaluateDeleteDelta(DeltaElement obj, IDelta delta) throws LcrException {
        DeltaElement serverObj = this.retrieveObject(obj);
        if (serverObj.getMyInstance() == null) {
            return;
        }
        obj.setMyOperation(4);
        delta.add(obj);
    }

    protected void evaluateRenameDelta(DeltaElement originalObj, DeltaElement resultObj, IDelta delta) throws LcrException {
        resultObj.setMyOperation(5);
        resultObj.setMyOldInstanceName(originalObj.getMyInstanceName());
        resultObj.setMyOldInstance(originalObj.getMyInstance());
        delta.add(resultObj);
    }

    public synchronized Date getModificationDate(DeltaElement obj) throws LcrException {
        DeltaElement obj2;
        CIMInstance inst2;
        CIMQualifier qlf = null;
        CIMInstance inst = obj.getMyInstance();
        if (inst != null) {
            qlf = inst.getQualifierByName("SAP_LastModificationTime");
        }
        if (qlf == null && (inst2 = (obj2 = this.retrieveObjectImpl(obj, this.propertiesLocalOnly, true, this.withClassOrigin)).getMyInstance()) != null) {
            qlf = inst2.getQualifierByName("SAP_LastModificationTime");
        }
        if (qlf == null) {
            throw new LcrException("Modification time qualifier not found in " + obj.getMyInstanceName().toDisplayString());
        }
        Date result = qlf.toDate();
        if (result == null) {
            throw new LcrException("Modification time qualifier has no value in " + obj.getMyInstanceName().toDisplayString());
        }
        return result;
    }

    public DeltaElement retrieveObject(DeltaElement obj) throws LcrException {
        return this.retrieveObjectImpl(obj, this.propertiesLocalOnly, this.withInstanceQualifiers, this.withClassOrigin);
    }

    protected DeltaElement retrieveObjectImpl(DeltaElement obj, boolean localonly, boolean withqlf, boolean withclorg) throws LcrException {
        CIMInstance serverInstance;
        block6: {
            if (obj == null || obj.getMyInstanceName() == null) {
                throw new LcrException("Instance name not defined, unable to retrieve object.");
            }
            serverInstance = null;
            try {
                serverInstance = this.myCIMClient.getInstance(obj.getMyInstanceName(), localonly, withqlf, withclorg, null);
            }
            catch (CIMClientException cce) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    this.getLogger().fine("Client exception during retrieve object " + obj.getMyInstanceName().toDisplayString(), cce);
                }
                throw new LcrException(cce);
            }
            catch (LcrException lce) {
                if (lce.getStatusCode() == 6) break block6;
                if (CIMTraceUtil.traceLevel >= 4) {
                    this.getLogger().fine("LCR exception during retrieve object " + obj.getMyInstanceName().toDisplayString(), lce);
                }
                throw lce;
            }
        }
        return new DeltaElement(obj.getMyInstanceName(), serverInstance);
    }

    public List listObjects(String objClass) throws LcrException {
        return this.listObjectsImpl(objClass, this.propertiesLocalOnly, this.deepInheritance, this.withInstanceQualifiers, this.withClassOrigin);
    }

    protected List listObjectsImpl(String objClass, boolean localonly, boolean deepinherit, boolean withqlf, boolean withclorg) throws LcrException {
        ArrayList<DeltaElement> result = new ArrayList<DeltaElement>();
        if (objClass == null) {
            throw new LcrException("Class undefined in list objects.");
        }
        CIMClassname objClassName = objClass != null ? CIMFactory.classname(objClass) : null;
        try {
            CIMValueNamedInstanceList allObjVNI = this.myCIMClient.enumerateInstances(objClassName, localonly, deepinherit, withqlf, withclorg, null);
            int i = 0;
            while (i < allObjVNI.size()) {
                CIMInstancename nextInstanceName = allObjVNI.get(i).getInstancename();
                CIMInstance nextInstance = allObjVNI.get(i).getInstance();
                if (nextInstanceName != null && nextInstance != null) {
                    result.add(new DeltaElement(nextInstanceName, nextInstance));
                }
                ++i;
            }
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                this.getLogger().fine("Client exception in enumerate instances of class " + objClass, cce);
            }
            throw new LcrException(cce);
        }
        return result;
    }

    public List listReferences(DeltaElement obj, String assocClass) throws LcrException {
        return this.listReferencesImpl(obj, assocClass, null, this.withInstanceQualifiers, this.withClassOrigin);
    }

    protected List listReferencesImpl(DeltaElement obj, String assocClass, String rootRole, boolean withqlf, boolean withclorg) throws LcrException {
        ArrayList<DeltaElement> result = new ArrayList<DeltaElement>();
        if (obj == null || obj.getMyInstanceName() == null) {
            throw new LcrException("Root instance undefined in list references.");
        }
        CIMClassname assocClassName = assocClass != null ? CIMFactory.classname(assocClass) : null;
        try {
            CIMValueObjectWithPathList refVOWPs = this.myCIMClient.references(obj.getMyInstanceName(), assocClassName, rootRole, withqlf, withclorg, null);
            int i = 0;
            while (i < refVOWPs.size()) {
                CIMInstancename nextInstanceName = refVOWPs.get(i).getInstancename();
                CIMInstance nextInstance = refVOWPs.get(i).getInstance();
                if (nextInstanceName != null && nextInstance != null) {
                    result.add(new DeltaElement(nextInstanceName, nextInstance));
                }
                ++i;
            }
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                this.getLogger().fine("Client exception in list references of " + obj.getMyInstanceName().toDisplayString(), cce);
            }
            throw new LcrException(cce);
        }
        return result;
    }

    public List listAssociators(DeltaElement obj, String assocClass, String targetClass) throws LcrException {
        return this.listAssociatorsImpl(obj, assocClass, targetClass, null, null, this.withInstanceQualifiers, this.withClassOrigin);
    }

    protected List listAssociatorsImpl(DeltaElement obj, String assocClass, String memberClass, String rootRole, String memberRole, boolean withqlf, boolean withclorg) throws LcrException {
        ArrayList<DeltaElement> result = new ArrayList<DeltaElement>();
        if (obj == null || obj.getMyInstanceName() == null) {
            throw new LcrException("Root instance undefined in list associators.");
        }
        try {
            CIMClassname assocClassName = assocClass != null ? CIMFactory.classname(assocClass) : null;
            CIMClassname memberClassName = memberClass != null ? CIMFactory.classname(memberClass) : null;
            CIMValueObjectWithPathList assocVOWPs = this.myCIMClient.associators(obj.getMyInstanceName(), assocClassName, memberClassName, rootRole, memberRole, withqlf, withclorg, null);
            int i = 0;
            while (i < assocVOWPs.size()) {
                CIMInstancename nextInstanceName = assocVOWPs.get(i).getInstancename();
                CIMInstance nextInstance = assocVOWPs.get(i).getInstance();
                if (nextInstanceName != null && nextInstance != null) {
                    result.add(new DeltaElement(nextInstanceName, nextInstance));
                }
                ++i;
            }
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                this.getLogger().fine("Client exception in list associators of " + obj.getMyInstanceName().toDisplayString(), cce);
            }
            throw new LcrException(cce);
        }
        return result;
    }
}

