/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder;

import com.sap.lcr.api.builder.DeltaElement;
import com.sap.lcr.api.builder.IDelta;
import com.sap.lcr.api.cim.CIMConstants;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;

public class GenericDelta
implements IDelta {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$builder$GenericDelta == null ? (class$com$sap$lcr$api$builder$GenericDelta = GenericDelta.class$("com.sap.lcr.api.builder.GenericDelta")) : class$com$sap$lcr$api$builder$GenericDelta).getName());
    private static final String printCountsMsgFormat = "{0}{1,number,########} regular elements to be inserted,{0}{2,number,########} regular elements to be updated,{0}{3,number,########} regular elements to be modified,{0}{4,number,########} regular elements to be deleted,{0}{5,number,########} regular elements to be renamed,{0}{6,number,########} regular elements to be untouched.{0}{7,number,########} association elements to be inserted,{0}{8,number,########} association elements to be updated,{0}{9,number,########} association elements to be modified,{0}{10,number,########} association elements to be deleted,{0}{11,number,########} association elements to be renamed,{0}{12,number,########} association elements to be untouched.";
    private ArrayList myChanges = new ArrayList();
    private CIMOMHandle myCIMClient = null;
    private String mySupplierName = null;
    private boolean syncTimeUpdated = false;
    private boolean elementsProcessed = false;
    static /* synthetic */ Class class$com$sap$lcr$api$builder$GenericDelta;

    public GenericDelta(CIMOMHandle aCIMClient) {
        this.myCIMClient = aCIMClient;
    }

    public CIMOMHandle getMyCIMClient() {
        return this.myCIMClient;
    }

    public void add(DeltaElement anElem) {
        int[] currPositions;
        String currQval;
        DeltaElement listElem = (DeltaElement)anElem.clone();
        if (this.mySupplierName != null && (currQval = listElem.getMySupplierName()) == null) {
            listElem.setMySupplierName(this.mySupplierName);
        }
        if ((currPositions = this.indexesOf(listElem)).length == 0) {
            this.myChanges.add(listElem);
        } else {
            this.mergeElement(listElem, currPositions);
        }
    }

    private void mergeElement(DeltaElement anElem, int[] positions) {
        boolean addFinally = true;
        int newOp = anElem.getMyOperation();
        if (newOp == 0 || newOp == 6) {
            addFinally = false;
        }
        int i = 0;
        while (i < positions.length) {
            int nextPosition = positions[i];
            DeltaElement presentElem = (DeltaElement)this.myChanges.get(nextPosition);
            int presentOp = presentElem.getMyOperation();
            block0 : switch (presentOp) {
                case 0: {
                    break;
                }
                case 1: {
                    switch (newOp) {
                        case 1: 
                        case 3: {
                            this.myChanges.set(nextPosition, anElem);
                            addFinally = false;
                            break block0;
                        }
                        case 2: {
                            anElem.setMyOperation(3);
                            this.myChanges.set(nextPosition, anElem);
                            addFinally = false;
                            break block0;
                        }
                        case 4: 
                        case 5: {
                            presentElem.setMyOperation(6);
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (newOp) {
                        case 2: 
                        case 3: {
                            this.myChanges.set(nextPosition, anElem);
                            addFinally = false;
                            break block0;
                        }
                        case 1: {
                            anElem.setMyOperation(3);
                            this.myChanges.set(nextPosition, anElem);
                            addFinally = false;
                            break block0;
                        }
                        case 4: 
                        case 5: {
                            presentElem.setMyOperation(6);
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (newOp) {
                        case 1: 
                        case 2: {
                            anElem.setMyOperation(3);
                            this.myChanges.set(nextPosition, anElem);
                            addFinally = false;
                            break block0;
                        }
                        case 3: {
                            this.myChanges.set(nextPosition, anElem);
                            addFinally = false;
                            break block0;
                        }
                        case 4: 
                        case 5: {
                            presentElem.setMyOperation(6);
                            break block0;
                        }
                    }
                    break;
                }
                case 4: 
                case 5: {
                    switch (newOp) {
                        case 1: 
                        case 2: {
                            anElem.setMyOperation(3);
                            presentElem.setMyOperation(6);
                            break block0;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            presentElem.setMyOperation(6);
                            break block0;
                        }
                    }
                    break;
                }
                case 6: {
                    break;
                }
            }
            if (addFinally) {
                this.myChanges.add(anElem);
            }
            ++i;
        }
    }

    public boolean contains(DeltaElement anElem) {
        int i = 0;
        while (i < this.myChanges.size()) {
            DeltaElement nextElem = (DeltaElement)this.myChanges.get(i);
            if (!nextElem.isExecuted() && nextElem.equals(anElem)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(DeltaElement anElem) {
        int i = 0;
        while (i < this.myChanges.size()) {
            DeltaElement nextElem = (DeltaElement)this.myChanges.get(i);
            if (!nextElem.isExecuted() && nextElem.equals(anElem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] indexesOf(DeltaElement anElem) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.myChanges.size()) {
            DeltaElement nextElem = (DeltaElement)this.myChanges.get(i);
            if (!nextElem.isExecuted() && nextElem.equals(anElem)) {
                indexList.add(new Integer(i));
            }
            ++i;
        }
        int[] result = new int[indexList.size()];
        int j = 0;
        while (j < indexList.size()) {
            result[j] = (Integer)indexList.get(j);
            ++j;
        }
        return result;
    }

    public DeltaElement getObject(int index) {
        return (DeltaElement)this.myChanges.get(index);
    }

    public void remove(int index) {
        this.myChanges.remove(index);
    }

    public void setObject(int index, DeltaElement anElem) {
        String currQval;
        DeltaElement listElem = (DeltaElement)anElem.clone();
        if (this.mySupplierName != null && (currQval = listElem.getMySupplierName()) == null) {
            listElem.setMySupplierName(this.mySupplierName);
        }
        this.myChanges.set(index, listElem);
    }

    public void setOperation(int index, int operationType) {
        DeltaElement target = (DeltaElement)this.myChanges.get(index);
        target.setMyOperation(operationType);
    }

    public void setExecuted(int index) {
        DeltaElement target = (DeltaElement)this.myChanges.get(index);
        target.setExecuted(true);
    }

    public int size() {
        return this.myChanges.size();
    }

    public String getMySupplierName() {
        return this.mySupplierName;
    }

    public boolean isSyncTimeUpdated() {
        return this.syncTimeUpdated;
    }

    public void setMySupplierName(String string) {
        this.mySupplierName = string;
    }

    public void setSyncTimeUpdated(boolean b) {
        this.syncTimeUpdated = b;
    }

    public void processDelta() throws LcrException {
        int i = 0;
        while (i < this.myChanges.size()) {
            DeltaElement nextElem = (DeltaElement)this.myChanges.get(i);
            if (!nextElem.isExecuted()) {
                switch (nextElem.getMyOperation()) {
                    case 1: {
                        this.createObject(nextElem);
                        break;
                    }
                    case 2: {
                        this.modifyObject(nextElem, nextElem.isMergeProperties());
                        break;
                    }
                    case 3: {
                        this.createOrModifyObject(nextElem, nextElem.isMergeProperties());
                        break;
                    }
                    case 4: {
                        this.deleteObject(nextElem);
                        break;
                    }
                    case 5: {
                        this.renameObject(nextElem, nextElem.isMergeProperties());
                    }
                }
                nextElem.setExecuted(true);
            }
            ++i;
        }
        this.elementsProcessed = true;
    }

    public boolean isProcessed() {
        return this.elementsProcessed;
    }

    public int count(int operationType) {
        int count = 0;
        int i = 0;
        while (i < this.myChanges.size()) {
            DeltaElement nextElem = (DeltaElement)this.myChanges.get(i);
            if (nextElem.getMyOperation() == operationType) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public String printCounts() {
        int insertICount = 0;
        int updateICount = 0;
        int modifyICount = 0;
        int deleteICount = 0;
        int renameICount = 0;
        int othersICount = 0;
        int insertACount = 0;
        int updateACount = 0;
        int modifyACount = 0;
        int deleteACount = 0;
        int renameACount = 0;
        int othersACount = 0;
        int i = 0;
        while (i < this.myChanges.size()) {
            DeltaElement nextElem = (DeltaElement)this.myChanges.get(i);
            boolean isAssoc = nextElem.getMyInstanceName().isAssociation();
            if (isAssoc) {
                switch (nextElem.getMyOperation()) {
                    case 1: {
                        ++insertACount;
                        break;
                    }
                    case 2: {
                        ++updateACount;
                        break;
                    }
                    case 3: {
                        ++modifyACount;
                        break;
                    }
                    case 4: {
                        ++deleteACount;
                        break;
                    }
                    case 5: {
                        ++renameACount;
                        break;
                    }
                    default: {
                        ++othersACount;
                        break;
                    }
                }
            } else {
                switch (nextElem.getMyOperation()) {
                    case 1: {
                        ++insertICount;
                        break;
                    }
                    case 2: {
                        ++updateICount;
                        break;
                    }
                    case 3: {
                        ++modifyICount;
                        break;
                    }
                    case 4: {
                        ++deleteICount;
                        break;
                    }
                    case 5: {
                        ++renameICount;
                        break;
                    }
                    default: {
                        ++othersICount;
                    }
                }
            }
            ++i;
        }
        return MessageFormat.format(printCountsMsgFormat, CIMConstants.NEWLINE, new Integer(insertICount), new Integer(updateICount), new Integer(modifyICount), new Integer(deleteICount), new Integer(renameICount), new Integer(othersICount), new Integer(insertACount), new Integer(updateACount), new Integer(modifyACount), new Integer(deleteACount), new Integer(renameACount), new Integer(othersACount));
    }

    public void setSyncTime(DeltaElement obj) throws LcrException {
        CIMInstancename objInstanceName = obj.getMyInstanceName();
        try {
            this.myCIMClient.setProviderSyncTime(objInstanceName, new Date());
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Client exception in delta method setSyncTime for " + objInstanceName.toDisplayString(), cce);
            }
            throw new LcrException(cce);
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("LCR exception in delta method setSyncTime " + objInstanceName.toDisplayString(), lce);
            }
            throw lce;
        }
    }

    public void createObject(DeltaElement obj) throws LcrException {
        CIMInstancename newInstanceName = obj.getMyInstanceName();
        CIMInstance newInstance = obj.getMyInstance();
        if (newInstance == null) {
            return;
        }
        try {
            this.myCIMClient.createInstance(newInstance);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Client exception in delta method createObject " + newInstanceName.toDisplayString(), cce);
            }
            throw new LcrException(cce);
        }
        catch (LcrException lce) {
            if (lce.getStatusCode() != 11) {
                if (CIMTraceUtil.traceLevel >= 3) {
                    myLogger.debug("LCR exception in delta method createObject " + newInstanceName.toDisplayString(), lce);
                }
                throw lce;
            }
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Existing object found in delta method createObject " + newInstanceName.toDisplayString(), lce);
            }
            throw lce;
        }
        if (this.syncTimeUpdated) {
            this.setSyncTime(obj);
        }
    }

    public void modifyObject(DeltaElement obj, boolean merge) throws LcrException {
        CIMInstancename modInstanceName = obj.getMyInstanceName();
        CIMInstance modInstance = obj.getMyInstance();
        if (modInstanceName == null || modInstance == null) {
            return;
        }
        try {
            if (merge) {
                this.myCIMClient.mergeInstance(CIMFactory.valueNamedInstance(modInstanceName, modInstance));
            } else {
                this.myCIMClient.modifyInstance(CIMFactory.valueNamedInstance(modInstanceName, modInstance));
            }
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Client exception in delta method modifyObject " + modInstanceName.toDisplayString(), cce);
            }
            throw new LcrException(cce);
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("LCR exception in delta method modifyObject " + modInstanceName.toDisplayString(), lce);
            }
            throw lce;
        }
        if (this.syncTimeUpdated) {
            this.setSyncTime(obj);
        }
    }

    public void createOrModifyObject(DeltaElement obj, boolean merge) throws LcrException {
        CIMInstancename newInstanceName = obj.getMyInstanceName();
        CIMInstance newInstance = obj.getMyInstance();
        if (newInstance == null) {
            return;
        }
        try {
            this.myCIMClient.createInstance(newInstance);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Client exception in delta method createOrModifyObject " + newInstanceName.toDisplayString(), cce);
            }
            throw new LcrException(cce);
        }
        catch (LcrException lce) {
            if (lce.getStatusCode() != 11) {
                if (CIMTraceUtil.traceLevel >= 3) {
                    myLogger.debug("LCR exception in delta method createOrModifyObject " + newInstanceName.toDisplayString(), lce);
                }
                throw lce;
            }
            this.modifyObject(obj, merge);
        }
        if (this.syncTimeUpdated) {
            this.setSyncTime(obj);
        }
    }

    public void deleteObject(DeltaElement obj) throws LcrException {
        block6: {
            CIMInstancename delInstanceName = obj.getMyInstanceName();
            if (delInstanceName == null) {
                return;
            }
            try {
                this.myCIMClient.deleteInstance(delInstanceName, true);
            }
            catch (CIMClientException cce) {
                if (CIMTraceUtil.traceLevel >= 3) {
                    myLogger.debug("Client exception in delta method deleteObject " + delInstanceName.toDisplayString(), cce);
                }
                throw new LcrException(cce);
            }
            catch (LcrException lce) {
                if (lce.getStatusCode() == 6) break block6;
                if (CIMTraceUtil.traceLevel >= 3) {
                    myLogger.debug("LCR exception in delta method deleteObject " + delInstanceName.toDisplayString(), lce);
                }
                throw lce;
            }
        }
    }

    public void renameObject(DeltaElement renameObj, boolean merge) throws LcrException {
        CIMInstancename oldInstanceName = renameObj.getMyOldInstanceName();
        CIMInstancename newInstanceName = renameObj.getMyInstanceName();
        CIMInstance newInstance = renameObj.getMyInstance();
        if (oldInstanceName == null || newInstanceName == null || newInstance == null) {
            return;
        }
        try {
            this.myCIMClient.renameInstance(oldInstanceName, newInstance, true, true, true, merge);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Client exception in delta method renameObject " + oldInstanceName.toDisplayString() + " -> " + newInstanceName.toDisplayString(), cce);
            }
            throw new LcrException(cce);
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("LCR exception in delta method renameObject " + oldInstanceName.toDisplayString() + " -> " + newInstanceName.toDisplayString(), lce);
            }
            throw lce;
        }
        if (this.syncTimeUpdated) {
            this.setSyncTime(renameObj);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

