/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.util;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.i18n.TextPoolProxy;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;

public class LanguageRepairService {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.util.LanguageRepairService");
    private static final Category sCategoryTexts = Category.getCategory((String)"/MetamodelCore/TranslatableTexts");

    public static synchronized MainDevelopmentObject[] getAffectedMDOs(Metamodel metamodel) {
        ArrayList<DevelopmentObject> lResult = new ArrayList<DevelopmentObject>();
        MetamodelIterator it = metamodel.iterator();
        while (it.hasNext()) {
            TextPoolProxy lTextPool;
            DevelopmentObject lObject = it.next();
            if (!lObject.isMDO() || lObject.originatesInArchive() || !LanguageRepairService.containsOrphans(lTextPool = (TextPoolProxy)((MainDevelopmentObject)lObject).getTextPool())) continue;
            lResult.add(lObject);
        }
        return lResult.toArray(new MainDevelopmentObject[0]);
    }

    public static synchronized void repair(Metamodel metamodel) {
        LanguageRepairService.repair(LanguageRepairService.getAffectedMDOs(metamodel));
    }

    public static synchronized void repair(MainDevelopmentObject[] mdos) {
        String method = "repair()";
        int i = 0;
        while (i < mdos.length) {
            TextPoolProxy lTextPool = (TextPoolProxy)mdos[i].getTextPool();
            if (LanguageRepairService.containsOrphans(lTextPool)) {
                String[] lLanguages = lTextPool.getAvailableLanguages();
                String lReadOnlyLanguages = "";
                int j = 0;
                while (j < lLanguages.length) {
                    if (lTextPool.isReadOnly(lLanguages[j])) {
                        lReadOnlyLanguages = lLanguages[j].equals("") ? lReadOnlyLanguages + "/<raw language>" : lReadOnlyLanguages + "/" + lLanguages[j];
                    }
                    ++j;
                }
                if (lReadOnlyLanguages.length() > 0) {
                    lReadOnlyLanguages = lReadOnlyLanguages.substring(1);
                    sCategoryTexts.errorT(sLocation, "repair()", "could not delete text orphans in MDO: " + ((DevelopmentObjectProxy)((Object)mdos[i]))._getKey() + ", language file(s) read-only for language(s): " + lReadOnlyLanguages);
                } else {
                    try {
                        lTextPool.repair();
                    }
                    catch (DeleteException ex) {
                        sCategoryTexts.errorT(sLocation, "repair()", "could not delete text orphans in MDO: " + ((DevelopmentObjectProxy)((Object)mdos[i]))._getKey() + ", " + ex.getMessage());
                    }
                }
            }
            ++i;
        }
    }

    private static boolean containsOrphans(TextPoolProxy textPool) {
        TranslatableText[] lTextObjects = textPool.getTexts();
        int i = 0;
        while (i < lTextObjects.length) {
            TranslatableText lTextObject = lTextObjects[i];
            if (lTextObject.getDevelopmentObject() == null) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

